/*
 * Decompiled with CFR 0.152.
 */
package world;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class MapRepository {
    File repository;
    int levels = 0;

    public MapRepository(String directory) {
        String[] repFiles;
        this.repository = new File(directory);
        if (!this.repository.exists()) {
            this.repository.mkdirs();
        } else if (!this.repository.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(directory) + " is not a directory");
        }
        String[] stringArray = repFiles = this.repository.list();
        int n = repFiles.length;
        int n2 = 0;
        while (n2 < n) {
            int level;
            String fileName = stringArray[n2];
            if (fileName.length() == 10 && (level = Integer.parseInt(fileName.substring(0, 2))) > this.levels) {
                this.levels = level;
            }
            ++n2;
        }
    }

    public BufferedImage composeImage(int level, int xCoord, int yCoord, String suffixes) throws IOException {
        BufferedImage image = this.getImage(level, xCoord, yCoord, ' ');
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int i = 0;
        while (i < suffixes.length()) {
            BufferedImage ovImage = this.getImage(level, xCoord, yCoord, suffixes.charAt(i));
            graphics2D.drawImage(ovImage, 0, 0, 256, 256, null);
            ++i;
        }
        return image;
    }

    public void extractOverlay(File imageFile, int level, int xCoord, int yCoord, char suffix) throws IOException {
        BufferedImage bufImage;
        if (imageFile.exists()) {
            BufferedImage image = ImageIO.read(imageFile);
            System.err.println("Got overlay from file " + imageFile);
            if (image.getHeight(null) != 256 || image.getWidth(null) != 256) {
                throw new IOException("Image is incorrect size");
            }
            BufferedImage baseImg = this.getImage(level, xCoord, yCoord, ' ');
            bufImage = new BufferedImage(256, 256, 2);
            int x = 0;
            while (x < 256) {
                int y = 0;
                while (y < 256) {
                    int baseColor = baseImg.getRGB(x, y);
                    int ovColor = image.getRGB(x, y);
                    if (ovColor == baseColor) {
                        bufImage.setRGB(x, y, 0);
                    } else {
                        ovColor = 0x7F000000 | ovColor & 0xFFFFFF;
                        bufImage.setRGB(x, y, ovColor);
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            throw new IOException("File does not exist: " + imageFile);
        }
        this.storeScaledImage(bufImage, level, xCoord, yCoord, suffix, true);
    }

    public BufferedImage getImage(int level, int xCoord, int yCoord, char suffix) throws IOException {
        if (!this.isValid(level, xCoord, yCoord)) {
            throw new IllegalArgumentException("Coordinates too big for level: " + level + ", " + xCoord + ", " + yCoord);
        }
        String imageName = this.toImageName(level, xCoord, yCoord, suffix);
        File imageFile = new File(this.repository, String.valueOf(imageName) + ".png");
        BufferedImage image = null;
        if (imageFile.exists()) {
            image = ImageIO.read(imageFile);
        } else if (level > 1) {
            BufferedImage parent = this.getImage(level - 1, xCoord / 2, yCoord / 2, suffix);
            BufferedImage parentBuf = this.scaleImage(parent, 512);
            int xStart = xCoord % 2 == 0 ? 0 : 256;
            int yStart = yCoord % 2 == 0 ? 0 : 256;
            image = parentBuf.getSubimage(xStart, yStart, 256, 256);
        }
        return image;
    }

    private boolean isValid(int level, int xCoord, int yCoord) {
        int maxCoord = 1 << level - 1;
        return maxCoord > xCoord && maxCoord > yCoord;
    }

    private BufferedImage scaleImage(Image image, int size) {
        BufferedImage bufImage = new BufferedImage(size, size, 2);
        Graphics2D graphics2D = bufImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, size, size, null);
        return bufImage;
    }

    public void storeScaledImage(File imageFile, int level, int xCoord, int yCoord, char suffix) throws IOException {
        if (imageFile.exists()) {
            BufferedImage image = ImageIO.read(imageFile);
            System.err.println("Got image from file " + imageFile);
            this.storeScaledImage(image, level, xCoord, yCoord, suffix, true);
        } else {
            System.err.println("File does not exist: " + imageFile);
        }
    }

    private void storeScaledImage(Image image, int level, int xCoord, int yCoord, char suffix, boolean updateParent) throws IOException {
        if (!this.isValid(level, xCoord, yCoord)) {
            throw new IllegalArgumentException("Coordinates too big for level: " + level + ", " + xCoord + ", " + yCoord);
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int size = Math.max(width, height);
        int imgSize = 256;
        while (imgSize < size) {
            imgSize *= 2;
        }
        BufferedImage bigImage = this.scaleImage(image, size);
        if (size > 256) {
            int small = size / 2;
            BufferedImage ul = bigImage.getSubimage(0, 0, small, small);
            this.storeScaledImage(ul, level + 1, xCoord * 2, yCoord * 2, suffix, false);
            BufferedImage ur = bigImage.getSubimage(small, 0, small, small);
            this.storeScaledImage(ur, level + 1, xCoord * 2 + 1, yCoord * 2, suffix, false);
            BufferedImage ll = bigImage.getSubimage(0, small, small, small);
            this.storeScaledImage(ll, level + 1, xCoord * 2, yCoord * 2 + 1, suffix, false);
            BufferedImage lr = bigImage.getSubimage(small, small, small, small);
            this.storeScaledImage(lr, level + 1, xCoord * 2 + 1, yCoord * 2 + 1, suffix, false);
        }
        BufferedImage tileImage = this.scaleImage(image, 256);
        String imageName = this.toImageName(level, xCoord, yCoord, suffix);
        File imageFile = new File(this.repository, String.valueOf(imageName) + ".png");
        ImageIO.write((RenderedImage)tileImage, "PNG", imageFile);
        if (updateParent && level > 1) {
            this.updateFromChildren(level - 1, xCoord / 2, yCoord / 2, suffix);
        }
    }

    private String toImageName(int level, int xCoord, int yCoord, char suffix) {
        return String.valueOf(level > 9 ? Integer.toString(level) : "0" + level) + (xCoord > 9 ? Integer.toString(xCoord) : "0" + xCoord) + (yCoord > 9 ? Integer.toString(yCoord) : "0" + yCoord) + (Character.isWhitespace(suffix) ? "" : Character.valueOf(Character.toUpperCase(suffix)));
    }

    public void updateFromChildren(int level, int xCoord, int yCoord, char suffix) throws IOException {
        if (!this.isValid(level, xCoord, yCoord)) {
            throw new IllegalArgumentException("Coordinates too big for level: " + level + ", " + xCoord + ", " + yCoord);
        }
        BufferedImage ul = this.getImage(level + 1, xCoord * 2, yCoord * 2, suffix);
        BufferedImage ur = this.getImage(level + 1, xCoord * 2 + 1, yCoord * 2, suffix);
        BufferedImage ll = this.getImage(level + 1, xCoord * 2, yCoord * 2 + 1, suffix);
        BufferedImage lr = this.getImage(level + 1, xCoord * 2 + 1, yCoord * 2 + 1, suffix);
        BufferedImage image = new BufferedImage(512, 512, 2);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(ul, 0, 0, 256, 256, null);
        graphics2D.drawImage(ur, 256, 0, 256, 256, null);
        graphics2D.drawImage(ll, 0, 256, 256, 256, null);
        graphics2D.drawImage(lr, 256, 256, 256, 256, null);
        BufferedImage tileImage = this.scaleImage(image, 256);
        String imageName = this.toImageName(level, xCoord, yCoord, suffix);
        File imageFile = new File(this.repository, String.valueOf(imageName) + ".png");
        ImageIO.write((RenderedImage)tileImage, "PNG", imageFile);
        if (level > 1) {
            this.updateFromChildren(level - 1, xCoord / 2, yCoord / 2, suffix);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("java MapRepository location imageFile: Stores the image as the base map");
            System.out.println("java MapRepository location imageFile level xCoord yCoord: Stores the image as the map at the specified level and coordinate");
            System.out.println("java MapRepository location imageFile level xCoord yCoord feature: Stores the differences in the image and the underlying map as an overlay image with the specified feature character");
        } else {
            MapRepository repos = new MapRepository(args[0]);
            File imageFile = new File(args[1]);
            int xCoord = 0;
            int yCoord = 0;
            int level = 1;
            if (args.length > 4) {
                level = Integer.parseInt(args[2]);
                xCoord = Integer.parseInt(args[3]);
                yCoord = Integer.parseInt(args[4]);
            }
            if (args.length > 5) {
                char ovChar = args[5].charAt(0);
                repos.extractOverlay(imageFile, level, xCoord, yCoord, ovChar);
            } else {
                repos.storeScaledImage(imageFile, level, xCoord, yCoord, ' ');
            }
        }
    }
}

