/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import rpg.wwchar.GenChar;
import rpg.wwchar.Gift;
import rpg.wwchar.HealthDisplay;
import rpg.wwchar.WWRatingList;
import rpg.wwchar.WWTrait;

public class Werewolf
extends GenChar {
    private static final long serialVersionUID = -3459265275816825363L;
    WWTrait gnosis;
    WWTrait rage;
    WWTrait glory;
    WWTrait honor;
    WWTrait wisdom;
    String tribe;
    String auspice;
    String breed;
    int rank;
    Vector gifts;
    Vector rites;
    List gList = new List();

    public Werewolf(JPanel head, JPanel attr, JPanel abil, JPanel spec, JPanel botm, int mode) {
        super(head, attr, abil, spec, botm, mode);
    }

    public Gift chooseGift(Component comp, String who, int maxRank) {
        return null;
    }

    public void setAuspice(String theAuspice) {
        this.auspice = new String(theAuspice);
        if (this.auspice.equals("Ragabash")) {
            this.rage.setMinimum(1);
        } else if (this.auspice.equals("Theurge")) {
            this.rage.setMinimum(2);
        } else if (this.auspice.equals("Philodox")) {
            this.rage.setMinimum(3);
        } else if (this.auspice.equals("Galliard")) {
            this.rage.setMinimum(4);
        } else if (this.auspice.equals("Ahroun")) {
            this.rage.setMinimum(5);
        }
    }

    public void setBreed(String theBreed) {
        this.breed = new String(theBreed);
        if (this.breed.equals("Homid")) {
            this.gnosis.setMinimum(1);
        } else if (this.breed.equals("Metis")) {
            this.gnosis.setMinimum(3);
        } else if (this.breed.equals("Lupus")) {
            this.gnosis.setMinimum(5);
        }
    }

    @Override
    public void setGroup(String theTribe) {
        this.tribe = new String(theTribe);
        if (this.tribe.equals("Bone Gnawers")) {
            this.backgrounds.setHidden("Past Life, Pure Breed, Resources");
            this.willpower.setMinimum(4);
        } else if (this.tribe.equals("Children of Gaia")) {
            this.willpower.setMinimum(4);
        } else if (this.tribe.equals("Get of Fenris")) {
            this.backgrounds.setHidden("Contacts, Mentor");
            this.willpower.setMinimum(3);
        } else if (this.tribe.equals("Glass Walkers")) {
            this.backgrounds.setHidden("Past Life, Pure Breed, Mentor");
            this.willpower.setMinimum(3);
        } else if (this.tribe.equals("Red Talons")) {
            this.backgrounds.setHidden("Allies, Contacts, Resources");
            this.willpower.setMinimum(3);
        } else if (this.tribe.equals("Shadow Lords")) {
            this.backgrounds.setHidden("Allies, Mentor");
            this.willpower.setMinimum(3);
        } else if (this.tribe.equals("Silent Striders")) {
            this.backgrounds.setHidden("Past Life, Resources");
            this.willpower.setMinimum(3);
        } else if (this.tribe.equals("Silver Fangs")) {
            this.backgrounds.getRating("Pure Breed").setMinimum(3);
            this.willpower.setMinimum(3);
        } else if (this.tribe.equals("Stargazers")) {
            this.backgrounds.setHidden("Allies, Fetish, Resources");
            this.willpower.setMinimum(5);
        } else if (this.tribe.equals("Wendigo")) {
            this.backgrounds.setHidden("Contacts, Resources");
            this.willpower.setMinimum(4);
        } else {
            this.backgrounds.setHidden("");
            this.willpower.setMinimum(3);
        }
    }

    @Override
    public WWRatingList setupBackgrounds() {
        String[] wwBack = new String[]{"Fetish", "Past Life", "Pure Breed", "Rites"};
        this.backgrounds = new WWRatingList(wwBack);
        return this.backgrounds;
    }

    @Override
    public JPanel setupBottom(JPanel p) {
        this.gnosis = new WWTrait("Gnosis");
        this.rage = new WWTrait("Rage");
        this.glory = new WWTrait("Glory");
        this.honor = new WWTrait("Honor");
        this.wisdom = new WWTrait("Wisdom");
        JPanel renown = new JPanel(new GridLayout(1, 0));
        renown.add(this.glory);
        renown.add(this.honor);
        renown.add(this.wisdom);
        JPanel traits = new JPanel(new GridLayout(1, 0));
        traits.add(this.rage);
        traits.add(this.gnosis);
        traits.add(this.willpower);
        p.add(renown);
        p.add(traits);
        HealthDisplay hd = new HealthDisplay();
        p.add(hd);
        return p;
    }

    @Override
    public JPanel setupHeader(JPanel p) {
        this.groupChoice.addItem("Black Furies");
        this.groupChoice.addItem("Bone Gnawers");
        this.groupChoice.addItem("Children of Gaia");
        this.groupChoice.addItem("Fianna");
        this.groupChoice.addItem("Get of Fenris");
        this.groupChoice.addItem("Glass Walkers");
        this.groupChoice.addItem("Red Talons");
        this.groupChoice.addItem("Shadow Lords");
        this.groupChoice.addItem("Silent Striders");
        this.groupChoice.addItem("Silver Fangs");
        this.groupChoice.addItem("Stargazers");
        this.groupChoice.addItem("Uktena");
        this.groupChoice.addItem("Wendigo");
        this.groupChoice.addItem("Bunyip");
        this.groupChoice.addItem("Black Spiral Dancer");
        this.groupChoice.addItem("Ronin");
        this.groupChoice.addItem("Skindancer");
        final Choice auspiceChoice = new Choice();
        auspiceChoice.addItem("Ragabash");
        auspiceChoice.addItem("Theurge");
        auspiceChoice.addItem("Philodox");
        auspiceChoice.addItem("Galliard");
        auspiceChoice.addItem("Ahroun");
        final Choice breedChoice = new Choice();
        breedChoice.addItem("Homid");
        breedChoice.addItem("Metis");
        breedChoice.addItem("Lupus");
        auspiceChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Werewolf.this.setAuspice(auspiceChoice.getSelectedItem());
            }
        });
        breedChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Werewolf.this.setBreed(breedChoice.getSelectedItem());
            }
        });
        TextField namefield = new TextField("Name: ", 20);
        TextField playerfield = new TextField("Player: ", 20);
        p.add(namefield);
        p.add(breedChoice);
        p.add(new TextField("Pack Name: ", 20));
        p.add(playerfield);
        p.add(auspiceChoice);
        p.add(new TextField("Pack Totem: ", 20));
        p.add(new TextField("Chronicle ", 20));
        p.add(this.groupChoice);
        p.add(new TextField("Concept: ", 20));
        return p;
    }

    @Override
    public WWRatingList setupKnowledges() {
        String[] wwKnowledges = new String[]{"Occult", "Rituals"};
        this.knowledges = super.setupKnowledges();
        this.knowledges.addRatings(wwKnowledges);
        return this.knowledges;
    }

    @Override
    public WWRatingList setupSkills() {
        String[] wwSkills = new String[]{"Animal Ken", "Leadership", "Repair"};
        this.skills = super.setupSkills();
        this.skills.addRatings(wwSkills);
        return this.skills;
    }

    @Override
    public JPanel setupSpecial(JPanel p) {
        int i;
        JButton[] butns = new JButton[]{new JButton("Breed Gift"), new JButton("Auspice Gift"), new JButton("Tribe Gift")};
        JButton addB = new JButton("Add Gift");
        p.removeAll();
        p.add(this.backgrounds);
        JPanel giftDisp = new JPanel(new GridLayout(1, 0));
        p.add(giftDisp);
        p.add(this.gList);
        if (this.gifts == null) {
            this.gifts = new Vector();
            i = 0;
            while (i < 3) {
                this.gifts.addElement(butns[i]);
                ++i;
            }
            addB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton b = (JButton)e.getSource();
                    Gift g = Werewolf.this.chooseGift(b, new String(String.valueOf(Werewolf.this.breed) + Werewolf.this.tribe + Werewolf.this.auspice), 1);
                    Werewolf.this.gifts.addElement(g);
                    Container pane = b.getParent();
                    pane.add((Component)new Label(g.name), 3);
                }
            });
            butns[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton b = (JButton)e.getSource();
                    Gift g = Werewolf.this.chooseGift(b, Werewolf.this.breed, 1);
                    if (Werewolf.this.gifts.elementAt(0) != null) {
                        Gift g2 = (Gift)Werewolf.this.gifts.elementAt(0);
                        Werewolf.this.gList.remove(g2.name);
                    }
                    Werewolf.this.gList.add(g.name);
                    Werewolf.this.gifts.setElementAt(g, 0);
                    b.setLabel(g.name);
                    b.invalidate();
                }
            });
            butns[1].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton b = (JButton)e.getSource();
                    Gift g = Werewolf.this.chooseGift(b, Werewolf.this.auspice, 1);
                    if (Werewolf.this.gifts.elementAt(1) != null) {
                        Gift g2 = (Gift)Werewolf.this.gifts.elementAt(1);
                        Werewolf.this.gList.remove(g2.name);
                    }
                    Werewolf.this.gList.add(g.name);
                    Werewolf.this.gifts.setElementAt(g, 1);
                    b.setLabel(g.name);
                    b.invalidate();
                }
            });
            butns[2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton b = (JButton)e.getSource();
                    Gift g = Werewolf.this.chooseGift(b, Werewolf.this.tribe, 1);
                    if (Werewolf.this.gifts.elementAt(2) != null) {
                        Gift g2 = (Gift)Werewolf.this.gifts.elementAt(2);
                        Werewolf.this.gList.remove(g2.name);
                    }
                    Werewolf.this.gList.add(g.name);
                    Werewolf.this.gifts.setElementAt(g, 2);
                    b.setLabel(g.name);
                    b.invalidate();
                }
            });
        }
        i = 0;
        while (i < this.gifts.size()) {
            Object obj = this.gifts.elementAt(i);
            if (obj instanceof Gift) {
                giftDisp.add(new Label(((Gift)obj).name));
            } else if (obj instanceof JButton) {
                giftDisp.add((JButton)obj);
            }
            giftDisp.add(addB);
            ++i;
        }
        if (this.rites == null) {
            this.rites = new Vector();
        }
        return p;
    }

    @Override
    public WWRatingList setupTalents() {
        String[] wwTalents = new String[]{"Primal Urge"};
        this.talents = super.setupTalents();
        this.talents.addRatings(wwTalents);
        return this.talents;
    }

    @Override
    public void setYear(int theYear) {
        this.year = theYear;
        this.groupChoice.removeAll();
        if (this.year > 1900 && this.year < 2000) {
            String[] tribes;
            String[] stringArray = tribes = new String[]{"Black Furies", "Bone Gnawers", "Children of Gaia", "Fianna", "Get of Fenris", "Glass Walkers", "Red Talons", "Shadow Lords", "Silent Striders", "Silver Fangs", "Stargazers", "Uktena", "Wendigo", "Ronin", "Black Spiral Dancers", "SkinDancers"};
            int n = tribes.length;
            int n2 = 0;
            while (n2 < n) {
                String tribe2 = stringArray[n2];
                this.groupChoice.addItem(tribe2);
                ++n2;
            }
        } else if (this.year > 1600 && this.year <= 1900) {
            String[] tribes;
            String[] stringArray = tribes = new String[]{"Black Furies", "Bone Gnawers", "Bunyip", "Children of Gaia", "Fianna", "Get of Fenris", "Iron Riders", "Red Talons", "Shadow Lords", "Silent Striders", "Silver Fangs", "StarGazers", "Uktena", "Wendigo", "Ronin", "Black Spiral Dancers"};
            int n = tribes.length;
            int n3 = 0;
            while (n3 < n) {
                String tribe2 = stringArray[n3];
                this.groupChoice.addItem(tribe2);
                ++n3;
            }
        } else if (this.year > 50 && this.year <= 1600) {
            String[] tribes;
            String[] stringArray = tribes = new String[]{"Black Furies", "Bone Gnawers", "Bunyip", "Children of Gaia", "Croatan", "Fianna", "Get of Fenris", "Red Talons", "Shadow Lords", "Silent Striders", "Silver Fangs", "StarGazers", "Uktena", "Warders", "Wendigo", "Ronin", "Black Spiral Dancers"};
            int n = tribes.length;
            int n4 = 0;
            while (n4 < n) {
                String tribe2 = stringArray[n4];
                this.groupChoice.addItem(tribe2);
                ++n4;
            }
        }
        this.groupChoice.select(this.tribe);
    }

    @Override
    public boolean verifyStartingChar() {
        int gnAdded;
        int[] abilTots = new int[]{13, 9, 5};
        int[] attrTots = new int[]{7, 5, 3};
        int bonus = this.freebiePoints(15, 5, attrTots, 2, abilTots, 5, 1);
        System.out.println("WW Bonus: " + bonus);
        int rgAdded = this.rage.getValue() - this.rage.getMinimum();
        if (rgAdded > 0) {
            bonus -= rgAdded;
        }
        if ((gnAdded = this.gnosis.getValue() - this.gnosis.getMinimum()) > 0) {
            bonus -= gnAdded * 2;
        }
        if (this.gifts.size() > 3) {
            bonus -= (this.gifts.size() - 3) * 7;
        }
        return bonus > 0;
    }
}

