/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class WWTrait
extends Canvas
implements Adjustable {
    private static final long serialVersionUID = -3149352957206076139L;
    String name;
    int rating;
    int temp_rating;
    int minVal;
    int maxVal = 10;
    private AdjustmentListener adjustmentListener = null;

    public WWTrait(String stat) {
        this.name = new String(stat);
        this.rating = 0;
        this.enableEvents(500L);
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public int getMaximum() {
        return this.maxVal;
    }

    @Override
    public int getMinimum() {
        return this.minVal;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 60);
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public int getValue() {
        return this.rating;
    }

    @Override
    public int getVisibleAmount() {
        return this.maxVal;
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = 100 - fm.stringWidth(this.name) / 2;
        g.drawString(this.name, x, 10);
        int i = 0;
        while (i < 10) {
            g.drawRect(26 + i * 16, 14, 8, 12);
            if (i < this.rating) {
                g.fillOval(24 + i * 16, 34, 12, 12);
            } else {
                g.drawOval(24 + i * 16, 34, 12, 12);
            }
            ++i;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int adjType = 0;
        if (e.getID() == 500) {
            int x = e.getX();
            int y = e.getY();
            if (y > 34 && y < 46) {
                int pip = 1 + x / 20;
                if (pip > this.rating) {
                    ++this.rating;
                    adjType = 1;
                } else {
                    --this.rating;
                    adjType = 2;
                }
            }
            this.repaint();
            if (this.adjustmentListener != null) {
                this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, adjType, this.rating));
            }
        }
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public void setBlockIncrement(int inc) {
    }

    @Override
    public void setMaximum(int max) {
        this.maxVal = max;
        this.repaint();
    }

    @Override
    public void setMinimum(int min) {
        if (this.rating < min) {
            this.minVal = min;
            this.rating = min;
            this.repaint();
        }
    }

    public void setOrientation(int orient) {
    }

    @Override
    public void setUnitIncrement(int inc) {
    }

    @Override
    public void setValue(int val) {
        this.rating = val;
        this.repaint();
    }

    @Override
    public void setVisibleAmount(int value) {
    }
}

