/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.AWTEventMulticaster;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import rpg.wwchar.WWChoiceRating;
import rpg.wwchar.WWEntryRating;
import rpg.wwchar.WWRating;

public class WWRatingList
extends JPanel
implements AdjustmentListener {
    private static final long serialVersionUID = -2968393693543657998L;
    ArrayList<WWRating> recs = new ArrayList();
    int columns = 1;
    boolean condensed = false;
    private ActionListener actionListener = null;

    public WWRatingList() {
    }

    public WWRatingList(String[] names) {
        this.setLayout(new GridLayout(0, this.columns));
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            if (name2.indexOf(47) != -1) {
                WWChoiceRating wwc = new WWChoiceRating(name2);
                this.recs.add(wwc);
                this.add(wwc);
            } else if (name2.indexOf(42) != -1) {
                WWEntryRating wwe = new WWEntryRating(name2);
                this.recs.add(wwe);
                this.add(wwe);
            } else {
                WWRating newRating = new WWRating(name2);
                this.recs.add(newRating);
                this.add(newRating);
            }
            ++n2;
        }
        this.recs.trimToSize();
    }

    public WWRatingList(String[] names, int cols) {
        this.columns = cols;
        this.setLayout(new GridLayout(0, this.columns));
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            if (name2.indexOf(47) != -1) {
                WWChoiceRating wwc = new WWChoiceRating(name2);
                this.recs.add(wwc);
            } else if (name2.indexOf(42) != -1) {
                WWEntryRating wwe = new WWEntryRating(name2);
                this.recs.add(wwe);
            } else {
                WWRating newRating = new WWRating(name2);
                this.recs.add(newRating);
            }
            ++n2;
        }
        this.recs.trimToSize();
        int rows = (int)Math.ceil(names.length / this.columns);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < this.columns) {
                WWRating rating = this.recs.get(i + j * rows);
                this.add(rating);
                ++j;
            }
            ++i;
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            rating.addAdjustmentListener(this);
            ++i;
        }
    }

    public void addRatings(String[] names) {
        int i = 0;
        int j = 0;
        while (j < names.length) {
            if (i < this.recs.size()) {
                WWRating rating = this.recs.get(i);
                int cmp = rating.name.compareTo(names[j]);
                if (cmp < 0) {
                    ++i;
                    continue;
                }
                if (cmp <= 0) continue;
                if (names[j].indexOf(47) != -1) {
                    this.recs.add(i, new WWChoiceRating(names[j]));
                } else if (names[j].indexOf(42) != -1) {
                    this.recs.add(i, new WWEntryRating(names[j]));
                } else {
                    this.recs.add(i, new WWRating(names[j]));
                }
                ++i;
                ++j;
                continue;
            }
            if (names[j].indexOf(47) != -1) {
                this.recs.add(new WWChoiceRating(names[j]));
            } else if (names[j].indexOf(42) != -1) {
                this.recs.add(new WWEntryRating(names[j]));
            } else {
                this.recs.add(new WWRating(names[j]));
            }
            ++i;
            ++j;
        }
        this.expandDisplay();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        System.out.println("Total now: " + this.totalValues());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Rating List"));
        }
    }

    public void condenseDisplay(boolean append) {
        Vector<WWRating> tmp = new Vector<WWRating>();
        Choice unset = new Choice();
        this.removeAll();
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            if (rating.getValue() > 0) {
                tmp.add(rating);
            } else if (append) {
                unset.addItem(rating.name);
            }
            ++i;
        }
        int rows = (int)Math.ceil(tmp.size() / this.columns);
        int i2 = 0;
        while (i2 < rows) {
            int j = 0;
            while (j < this.columns) {
                WWRating rating = (WWRating)tmp.get(i2 + j * rows);
                this.add(rating);
                ++j;
            }
            ++i2;
        }
        if (append) {
            this.add(unset);
        }
    }

    public void emphasize(String nameList) {
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            rating.setEmphasis(nameList.indexOf(rating.name) > -1);
            ++i;
        }
    }

    public void emphasize(String[] names) {
        int i = 0;
        while (i < this.recs.size()) {
            this.recs.get(i);
            ++i;
        }
    }

    public void expandDisplay() {
        this.removeAll();
        int rows = (int)Math.ceil(this.recs.size() / this.columns);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < this.columns) {
                WWRating rating = this.recs.get(i + j * rows);
                this.add(rating);
                ++j;
            }
            ++i;
        }
    }

    public WWRating getRating(int inx) {
        return this.recs.get(inx);
    }

    public WWRating getRating(String name) {
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            if (rating.name.equals(name)) {
                return rating;
            }
            ++i;
        }
        return null;
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            rating.removeAdjustmentListener(this);
            ++i;
        }
    }

    public void setHidden(String nameList) {
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            rating.setVisible(nameList.indexOf(rating.name) == -1);
            ++i;
        }
    }

    public void setValue(String name, int val) {
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            if (rating.name.equals(name)) {
                rating.setValue(val);
            }
            ++i;
        }
    }

    public int totalValues() {
        int accum = 0;
        int i = 0;
        while (i < this.recs.size()) {
            WWRating rating = this.recs.get(i);
            accum += rating.getValue();
            ++i;
        }
        return accum;
    }
}

