/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class WWRating
extends Canvas
implements Adjustable {
    private static final long serialVersionUID = -3918609982893852012L;
    String name;
    int rating;
    int minVal;
    int maxVal;
    boolean emphasis = false;
    private AdjustmentListener adjustmentListener = null;
    private boolean editable = true;

    public WWRating(String stat) {
        this(stat, 0, 5);
    }

    public WWRating(String stat, int val) {
        this(stat, val, 5);
    }

    public WWRating(String stat, int val, int max) {
        this.name = new String(stat);
        this.rating = val;
        this.maxVal = max;
        this.enableEvents(500L);
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public int getMaximum() {
        return this.maxVal;
    }

    @Override
    public int getMinimum() {
        return this.minVal;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 20);
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public int getValue() {
        return this.rating;
    }

    @Override
    public int getVisibleAmount() {
        return this.maxVal;
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int y = (20 - fm.getHeight()) / 2 + fm.getAscent();
        int startx = 201 - 12 * this.maxVal;
        g.drawString(this.name, 10, y);
        int i = 0;
        while (i < this.maxVal) {
            if (i < this.rating) {
                g.fillOval(startx + i * 12, 5, 10, 10);
            } else {
                g.drawOval(startx + i * 12, 5, 10, 10);
            }
            ++i;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int adjType = 0;
        if (e.getID() == 500) {
            int x = e.getX();
            int y = e.getY();
            int startx = 200 - this.maxVal * 12;
            if (x > startx && y > 4 && y < 16) {
                int pip = 1 + (x - startx) / 12;
                if (pip > this.rating) {
                    ++this.rating;
                    adjType = 1;
                } else {
                    --this.rating;
                    adjType = 2;
                }
            }
            this.repaint();
            if (this.adjustmentListener != null) {
                this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, adjType, this.rating));
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public void setBlockIncrement(int inc) {
    }

    public void setEditable(boolean mode) {
        this.editable = mode;
        if (this.editable) {
            this.enableEvents(500L);
        } else {
            this.disableEvents(500L);
        }
    }

    public void setEmphasis(boolean emph) {
        this.emphasis = emph;
        Font fnt = this.getFont();
        if (emph) {
            this.setFont(new Font(fnt.getName(), 1, fnt.getSize()));
        } else {
            this.setFont(new Font(fnt.getName(), 0, fnt.getSize()));
        }
        this.repaint();
    }

    @Override
    public void setMaximum(int max) {
        this.maxVal = max;
        this.repaint();
    }

    @Override
    public void setMinimum(int min) {
        if (this.rating < min) {
            this.minVal = min;
            this.rating = min;
            this.repaint();
        }
    }

    public void setOrientation(int orient) {
    }

    @Override
    public void setUnitIncrement(int inc) {
    }

    @Override
    public void setValue(int val) {
        this.rating = val;
        if (val > this.maxVal) {
            this.maxVal = val;
        }
        this.repaint();
    }

    @Override
    public void setVisibleAmount(int value) {
    }

    @Override
    public String toString() {
        return new String(String.valueOf(this.name) + " " + this.rating);
    }
}

