/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JPanel;
import rpg.wwchar.Changeling;
import rpg.wwchar.GenChar;
import rpg.wwchar.Mage;
import rpg.wwchar.Vampire;
import rpg.wwchar.Werewolf;

public class WWChar
extends Frame
implements Serializable,
ActionListener {
    private static final long serialVersionUID = -2722931364984579254L;
    GenChar myChar;
    GridLayout gl = new GridLayout(0, 3);
    MenuBar mbar = new MenuBar();
    JPanel head = new JPanel(this.gl);
    JPanel attr = new JPanel();
    JPanel abil = new JPanel(this.gl);
    JPanel spec = new JPanel();
    JPanel botm = new JPanel(this.gl);
    String filename;

    public WWChar() {
        this.setFont(new Font("TimesRoman", 0, 12));
        this.setLayout(new GridLayout(1, 0));
        this.add(this.head);
        this.add(this.attr);
        this.add(this.abil);
        this.add(this.spec);
        this.add(this.botm);
        Menu fileMenu = new Menu("File");
        new Menu("Edit");
        new Menu("View");
        Menu gameMenu = new Menu("Game");
        Menu yearMenu = new Menu("Year");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MenuItem nw = new MenuItem("New");
        MenuItem opn = new MenuItem("Open");
        MenuItem sav = new MenuItem("Save");
        MenuItem qu = new MenuItem("Quit");
        opn.addActionListener(this);
        sav.addActionListener(this);
        qu.addActionListener(this);
        fileMenu.add(nw);
        fileMenu.add(opn);
        fileMenu.add(sav);
        fileMenu.add(qu);
        MenuItem ch = new MenuItem("Changeling");
        ch.addActionListener(this);
        MenuItem mg = new MenuItem("Mage");
        mg.addActionListener(this);
        MenuItem vm = new MenuItem("Vampire");
        vm.addActionListener(this);
        MenuItem ww = new MenuItem("Werewolf");
        ww.addActionListener(this);
        MenuItem wr = new MenuItem("Wraith");
        gameMenu.add(ch);
        gameMenu.add(mg);
        gameMenu.add(vm);
        gameMenu.add(ww);
        gameMenu.add(wr);
        gameMenu.add("Other");
        MenuItem yrda = new MenuItem("1190: Dark Ages");
        MenuItem yrer = new MenuItem("1450: Early Renaissance");
        MenuItem yrww = new MenuItem("1850: Wild West/Victorian");
        MenuItem yrgw = new MenuItem("1918: Post WW1");
        MenuItem yrpr = new MenuItem("1995: Pre-Reckoning");
        MenuItem yrrc = new MenuItem("1999: Reckoning");
        yrda.addActionListener(this);
        yrer.addActionListener(this);
        yrww.addActionListener(this);
        yrgw.addActionListener(this);
        yrpr.addActionListener(this);
        yrrc.addActionListener(this);
        yearMenu.add(yrda);
        yearMenu.add(yrer);
        yearMenu.add(yrww);
        yearMenu.add(yrgw);
        yearMenu.add(yrpr);
        yearMenu.add(yrrc);
        yearMenu.add("Other Year");
        this.mbar.add(fileMenu);
        this.mbar.add(gameMenu);
        this.mbar.add(yearMenu);
        this.setMenuBar(this.mbar);
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        String label;
        Object event = a.getSource();
        if (event instanceof MenuItem && !(label = ((MenuItem)event).getLabel()).equals("New")) {
            String nums;
            if (label.equals("Open")) {
                this.loadChar();
            } else if (label.equals("Save")) {
                this.saveChar();
            } else if (label.equals("Quit")) {
                System.exit(0);
            } else if (label.equals("Changeling")) {
                this.myChar = new Changeling(this.head, this.attr, this.abil, this.spec, this.botm, 1);
                this.pack();
                this.show();
            } else if (label.equals("Mage")) {
                this.myChar = new Mage(this.head, this.attr, this.abil, this.spec, this.botm, 1);
                this.pack();
                this.show();
            } else if (label.equals("Vampire")) {
                this.myChar = new Vampire(this.head, this.attr, this.abil, this.spec, this.botm, 1);
                this.pack();
                this.show();
            } else if (label.equals("Werewolf")) {
                this.myChar = new Werewolf(this.head, this.attr, this.abil, this.spec, this.botm, 1);
                this.pack();
                this.show();
            } else if (!label.equals("Wraith") && (nums = new String("0123456789")).indexOf(label.charAt(0)) != -1) {
                int year = Integer.parseInt(label.substring(0, 4));
                this.myChar.setYear(year);
            }
        }
    }

    public void loadChar() {
        FileDialog fd = new FileDialog((Frame)this, "Load Character", 0);
        fd.setVisible(true);
        this.readCharFile(fd.getFile());
    }

    public void readCharFile(String filename) {
        try {
            FileInputStream istream = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(istream);
            this.myChar = (GenChar)ois.readObject();
            this.myChar.display(this.head, this.attr, this.abil, this.spec, this.botm, 0);
            istream.close();
        }
        catch (Exception e) {
            System.out.println("Exception:  " + e);
        }
    }

    public void saveChar() {
        FileDialog fd = new FileDialog((Frame)this, "Save Character", 1);
        fd.setVisible(true);
        try {
            FileOutputStream ostream = new FileOutputStream(fd.getFile());
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            oos.writeObject(this.myChar);
            ostream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChar() {
        this.myChar = new GenChar(this.head, this.attr, this.abil, this.spec, this.botm, 1);
    }

    public void setChar(String chType) {
        this.myChar = chType.equals("ch") || chType.equalsIgnoreCase("Changeling") ? new Changeling(this.head, this.attr, this.abil, this.spec, this.botm, 1) : (chType.equals("mg") || chType.equalsIgnoreCase("mage") ? new Mage(this.head, this.attr, this.abil, this.spec, this.botm, 1) : (chType.equals("v") || chType.equalsIgnoreCase("Vampire") ? new Vampire(this.head, this.attr, this.abil, this.spec, this.botm, 1) : (chType.equals("ww") || chType.equalsIgnoreCase("Werewolf") ? new Werewolf(this.head, this.attr, this.abil, this.spec, this.botm, 1) : (chType.equals("wr") || chType.equalsIgnoreCase("Wraith") ? new GenChar(this.head, this.attr, this.abil, this.spec, this.botm, 1) : new GenChar(this.head, this.attr, this.abil, this.spec, this.botm, 1)))));
    }

    public static void main(String[] args) {
        WWChar wwc = new WWChar();
        if (args.length <= 0) {
            wwc.setChar("");
        }
        wwc.pack();
        wwc.show();
    }
}

