/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class HealthDisplay
extends Canvas {
    private static final long serialVersionUID = -7124493655422338488L;
    int numLevels;
    int numColumns;
    String[] damageLevels = new String[]{"Bruised", "Hurt", "Injured", "Wounded", "Mauled", "Crippled", "Incapacitated"};
    int[] diceLoss;
    String[] damageHeadings;

    public HealthDisplay() {
        int[] nArray = new int[7];
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -2;
        nArray[4] = -2;
        nArray[5] = -5;
        nArray[6] = -99;
        this.diceLoss = nArray;
        this.damageHeadings = new String[]{"Damage"};
        this.numLevels = this.damageLevels.length;
        this.numColumns = 1;
    }

    public HealthDisplay(String[] headings) {
        int[] nArray = new int[7];
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -2;
        nArray[4] = -2;
        nArray[5] = -5;
        nArray[6] = -99;
        this.diceLoss = nArray;
        this.damageHeadings = new String[]{"Damage"};
        this.numColumns = headings.length;
        this.damageHeadings = headings;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 250);
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = 10;
        int y = 20;
        int i = 0;
        while (i < this.numLevels) {
            g.drawString(this.damageLevels[i], x, y);
            int j = 0;
            while (j < this.numColumns) {
                g.drawRect(x + 100 + j * 50, y - 10, 10, 10);
                ++j;
            }
            y += fm.getHeight() + 2;
            ++i;
        }
    }

    public void setColumns(String[] columnHead) {
        this.damageHeadings = columnHead;
        this.numColumns = columnHead.length;
    }

    public void setLevels(String[] levels, int[] penalties) {
        this.diceLoss = penalties;
        this.damageLevels = levels;
        this.numLevels = levels.length;
    }
}

