/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import rpg.wwchar.Gift;
import rpg.wwchar.WWRating;

public class GiftList
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = -7149426172628305389L;
    Vector giftList = new Vector();
    private List list = new List();
    private TextField name = new TextField(20);
    private TextField camp = new TextField(20);
    private Choice who = new Choice();
    private TextField roll1 = new TextField(10);
    private TextField roll2 = new TextField(10);
    private WWRating rank = new WWRating("Rank", 1);
    private String fn;

    public GiftList(Frame f) {
        this(f, "gift.sav");
    }

    public GiftList(Frame f, String filename) {
        super(f, "Gift Selection", true);
        this.fn = new String(filename);
        this.readGifts();
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        Object event = a.getSource();
        if (event instanceof Button) {
            String label = ((Button)event).getLabel();
            if (label.equals("Add")) {
                this.addGift();
            } else if (label.equals("Clear")) {
                this.name.setText("");
                this.camp.setText("");
                this.roll1.setText("");
                this.roll2.setText("");
                this.rank.setValue(1);
            } else if (label.equals("Change")) {
                this.changeGift();
            } else if (label.equals("Remove")) {
                this.remGift();
            } else if (!label.equals("Filter")) {
                if (label.equals("Save")) {
                    this.saveGifts();
                } else if (label.equals("Exit")) {
                    System.exit(0);
                } else if (label.equals("Select")) {
                    this.setVisible(false);
                }
            }
        }
    }

    public void addGift() {
        String giftName = this.name.getText();
        String giftUser = this.who.getSelectedItem();
        String giftCamp = this.camp.getText();
        String giftRol1 = this.roll1.getText();
        String giftRol2 = this.roll2.getText();
        int giftRank = this.rank.getValue();
        int listLen = this.giftList.size();
        int i = 0;
        while (i < listLen) {
            Gift g = (Gift)this.giftList.elementAt(i);
            if (giftName.compareTo(g.name) == 0 && giftUser.compareTo(g.who) == 0) {
                return;
            }
            if (giftName.compareTo(g.name) < 0) {
                Gift ng = new Gift(giftName, giftRank, giftUser);
                ng.setRolls(giftRol1, giftRol2);
                ng.setCamp(giftCamp);
                this.giftList.insertElementAt(ng, i);
                this.list.addItem(giftName, i);
                return;
            }
            ++i;
        }
        Gift ng = new Gift(giftName, giftRank, giftUser);
        ng.setRolls(giftRol1, giftRol2);
        ng.setCamp(giftCamp);
        this.giftList.addElement(ng);
        this.list.addItem(giftName);
    }

    public void changeGift() {
        this.remGift();
        this.addGift();
    }

    public void display() {
        this.add((Component)this.list, "Center");
        this.list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GiftList.this.displayGift();
                }
            }
        });
        Panel q = new Panel(new GridLayout(1, 0));
        Panel p1 = new Panel();
        p1.add(new Label("Gift Name", 2));
        p1.add(this.name);
        q.add(p1);
        Panel p2 = new Panel();
        p2.add(new Label("Gift used by:", 2));
        this.who.addItem("Homid");
        this.who.addItem("Metis");
        this.who.addItem("Lupus");
        this.who.addItem("Ragabash");
        this.who.addItem("Theurge");
        this.who.addItem("Philodox");
        this.who.addItem("Galliard");
        this.who.addItem("Ahroun");
        this.who.addItem("Black Furies");
        this.who.addItem("Bone Gnawers");
        this.who.addItem("Children of Gaia");
        this.who.addItem("Fianna");
        this.who.addItem("Get of Fenris");
        this.who.addItem("Glass Walkers");
        this.who.addItem("Red Talons");
        this.who.addItem("Shadow Lords");
        this.who.addItem("Silent Striders");
        this.who.addItem("Silver Fangs");
        this.who.addItem("Stargazers");
        this.who.addItem("Uktena");
        this.who.addItem("Wendigo");
        this.who.addItem("Black Spiral Dancer");
        this.who.addItem("Skindancer");
        p2.add(this.who);
        q.add(p2);
        q.add(this.rank);
        Panel p3 = new Panel();
        p3.add(new Label("Camp Restriction:"));
        p3.add(this.camp);
        q.add(p3);
        Panel p4 = new Panel();
        p4.add(new Label("Roll: "));
        p4.add(this.roll1);
        p4.add(new Label(" + "));
        p4.add(this.roll2);
        q.add(p4);
        this.add((Component)q, "East");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GiftList.this.setVisible(false);
                if (GiftList.this.name.isEditable()) {
                    System.exit(0);
                }
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void displayGift() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            Gift g = (Gift)this.giftList.elementAt(inx);
            this.name.setText(g.name);
            this.camp.setText(g.camp);
            this.roll1.setText(g.roll[0]);
            this.roll2.setText(g.roll[1]);
            this.who.select(g.who);
            this.rank.setValue(g.rank);
        }
    }

    public void editList() {
        Panel p = new Panel();
        Button adb = new Button("Add");
        Button clr = new Button("Clear");
        Button chg = new Button("Change");
        Button rem = new Button("Remove");
        Button fil = new Button("Filter");
        Button sav = new Button("Save");
        Button xit = new Button("Exit");
        p.add(adb);
        p.add(clr);
        p.add(chg);
        p.add(rem);
        p.add(fil);
        p.add(sav);
        p.add(xit);
        adb.addActionListener(this);
        clr.addActionListener(this);
        chg.addActionListener(this);
        rem.addActionListener(this);
        sav.addActionListener(this);
        xit.addActionListener(this);
        this.add((Component)p, "South");
    }

    public Gift[] filterGifts(String user, int maxRank) {
        Gift[] gifts = new Gift[10 * maxRank];
        int numGifts = 0;
        int listLen = this.giftList.size();
        int i = 0;
        while (i < listLen) {
            Gift g = (Gift)this.giftList.elementAt(i);
            if (user.equals(g.who) && maxRank >= g.rank) {
                gifts[numGifts] = g;
                ++numGifts;
            }
            ++i;
        }
        return gifts;
    }

    public void readGifts() {
        try {
            Gift ng;
            FileInputStream istream = new FileInputStream(this.fn);
            ObjectInputStream p = new ObjectInputStream(istream);
            while ((ng = (Gift)p.readObject()) != null) {
                this.giftList.addElement(ng);
                this.list.addItem(ng.name);
            }
            istream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remGift() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            this.list.remove(inx);
            this.giftList.removeElementAt(inx);
        }
    }

    public void saveGifts() {
        try {
            FileOutputStream ostream = new FileOutputStream(this.fn);
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            int listLen = this.giftList.size();
            int i = 0;
            while (i < listLen) {
                Gift g = (Gift)this.giftList.elementAt(i);
                p.writeObject(g);
                ++i;
            }
            p.flush();
            ostream.close();
        }
        catch (IOException e) {
            System.out.println("Save unsuccessful : " + e);
        }
    }

    public void selectFrom(String user, int maxRank) {
        Button sel = new Button("Select");
        this.add((Component)sel, "South");
        sel.addActionListener(this);
        int i = 0;
        while (i < this.giftList.size()) {
            Gift g = (Gift)this.giftList.elementAt(i);
            if (user.indexOf(g.who) == -1 || maxRank < g.rank) {
                this.list.remove(i);
                this.giftList.removeElementAt(i);
                continue;
            }
            ++i;
        }
        this.name.setEditable(false);
        this.camp.setEditable(false);
        this.roll1.setEditable(false);
        this.roll2.setEditable(false);
        this.rank.setEditable(false);
        this.who.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GiftList.this.displayGift();
            }
        });
    }

    public Gift selectGift() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            Gift g = (Gift)this.giftList.elementAt(inx);
            return g;
        }
        return null;
    }

    public static void main(String[] args) {
        GiftList gl = new GiftList(new Frame());
        gl.editList();
        gl.display();
    }
}

