/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.Choice;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.JPanel;
import rpg.wwchar.HealthDisplay;
import rpg.wwchar.WWRating;
import rpg.wwchar.WWRatingList;
import rpg.wwchar.WWTrait;

public class GenChar
implements Serializable,
ActionListener {
    private static final long serialVersionUID = 8714521585289010945L;
    WWRatingList attributes = new WWRatingList();
    WWRatingList talents = new WWRatingList();
    WWRatingList skills = new WWRatingList();
    WWRatingList knowledges = new WWRatingList();
    WWRatingList backgrounds = new WWRatingList();
    Choice groupChoice = new Choice();
    WWTrait willpower = new WWTrait("Willpower");
    int experience = 0;
    String name;
    String player;
    String chronicle;
    String concept;
    int year = 1998;
    private int editMode;

    public GenChar() {
    }

    public GenChar(JPanel head, JPanel attr, JPanel abil, JPanel spec, JPanel botm, int mode) {
        this.editMode = mode;
        head.removeAll();
        this.setupHeader(head);
        attr.removeAll();
        attr.add(this.setupAttr());
        abil.removeAll();
        abil.add(this.setupTalents());
        abil.add(this.setupSkills());
        abil.add(this.setupKnowledges());
        this.setupBackgrounds();
        spec.removeAll();
        this.setupSpecial(spec);
        botm.removeAll();
        this.setupBottom(botm);
        this.groupChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenChar.this.setGroup(GenChar.this.groupChoice.getSelectedItem());
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.editMode == 1) {
            System.out.println("Character Valid: " + this.verifyStartingChar());
        }
    }

    public void display(JPanel head, JPanel attr, JPanel abil, JPanel spec, JPanel botm, int mode) {
        this.editMode = mode;
        head.removeAll();
        this.setupHeader(head);
        attr.removeAll();
        attr.add(this.attributes);
        abil.removeAll();
        abil.add(this.talents);
        abil.add(this.skills);
        abil.add(this.knowledges);
        spec.removeAll();
        this.setupSpecial(spec);
        botm.removeAll();
        this.setupBottom(botm);
        Window w = (Window)head.getParent();
        w.pack();
    }

    public int freebiePoints(int freebie, int attrCost, int[] attrTots, int abilCost, int[] abilTots, int backTot, int wpCost) {
        int[] sorted = new int[3];
        int t = this.talents.totalValues();
        int s = this.skills.totalValues();
        int k = this.knowledges.totalValues();
        sorted[0] = Math.max(t, Math.max(s, k));
        sorted[2] = Math.min(t, Math.min(s, k));
        sorted[1] = t + s + k - sorted[0] - sorted[2];
        int i = 0;
        while (i < 3) {
            if (sorted[i] > abilTots[i]) {
                freebie -= (sorted[i] - abilTots[i]) * abilCost;
            }
            ++i;
        }
        int b = this.backgrounds.totalValues();
        if (b > backTot) {
            freebie -= b - backTot;
        }
        WWRating att = this.attributes.getRating("Strength");
        int phys = att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Dexterity");
        phys += att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Stamina");
        phys += att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Charisma");
        int soci = att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Manipulation");
        soci += att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Appearance");
        soci += att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Perception");
        int ment = att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Intelligence");
        ment += att.getValue() - att.getMinimum();
        att = this.attributes.getRating("Wits");
        sorted[0] = Math.max(phys, Math.max(soci, ment += att.getValue() - att.getMinimum()));
        sorted[2] = Math.min(phys, Math.min(soci, ment));
        sorted[1] = phys + soci + ment - sorted[0] - sorted[2];
        int i2 = 0;
        while (i2 < 3) {
            if (sorted[i2] > attrTots[i2]) {
                freebie -= (sorted[i2] - attrTots[i2]) * attrCost;
            }
            ++i2;
        }
        int wpAdded = this.willpower.getValue() - this.willpower.getMinimum();
        if (wpAdded > 0) {
            freebie -= wpAdded * wpCost;
        }
        return freebie;
    }

    public void setGroup(String theGroup) {
        System.out.println(String.valueOf(theGroup) + " should not be here");
    }

    public void setMode(int newMode) {
        this.editMode = newMode;
    }

    public WWRatingList setupAttr() {
        if (this.editMode == 1) {
            String[] attrStrings = new String[]{"Strength", "Dexterity", "Stamina", "Charisma", "Manipulation", "Appearance", "Perception", "Intelligence", "Wits"};
            this.attributes = new WWRatingList(attrStrings, 3);
            int i = 0;
            while (i < 9) {
                this.attributes.getRating(attrStrings[i]).setMinimum(1);
                ++i;
            }
        }
        return this.attributes;
    }

    public WWRatingList setupBackgrounds() {
        String[] backgroundList = new String[]{"Allies", "Contacts", "Mentor", "Resources"};
        this.backgrounds = new WWRatingList(backgroundList);
        return this.backgrounds;
    }

    public JPanel setupBottom(JPanel p) {
        p.add(this.willpower);
        HealthDisplay hd = new HealthDisplay();
        p.add(hd);
        return p;
    }

    public JPanel setupHeader(JPanel p) {
        TextField namefield = new TextField("Name: ", 20);
        TextField playerfield = new TextField("Player: ", 20);
        p.add(namefield);
        p.add(playerfield);
        p.add(new TextField("Concept: ", 20));
        return p;
    }

    public WWRatingList setupKnowledges() {
        String[] knowledgeList = new String[]{"Enigmas", "Investigation", "Law", "Linguistics", "Medicine", "Science"};
        this.knowledges = new WWRatingList(knowledgeList);
        return this.knowledges;
    }

    public WWRatingList setupSkills() {
        String[] skillList = new String[]{"Drive", "Ettiquette", "Firearms", "Melee", "Stealth"};
        this.skills = new WWRatingList(skillList);
        return this.skills;
    }

    public JPanel setupSpecial(JPanel p) {
        return p;
    }

    public WWRatingList setupTalents() {
        String[] talentList = new String[]{"Alertness", "Athletics", "Brawl", "Dodge", "Empathy", "Expression", "Intimidation", "Streetwise", "Subterfuge"};
        this.talents = new WWRatingList(talentList);
        this.talents.addActionListener(this);
        return this.talents;
    }

    public void setYear(int theYear) {
        this.year = theYear;
    }

    public boolean validateChar() {
        System.out.println("Validating");
        if (this.editMode == 1) {
            System.out.println("Talents: " + this.talents.totalValues() + "  Skills: " + this.skills.totalValues() + "  Knowledges: " + this.knowledges.totalValues());
        }
        return true;
    }

    public boolean verifyStartingChar() {
        int[] abilTots = new int[]{13, 9, 5};
        int[] attrTots = new int[]{7, 5, 3};
        return this.freebiePoints(15, 5, attrTots, 2, abilTots, 5, 1) < 0;
    }
}

