/*
 * Decompiled with CFR 0.152.
 */
package rpg.wwchar;

import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import rpg.wwchar.GenChar;
import rpg.wwchar.HealthDisplay;
import rpg.wwchar.WWRatingList;
import rpg.wwchar.WWTrait;

public class Changeling
extends GenChar {
    private static final long serialVersionUID = 7579558827019013433L;
    WWTrait glamour;
    WWTrait banality;
    WWRatingList arts = null;
    WWRatingList realms = null;
    String kith;
    String seeming;
    String house;
    String court;

    public Changeling(JPanel head, JPanel attr, JPanel abil, JPanel spec, JPanel botm, int mode) {
        super(head, attr, abil, spec, botm, mode);
    }

    @Override
    public void setGroup(String theKith) {
        this.kith = new String(theKith);
        if (this.kith.equals("Boggan")) {
            this.realms.emphasize("Actor");
            this.skills.emphasize("Crafts");
        } else if (this.kith.equals("Eshu")) {
            this.realms.emphasize("Scene");
            this.skills.emphasize("Performance");
            this.talents.emphasize("Empathy");
        } else if (this.kith.equals("Nocker")) {
            this.realms.emphasize("Prop");
        } else if (this.kith.equals("Pooka")) {
            this.realms.emphasize("Nature");
            this.talents.emphasize("Empathy");
            this.talents.emphasize("Subterfuge");
        } else if (this.kith.equals("Redcap")) {
            this.realms.emphasize("Nature");
        } else if (this.kith.equals("Satyr")) {
            this.realms.emphasize("Fae");
            this.talents.emphasize("Athletics");
        } else if (this.kith.equals("Sidhe")) {
            this.realms.emphasize("");
            this.skills.emphasize("Etiquette");
        } else if (this.kith.equals("Sluagh")) {
            this.realms.emphasize("Prop");
            this.talents.emphasize("Alertness");
            this.skills.emphasize("Stealth");
        } else if (this.kith.equals("Troll")) {
            this.realms.emphasize("Fae");
            this.talents.emphasize("Alertness");
            this.talents.emphasize("Athletics");
        }
    }

    public void setSeeming(String theSeeming) {
        this.seeming = new String(theSeeming);
        if (this.seeming.equals("Childling")) {
            this.glamour.setValue(5);
            this.willpower.setValue(1);
            this.banality.setValue(1);
        } else if (this.seeming.equals("Wilder")) {
            this.glamour.setValue(4);
            this.willpower.setValue(2);
            this.banality.setValue(3);
        } else if (this.seeming.equals("Grump")) {
            this.glamour.setValue(3);
            this.willpower.setValue(5);
            this.banality.setValue(5);
        }
    }

    @Override
    public WWRatingList setupBackgrounds() {
        String[] chBack = new String[]{"Chimera", "Contacts", "Dreamers", "Holdings", "Mentor", "Remembrance", "Resources", "Retinue", "Title", "Treasure"};
        this.backgrounds = new WWRatingList(chBack);
        return this.backgrounds;
    }

    @Override
    public JPanel setupBottom(JPanel p) {
        this.glamour = new WWTrait("Glamour");
        this.banality = new WWTrait("Banality");
        p.setLayout(new GridLayout(1, 3));
        JPanel renown = new JPanel(new GridLayout(1, 0));
        JPanel traits = new JPanel(new GridLayout(1, 0));
        traits.add(this.glamour);
        traits.add(this.willpower);
        traits.add(this.banality);
        p.add(renown);
        p.add(traits);
        HealthDisplay hd = new HealthDisplay();
        String[] damageHead = new String[]{"Chimerical", "Real"};
        hd.setColumns(damageHead);
        p.add(hd);
        return p;
    }

    @Override
    public JPanel setupHeader(JPanel p) {
        this.groupChoice.addItem("Boggan");
        this.groupChoice.addItem("Clurichan");
        this.groupChoice.addItem("Eshu");
        this.groupChoice.addItem("Nocker");
        this.groupChoice.addItem("Pooka");
        this.groupChoice.addItem("Redcap");
        this.groupChoice.addItem("Satyr");
        this.groupChoice.addItem("Selkie");
        this.groupChoice.addItem("Sidhe");
        this.groupChoice.addItem("Sluagh");
        this.groupChoice.addItem("Troll");
        this.groupChoice.addItem("Beastie");
        this.groupChoice.addItem("Boggart");
        this.groupChoice.addItem("Goblin");
        this.groupChoice.addItem("Ogre");
        this.groupChoice.addItem("Troll");
        final Choice seemingChoice = new Choice();
        seemingChoice.addItem("Childling");
        seemingChoice.addItem("Wilder");
        seemingChoice.addItem("Grump");
        Choice courtChoice = new Choice();
        courtChoice.addItem("Seelie");
        courtChoice.addItem("Unseelie");
        Choice houseChoice = new Choice();
        houseChoice.addItem("none");
        houseChoice.addItem("Dougall");
        houseChoice.addItem("Eiluned");
        houseChoice.addItem("Fiona");
        houseChoice.addItem("Gwydion");
        houseChoice.addItem("Liam");
        seemingChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Changeling.this.setSeeming(seemingChoice.getSelectedItem());
            }
        });
        TextField namefield = new TextField("Name: ", 20);
        TextField playerfield = new TextField("Player: ", 20);
        p.add(namefield);
        p.add(this.groupChoice);
        p.add(new TextField("Foo1: ", 20));
        p.add(playerfield);
        p.add(seemingChoice);
        p.add(new TextField("Foo1: ", 20));
        p.add(new TextField("Foo1: ", 20));
        p.add(new TextField("Foo1: ", 20));
        p.add(courtChoice);
        p.add(new TextField("Foo1: ", 20));
        return p;
    }

    @Override
    public WWRatingList setupKnowledges() {
        String[] chKnowledges = new String[]{"Greymayre", "Lore*", "Politics"};
        this.knowledges = super.setupKnowledges();
        this.knowledges.addRatings(chKnowledges);
        return this.knowledges;
    }

    @Override
    public WWRatingList setupSkills() {
        String[] chSkills = new String[]{"Crafts", "Leadership", "Performance", "Security"};
        this.skills = super.setupSkills();
        this.skills.addRatings(chSkills);
        return this.skills;
    }

    @Override
    public JPanel setupSpecial(JPanel p) {
        p.add(this.backgrounds);
        String[] artList = new String[]{"Chicanery", "Legerdemain", "Primal", "Pyretics", "Soothsay", "Sovereign", "Wayfare"};
        this.arts = new WWRatingList(artList);
        String[] realmList = new String[]{"Actor", "Fae", "Nature", "Prop", "Scene", "Time"};
        this.realms = new WWRatingList(realmList);
        p.add(this.arts);
        p.add(this.realms);
        return p;
    }

    @Override
    public WWRatingList setupTalents() {
        String[] chTalents = new String[]{"Kenning"};
        this.talents = super.setupTalents();
        this.talents.addRatings(chTalents);
        return this.talents;
    }

    @Override
    public boolean verifyStartingChar() {
        int rlAdded;
        int arAdded;
        int[] abilTots = new int[]{13, 9, 5};
        int[] attrTots = new int[]{7, 5, 3};
        int bonus = this.freebiePoints(15, 5, attrTots, 2, abilTots, 5, 2);
        int glAdded = this.glamour.getValue() - this.glamour.getMinimum();
        if (glAdded > 0) {
            bonus -= glAdded * 3;
        }
        if ((arAdded = this.arts.totalValues() - 3) > 0) {
            bonus -= arAdded * 5;
        }
        if ((rlAdded = this.realms.totalValues() - 5) > 0) {
            bonus -= rlAdded * 3;
        }
        return bonus >= 0;
    }
}

