/*
 * Decompiled with CFR 0.152.
 */
package rpg.spelljammer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import rpg.spelljammer.OrbitDisplay;
import rpg.spelljammer.Planet;
import rpg.spelljammer.PlanetMaker;
import rpg.spelljammer.SolarSystem;

public class SystemMaker
extends JFrame {
    private static final long serialVersionUID = 5343204255037050349L;
    private SolarSystem system = null;
    private OrbitDisplay disp = new OrbitDisplay(this.system);
    private JMenu moonsMenu = new JMenu("Planet-Moon Map");
    private JFileChooser chooser = new JFileChooser();
    private JMenuItem save = new JMenuItem("Save");
    private int mapRes = 600;
    private int sideHeight = 600;
    private int sideWidth = 100;
    private int sideMargin = 20;
    private JPanel planetPane = new JPanel();
    private HashMap<Planet, JPanel> panes = new HashMap();
    private HashSet<Planet> showMoonList = new HashSet();
    private PlanetMaker editor = new PlanetMaker();
    private JPanel propPane = new JPanel(new GridLayout(0, 2));
    private JTextField sizeField = new JTextField(Integer.toString(this.mapRes));
    private JTextField widField = new JTextField(Integer.toString(this.sideWidth));
    private JTextField hgtField = new JTextField(Integer.toString(this.sideHeight));
    private JTextField marField = new JTextField(Integer.toString(this.sideMargin));
    private JTextField zeroField = new JTextField();
    private ActionListener edit = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Container pane = ((JButton)evt.getSource()).getParent().getParent();
            Planet edited = null;
            for (Planet planet : SystemMaker.this.panes.keySet()) {
                if (!((JPanel)SystemMaker.this.panes.get(planet)).equals(pane)) continue;
                edited = planet;
            }
            if (edited != null) {
                SystemMaker.this.editor.setPlanet(edited);
                SystemMaker.this.editor.pack();
                SystemMaker.this.editor.setVisible(true);
                SystemMaker.this.panes.remove(edited);
                SystemMaker.this.displaySystem();
            }
        }
    };
    private ActionListener show = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            JToggleButton tog = (JToggleButton)evt.getSource();
            Container pane = tog.getParent().getParent();
            Planet shown = null;
            for (Planet planet : SystemMaker.this.panes.keySet()) {
                if (!((JPanel)SystemMaker.this.panes.get(planet)).equals(pane)) continue;
                shown = planet;
            }
            if (tog.isSelected()) {
                SystemMaker.this.showMoonList.add(shown);
            } else {
                SystemMaker.this.showMoonList.remove(shown);
            }
            SystemMaker.this.displaySystem();
        }
    };
    private ActionListener adder = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Container pane = ((JButton)evt.getSource()).getParent().getParent();
            Planet shown = null;
            for (Planet planet : SystemMaker.this.panes.keySet()) {
                if (!((JPanel)SystemMaker.this.panes.get(planet)).equals(pane)) continue;
                shown = planet;
            }
            if (shown != null) {
                Planet.generateMoon(shown);
                Component[] componentArray = ((JButton)evt.getSource()).getParent().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component comp = componentArray[n2];
                    if (comp instanceof JLabel && ((JLabel)comp).getText().startsWith("Moons:")) {
                        ((JLabel)comp).setText("Moons: " + shown.getMoons().size());
                    }
                    ++n2;
                }
            }
            SystemMaker.this.displaySystem();
        }
    };
    private ActionListener mapMoons = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            String planetName = evt.getActionCommand();
            Planet showMe = null;
            for (Planet planet : SystemMaker.this.system.getPlanets()) {
                if (!planet.getName().equals(planetName)) continue;
                showMe = planet;
            }
            if (showMe != null) {
                BufferedImage map = SystemMaker.this.disp.createPlanetMap(SystemMaker.this.mapRes, showMe);
                SystemMaker.this.showImagePane(map, String.valueOf(planetName) + "_Moons");
            }
        }
    };

    public SystemMaker() {
        super("Spelljammer System Maker");
        this.setupMenus();
        this.setupPanes();
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setSize(600, 600);
        this.setVisible(true);
    }

    private JPanel createPlanetPane(Planet planet, boolean isMoon) {
        JPanel pane = this.panes.get(planet);
        if (pane == null) {
            Border inset;
            pane = new JPanel(new BorderLayout());
            JPanel dataPane = new JPanel(new GridLayout(0, 3));
            dataPane.add(new JLabel(planet.getName()));
            if (planet.getOrbitDist() == 0L) {
                dataPane.add(new JLabel("Primary"));
            } else {
                dataPane.add(new JLabel());
            }
            JButton editButn = new JButton("Edit");
            dataPane.add(editButn);
            editButn.addActionListener(this.edit);
            dataPane.add(new JLabel("Size: " + planet.getSize() + " miles (" + planet.getSizeChar() + ") "));
            dataPane.add(new JLabel("Shape: " + (Object)((Object)planet.getShape())));
            dataPane.add(new JLabel("Type: " + (Object)((Object)planet.getType())));
            if (planet.getOrbitDist() > 0L) {
                dataPane.add(new JLabel("Orbit Distance: " + planet.getOrbitDist() + " miles  "));
                dataPane.add(new JLabel("Orbit Period : " + Math.abs(planet.getOrbitTime()) + " days"));
                dataPane.add(new JLabel("Orbital Motion: " + (Object)((Object)planet.getMotion())));
                if (planet.getRightAscension() != 0.0 || planet.getInclination() != 0.0) {
                    dataPane.add(new JLabel("Ascension: " + planet.getRightAscension()));
                    dataPane.add(new JLabel("Inclination: " + planet.getInclination()));
                    dataPane.add(new JLabel(""));
                }
                if (!isMoon) {
                    dataPane.add(new JLabel("Moons: " + planet.getMoons().size()));
                    JCheckBox showMoons = new JCheckBox("Show Moons");
                    showMoons.addActionListener(this.show);
                    dataPane.add(showMoons);
                    JButton addMoon = new JButton("Add Moon");
                    addMoon.addActionListener(this.adder);
                    dataPane.add(addMoon);
                }
            }
            pane.add((Component)dataPane, "North");
            JTextArea descArea = new JTextArea(planet.getTextDescription(), 4, 30);
            descArea.setEditable(false);
            pane.add(descArea);
            if (isMoon) {
                inset = BorderFactory.createEmptyBorder(0, 25, 0, 0);
                pane.setBorder(inset);
            } else {
                inset = BorderFactory.createEmptyBorder(0, 0, 0, 25);
                pane.setBorder(inset);
            }
            this.panes.put(planet, pane);
        }
        return pane;
    }

    private void displaySystem() {
        this.disp.setSystem(this.system);
        this.moonsMenu.removeAll();
        this.planetPane.removeAll();
        for (Planet planet : this.system.getPlanets()) {
            this.planetPane.add(this.createPlanetPane(planet, false));
            if (planet.getMoons().isEmpty() || planet.getOrbitDist() <= 0L) continue;
            JMenuItem moonItem = new JMenuItem(planet.getName());
            moonItem.addActionListener(this.mapMoons);
            this.moonsMenu.add(moonItem);
            for (Planet moon : planet.getMoons()) {
                JPanel moonPane = this.createPlanetPane(moon, true);
                if (!this.showMoonList.contains(planet)) continue;
                this.planetPane.add(moonPane);
            }
        }
        this.invalidate();
        this.validate();
    }

    public void loadFile() {
        int returnVal = this.chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.chooser.getSelectedFile();
            try {
                DocumentBuilder docBuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuild.parse(new FileInputStream(file));
                Element root = doc.getDocumentElement();
                this.system = new SolarSystem(root);
                this.panes.clear();
                this.displaySystem();
            }
            catch (Exception exc) {
                this.system = null;
                JOptionPane.showMessageDialog(this, "Solar System file cannot be read:\n" + exc.getMessage(), "Load Error", 0);
            }
        }
    }

    private int parseField(JTextField field, int curVal) {
        int newVal = curVal;
        try {
            newVal = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return newVal;
    }

    public void saveFile() {
        int returnVal = this.chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.chooser.getSelectedFile();
            try {
                this.system.writeXml(file);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, "Cannot save Solar System file:\n" + exc.getMessage(), "Save Error", 0);
            }
        }
    }

    private void saveImage(BufferedImage image, String fileName) {
        File imgFile = new File(fileName);
        this.chooser.setSelectedFile(imgFile);
        int returnVal = this.chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.chooser.getSelectedFile();
            try {
                ImageIO.write((RenderedImage)image, "PNG", file);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, "Cannot save Image file:\n" + exc.getMessage(), "Image Save Error", 0);
            }
        }
    }

    private void setupMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem load = new JMenuItem("Load");
        load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemMaker.this.loadFile();
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemMaker.this.saveFile();
            }
        });
        JMenuItem random = new JMenuItem("Random");
        random.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemMaker.this.system = SolarSystem.generateRandom();
                SystemMaker.this.panes.clear();
                SystemMaker.this.displaySystem();
            }
        });
        JMenuItem addPlanet = new JMenuItem("Add Planet");
        addPlanet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                long orbitDist = 0L;
                Planet planet = Planet.generateRandom();
                if (SystemMaker.this.system == null) {
                    SystemMaker.this.system = new SolarSystem();
                    SystemMaker.this.system.setMotion(SolarSystem.randomMotion());
                    planet.setName("Primary");
                } else {
                    orbitDist += (orbitDist = SystemMaker.this.system.getPlanets().last().getOrbitDist()) > 350000000L ? (long)(new Random().nextInt(1600) * 1000000) + 400000000L : (long)(new Random().nextInt(120) * 1000000) + 20000000L;
                    planet.setName("Planet_" + SystemMaker.this.system.getPlanets().size());
                }
                planet.setOrbitDist(orbitDist);
                SystemMaker.this.system.addPlanet(planet);
                SystemMaker.this.system.determineMotion(planet);
                SystemMaker.this.displaySystem();
                SystemMaker.this.editor.setPlanet(planet);
                SystemMaker.this.editor.pack();
                SystemMaker.this.editor.setVisible(true);
            }
        });
        JMenuItem props = new JMenuItem("Properties");
        props.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemMaker.this.showPropPane();
            }
        });
        fileMenu.add(load);
        fileMenu.add(this.save);
        fileMenu.add(random);
        fileMenu.addSeparator();
        fileMenu.add(addPlanet);
        fileMenu.addSeparator();
        fileMenu.add(props);
        JMenu viewMenu = new JMenu("View");
        JMenuItem full = new JMenuItem("Full System Map");
        full.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferedImage map = SystemMaker.this.disp.createSphereMap(SystemMaker.this.mapRes);
                SystemMaker.this.showImagePane(map, SystemMaker.this.system.getName());
            }
        });
        JMenuItem inner = new JMenuItem("Inner System Map");
        inner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferedImage map = SystemMaker.this.disp.createInnerMap(SystemMaker.this.mapRes);
                SystemMaker.this.showImagePane(map, String.valueOf(SystemMaker.this.system.getName()) + "_Inner");
            }
        });
        JMenuItem outer = new JMenuItem("Outer System Map");
        outer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferedImage map = SystemMaker.this.disp.createOuterMap(SystemMaker.this.mapRes);
                SystemMaker.this.showImagePane(map, String.valueOf(SystemMaker.this.system.getName()) + "_Outer");
            }
        });
        JMenuItem side = new JMenuItem("Sidebar Image");
        side.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BufferedImage map = SystemMaker.this.disp.createSidebarImage(SystemMaker.this.sideWidth, SystemMaker.this.sideHeight, SystemMaker.this.sideMargin);
                SystemMaker.this.showImagePane(map, String.valueOf(SystemMaker.this.system.getName()) + "_Side");
            }
        });
        viewMenu.add(full);
        viewMenu.add(inner);
        viewMenu.add(outer);
        viewMenu.add(this.moonsMenu);
        viewMenu.add(side);
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        this.setJMenuBar(menuBar);
    }

    private void setupPanes() {
        this.planetPane.setLayout(new BoxLayout(this.planetPane, 3));
        this.add(new JScrollPane(this.planetPane, 20, 31));
        this.propPane.add(new JLabel("Map Size:", 4));
        this.propPane.add(this.sizeField);
        this.propPane.add(new JLabel("Sidebar Width:", 4));
        this.propPane.add(this.widField);
        this.propPane.add(new JLabel("Sidebar Height:", 4));
        this.propPane.add(this.hgtField);
        this.propPane.add(new JLabel("Sidebar Margin:", 4));
        this.propPane.add(this.marField);
        this.propPane.add(new JLabel("Days from Zero:", 4));
        this.propPane.add(this.zeroField);
    }

    protected void showImagePane(BufferedImage image, String name) {
        Object[] options = new String[]{"Save", "Close"};
        int returnVal = JOptionPane.showOptionDialog(this, "", name, 2, 3, new ImageIcon(image), options, null);
        if (returnVal == 0) {
            this.saveImage(image, String.valueOf(name) + ".png");
        }
    }

    private void showPropPane() {
        this.sizeField.setText(Integer.toString(this.mapRes));
        this.widField.setText(Integer.toString(this.sideWidth));
        this.hgtField.setText(Integer.toString(this.sideHeight));
        this.marField.setText(Integer.toString(this.sideMargin));
        this.zeroField.setText(Long.toString(this.disp.getDaysFromZero()));
        int returnVal = JOptionPane.showConfirmDialog(this, this.propPane, "Properties", 2);
        if (returnVal == 0) {
            this.mapRes = this.parseField(this.sizeField, this.mapRes);
            this.sideWidth = this.parseField(this.widField, this.sideWidth);
            this.sideHeight = this.parseField(this.hgtField, this.sideHeight);
            this.sideMargin = this.parseField(this.marField, this.sideMargin);
            try {
                long newZero = Long.parseLong(this.zeroField.getText());
                this.disp.setDaysFromZero(newZero);
            }
            catch (NumberFormatException exc) {
                this.zeroField.setText(Long.toString(this.disp.getDaysFromZero()));
            }
        }
    }

    public static void main(String[] args) {
        new SystemMaker();
    }
}

