/*
 * Decompiled with CFR 0.152.
 */
package rpg.spelljammer;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import rpg.Element;
import rpg.spelljammer.Planet;
import rpg.spelljammer.PlanetShape;
import rpg.spelljammer.SystemMotion;

public class SolarSystem
implements Serializable {
    private static final long serialVersionUID = 4688581306391463813L;
    private TreeSet<Planet> planets = new TreeSet();
    private SystemMotion motion;
    private String name = "Randomspace";

    public SolarSystem() {
    }

    public SolarSystem(org.w3c.dom.Element elem) {
        this.name = elem.getAttribute("name");
        String motionString = elem.getAttribute("motion");
        this.motion = motionString != null && motionString.length() > 0 ? SystemMotion.valueOf(motionString.toUpperCase()) : SolarSystem.randomMotion();
        NodeList primaries = elem.getElementsByTagName("primary");
        int i = 0;
        while (i < primaries.getLength()) {
            org.w3c.dom.Element planetElem = (org.w3c.dom.Element)primaries.item(i);
            Planet primary = new Planet(planetElem);
            primary.setMotion(SystemMotion.FIXED);
            primary.setOrbitDist(0L);
            this.planets.add(primary);
            ++i;
        }
        NodeList planetElems = elem.getElementsByTagName("planet");
        int i2 = 0;
        while (i2 < planetElems.getLength()) {
            org.w3c.dom.Element planetElem = (org.w3c.dom.Element)planetElems.item(i2);
            Planet newPlanet = new Planet(planetElem);
            this.planets.add(newPlanet);
            this.determineMotion(newPlanet);
            ++i2;
        }
        NodeList astElems = elem.getElementsByTagName("astronomical");
        int i3 = 0;
        while (i3 < astElems.getLength()) {
            org.w3c.dom.Element astElem = (org.w3c.dom.Element)astElems.item(i3);
            Planet newPlanet = new Planet(astElem);
            this.addAstronomical(newPlanet);
            ++i3;
        }
    }

    public void addAstronomical(Planet other) {
        Planet primary = this.getPrimary();
        primary.addMoon(other);
    }

    public void determineMotion(Planet planet) {
        Random rand = new Random();
        SystemMotion planetMotion = planet.getMotion();
        if (planetMotion == null) {
            planetMotion = this.motion;
            while (planetMotion.equals((Object)SystemMotion.MIXED)) {
                planetMotion = SolarSystem.randomMotion();
            }
            planet.setMotion(planetMotion);
        }
        if (planet.getOrbitTime() == 0 && (planetMotion.equals((Object)SystemMotion.CLOCKWISE) || planetMotion.equals((Object)SystemMotion.COUNTERCLOCKWISE))) {
            long dist = planet.getOrbitDist();
            rand.setSeed(dist + (long)this.name.hashCode());
            if (dist > 0L && dist < 350000000L) {
                int ring = Math.round(dist / 20000000L);
                planet.setOrbitTime(ring * 30 + rand.nextInt(30) - 15);
            } else if (dist > 350000000L) {
                int ring = Math.round(dist / 400000000L);
                planet.setOrbitTime(ring * 600 + rand.nextInt(600) - 300);
            }
        }
    }

    public void addPlanet(Planet newPlanet) {
        this.planets.add(newPlanet);
    }

    public String getDetails() {
        StringBuffer buf = new StringBuffer(this.name);
        for (Planet planet : this.planets) {
            buf.append("\n" + planet.getDetails());
        }
        return buf.toString();
    }

    public SystemMotion getMotion() {
        return this.motion;
    }

    public String getName() {
        return this.name;
    }

    public Planet getPlanet(int inx) {
        int count = 0;
        Planet found = null;
        for (Planet planet : this.planets) {
            if (count == inx) {
                found = planet;
            }
            ++count;
        }
        return found;
    }

    public SortedSet<Planet> getPlanets() {
        return this.planets;
    }

    private Planet getPrimary() {
        Planet primary = this.planets.first();
        if (primary.getOrbitDist() > 0L) {
            primary = new Planet();
            primary.setType(Element.VOID);
            this.planets.add(primary);
        }
        return primary;
    }

    public long getSphereRadius() {
        Planet outer = this.planets.last();
        return outer.getOrbitDist() * 2L;
    }

    public boolean hasInclined() {
        boolean inclined = false;
        for (Planet planet : this.planets) {
            boolean bl = inclined = planet.getInclination() != 0.0;
        }
        return inclined;
    }

    public void setMotion(SystemMotion motion) {
        this.motion = motion;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static Planet generatePrimary() {
        Random rand = new Random();
        Planet primary = new Planet();
        int d100 = rand.nextInt(100);
        if (d100 < 70) {
            primary.setType(Element.FIRE);
            Planet.generateRandom(primary, true);
        } else if (d100 < 95) {
            d100 = rand.nextInt(100);
            if (d100 < 80) {
                primary.setType(Element.EARTH);
            } else if (d100 < 90) {
                primary.setType(Element.AIR);
            } else {
                primary.setType(Element.WATER);
            }
            Planet.generateRandom(primary, true);
        } else if (d100 < 99) {
            primary.setType(Element.VOID);
        } else {
            primary.setShape(PlanetShape.PORTAL);
            d100 = rand.nextInt(100);
            if (d100 < 30) {
                primary.setType(Element.LIVE);
            } else if (d100 < 50) {
                primary.setType(Element.FIRE);
            } else if (d100 < 60) {
                primary.setType(Element.EARTH);
            } else if (d100 < 70) {
                primary.setType(Element.WATER);
            } else if (d100 < 80) {
                primary.setType(Element.AIR);
            } else if (d100 < 90) {
                primary.setType(Element.POSITIVE);
            } else {
                primary.setType(Element.NEGATIVE);
            }
            Planet.generateRandom(primary, true);
        }
        primary.setName("Primary");
        primary.setMotion(SystemMotion.FIXED);
        return primary;
    }

    public static SolarSystem generateRandom() {
        SolarSystem system = new SolarSystem();
        int numPlanets = 0;
        Random rand = new Random();
        system.addPlanet(SolarSystem.generatePrimary());
        int d100 = rand.nextInt(100);
        if (d100 < 5) {
            numPlanets = 1;
        } else if (d100 < 10) {
            numPlanets = 2;
        } else if (d100 < 15) {
            numPlanets = 3;
        } else if (d100 < 20) {
            numPlanets = 4;
        } else if (d100 < 30) {
            numPlanets = 5;
        } else if (d100 < 45) {
            numPlanets = 6;
        } else if (d100 < 55) {
            numPlanets = 7;
        } else if (d100 < 65) {
            numPlanets = 8;
        } else if (d100 < 75) {
            numPlanets = 9;
        } else if (d100 < 85) {
            numPlanets = 10;
        } else if (d100 < 90) {
            numPlanets = rand.nextInt(20) + 1;
        }
        system.setMotion(SolarSystem.randomMotion());
        int distCount = 0;
        boolean isOuter = false;
        int i = 0;
        while (i < numPlanets) {
            Planet planet = Planet.generateRandom();
            planet.setName("Planet_" + (i + 1));
            int moonCnt = 1;
            for (Planet moon : planet.getMoons()) {
                moon.setName(String.valueOf(planet.getName()) + ":Moon_" + moonCnt);
                ++moonCnt;
            }
            long orbitRad = 0L;
            if (!isOuter && distCount > 10) {
                distCount = 0;
                orbitRad = 350000000L + (long)rand.nextInt(100) * 1000000L;
                isOuter = true;
            } else {
                orbitRad = isOuter ? (long)(distCount += rand.nextInt(4) + 1) * 400000000L + (long)rand.nextInt(100) * 1000000L + 350000000L : (long)(distCount += rand.nextInt(6) + 1) * 20000000L + (long)rand.nextInt(20) * 1000000L - 10000000L;
            }
            planet.setOrbitDist(orbitRad);
            int yearInDays = 0;
            SystemMotion planetMotion = system.getMotion();
            while (planetMotion.equals((Object)SystemMotion.MIXED)) {
                planetMotion = SolarSystem.randomMotion();
            }
            if (planetMotion.equals((Object)SystemMotion.COUNTERCLOCKWISE) || planetMotion.equals((Object)SystemMotion.CLOCKWISE)) {
                int n = yearInDays = isOuter ? (distCount + 1) * 600 + rand.nextInt(600) - 300 : distCount * 30 + rand.nextInt(30) - 15;
                if (planetMotion.equals((Object)SystemMotion.CLOCKWISE)) {
                    yearInDays *= -1;
                }
            }
            planet.setOrbitTime(yearInDays);
            planet.setMotion(planetMotion);
            system.addPlanet(planet);
            ++i;
        }
        return system;
    }

    public static void main(String[] args) {
        SolarSystem system = SolarSystem.generateRandom();
        System.out.println(system.getDetails());
    }

    public static SystemMotion randomMotion() {
        Random rand = new Random();
        int d100 = rand.nextInt(100);
        SystemMotion motion = null;
        motion = d100 < 10 ? SystemMotion.FIXED : (d100 < 15 ? SystemMotion.RANDOM : (d100 < 50 ? SystemMotion.CLOCKWISE : (d100 < 85 ? SystemMotion.COUNTERCLOCKWISE : (d100 < 95 ? SystemMotion.MIXED : SystemMotion.SPECIAL))));
        return motion;
    }

    private void setPlanetAttrs(org.w3c.dom.Element elem, Planet planet) {
        elem.setAttribute("name", planet.getName());
        elem.setAttribute("shape", planet.getShape().toString().toLowerCase());
        elem.setAttribute("type", planet.getType().toString().toLowerCase());
        if (planet.getOrbitDist() > 0L) {
            elem.setAttribute("distance", Long.toString(planet.getOrbitDist()));
            elem.setAttribute("motion", planet.getMotion().toString().toLowerCase());
        }
        if (planet.getInclination() != 0.0) {
            elem.setAttribute("inclination", Double.toString(planet.getInclination()));
        }
        if (planet.getRightAscension() != 0.0) {
            elem.setAttribute("ascension", Double.toString(planet.getRightAscension()));
        }
        elem.setAttribute("size", Long.toString(planet.getSize()));
        if (planet.getOrbitTime() != 0) {
            elem.setAttribute("year", Integer.toString(Math.abs(planet.getOrbitTime())));
        }
        for (String desc : planet.getDescription()) {
            org.w3c.dom.Element descElem = elem.getOwnerDocument().createElement("description");
            descElem.setTextContent(desc);
            elem.appendChild(descElem);
        }
    }

    public void writeXml(File outFile) {
        try {
            DocumentBuilder docBuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuild.newDocument();
            org.w3c.dom.Element sysElem = doc.createElement("system");
            sysElem.setAttribute("name", this.name);
            doc.appendChild(sysElem);
            for (Planet planet : this.planets) {
                if (planet.getType().equals((Object)Element.VOID)) continue;
                org.w3c.dom.Element planetElem = planet.getOrbitDist() == 0L ? doc.createElement("primary") : doc.createElement("planet");
                this.setPlanetAttrs(planetElem, planet);
                sysElem.appendChild(planetElem);
                for (Planet moon : planet.getMoons()) {
                    if (planet.getOrbitDist() <= 0L) continue;
                    org.w3c.dom.Element moonElem = doc.createElement("moon");
                    this.setPlanetAttrs(moonElem, moon);
                    planetElem.appendChild(moonElem);
                }
            }
            Planet primary = this.planets.first();
            if (primary.getOrbitDist() == 0L) {
                for (Planet moon : primary.getMoons()) {
                    org.w3c.dom.Element astElem = doc.createElement("astronomical");
                    this.setPlanetAttrs(astElem, moon);
                    sysElem.appendChild(astElem);
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            FileWriter writer = outFile == null ? new FileWriter(String.valueOf(this.name) + ".xml") : new FileWriter(outFile);
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            writer.close();
        }
        catch (Exception exc) {
            System.err.println("Cannot initialize KmlWriter:");
            exc.printStackTrace();
        }
    }
}

