/*
 * Decompiled with CFR 0.152.
 */
package rpg.spelljammer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import rpg.Element;
import rpg.spelljammer.Planet;
import rpg.spelljammer.PlanetShape;
import rpg.spelljammer.SystemMotion;

public class PlanetMaker
extends JDialog {
    private static final long serialVersionUID = 2607058486314967603L;
    private Planet planet;
    JComboBox shapeCombo = new JComboBox<PlanetShape>(PlanetShape.values());
    JComboBox typeCombo = new JComboBox<Element>(Element.values());
    JComboBox motionCombo = new JComboBox<SystemMotion>(SystemMotion.values());
    JLabel sizeLabel = new JLabel("Size:");
    JTextField sizeField = new JTextField();
    JTextField distField = new JTextField();
    JTextField yearField = new JTextField();
    JTextArea descArea = new JTextArea(4, 30);
    JTextField nameField = new JTextField();
    JTextField incField = new JTextField();
    JTextField ascField = new JTextField();

    public PlanetMaker() {
        this.setupDisplay();
        this.setModal(true);
    }

    protected void closePane() {
        this.setVisible(false);
    }

    private void displayPlanet() {
        this.nameField.setText(this.planet.getName());
        this.sizeLabel.setText("Size: (" + this.planet.getSizeChar() + ") ");
        this.sizeField.setText(Long.toString(this.planet.getSize()));
        this.shapeCombo.setSelectedItem((Object)this.planet.getShape());
        this.typeCombo.setSelectedItem((Object)this.planet.getType());
        this.distField.setText(Long.toString(this.planet.getOrbitDist()));
        this.yearField.setText(Integer.toString(Math.abs(this.planet.getOrbitTime())));
        this.motionCombo.setSelectedItem((Object)this.planet.getMotion());
        this.descArea.setText(this.planet.getTextDescription());
    }

    protected void savePlanetData() {
        if (this.planet != null) {
            String yearStr;
            String distStr;
            this.planet.setName(this.nameField.getText());
            this.planet.setShape((PlanetShape)((Object)this.shapeCombo.getSelectedItem()));
            this.planet.setType((Element)((Object)this.typeCombo.getSelectedItem()));
            this.planet.setMotion((SystemMotion)((Object)this.motionCombo.getSelectedItem()));
            String sizeStr = this.sizeField.getText();
            if (sizeStr.length() > 0) {
                this.planet.setSize(Integer.parseInt(sizeStr));
            }
            if ((distStr = this.distField.getText()).length() > 0) {
                this.planet.setOrbitDist(Long.parseLong(distStr));
            }
            if ((yearStr = this.yearField.getText()).length() > 0) {
                this.planet.setOrbitTime(Integer.parseInt(yearStr));
            }
            this.planet.setTextDescription(this.descArea.getText());
        }
    }

    public void setPlanet(Planet planet) {
        this.planet = planet;
        this.displayPlanet();
    }

    private void setupDisplay() {
        this.setLayout(new BorderLayout());
        JPanel dataPane = new JPanel(new GridLayout(0, 2));
        this.add((Component)dataPane, "North");
        dataPane.add(new JLabel("Name:"));
        dataPane.add(this.nameField);
        dataPane.add(this.sizeLabel);
        dataPane.add(this.sizeField);
        dataPane.add(new JLabel("Shape:"));
        dataPane.add(this.shapeCombo);
        dataPane.add(new JLabel("Type:"));
        dataPane.add(this.typeCombo);
        dataPane.add(new JLabel("Orbit Distance (miles): "));
        dataPane.add(this.distField);
        dataPane.add(new JLabel("Orbit Period (days): "));
        dataPane.add(this.yearField);
        dataPane.add(new JLabel("Orbital Motion: "));
        dataPane.add(this.motionCombo);
        dataPane.add(new JLabel("Inclination (degrees): "));
        dataPane.add(this.incField);
        dataPane.add(new JLabel("Ascension (degrees): "));
        dataPane.add(this.ascField);
        this.add(this.descArea);
        JPanel butnPane = new JPanel(new GridLayout(1, 0));
        JButton saveButn = new JButton("Save");
        JButton resetButn = new JButton("Reset");
        JButton closeButn = new JButton("Close");
        butnPane.add(saveButn);
        butnPane.add(resetButn);
        butnPane.add(closeButn);
        saveButn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanetMaker.this.savePlanetData();
                PlanetMaker.this.closePane();
            }
        });
        resetButn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanetMaker.this.displayPlanet();
            }
        });
        closeButn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanetMaker.this.closePane();
            }
        });
        this.sizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String sizeVal = PlanetMaker.this.sizeField.getText();
                char sizeChar = sizeVal.trim().charAt(0);
                if (Character.isLetter(sizeChar)) {
                    long size = Planet.randomSize(sizeChar);
                    PlanetMaker.this.sizeField.setText(Long.toString(size));
                } else if (!Character.isDigit(sizeChar)) {
                    JOptionPane.showMessageDialog(PlanetMaker.this, "Size must be an integer or a size character", "Format Error", 0);
                    PlanetMaker.this.sizeField.setText("");
                }
            }
        });
        ActionListener forceNum = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextField srcField = (JTextField)evt.getSource();
                String text = srcField.getText();
                try {
                    Long.parseLong(text.trim());
                }
                catch (NumberFormatException exc) {
                    JOptionPane.showMessageDialog(PlanetMaker.this, "Enter an Integer value", "Number Format Error", 0);
                    srcField.setText("");
                }
            }
        };
        this.distField.addActionListener(forceNum);
        this.yearField.addActionListener(forceNum);
        this.add((Component)butnPane, "South");
    }
}

