/*
 * Decompiled with CFR 0.152.
 */
package rpg.spelljammer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.NodeList;
import rpg.Dice;
import rpg.Element;
import rpg.spelljammer.PlanetShape;
import rpg.spelljammer.SolarSystem;
import rpg.spelljammer.SystemMotion;

public class Planet
implements Serializable,
Comparable<Planet> {
    private static final long serialVersionUID = -8288019804764887631L;
    private String name;
    private long size;
    private Element type;
    private PlanetShape shape;
    private int orbitTime;
    private long orbitDist;
    private double inclination = 0.0;
    private double rightAscen = 0.0;
    private char symbol;
    private TreeSet<Planet> moons = new TreeSet();
    private ArrayList<String> descripts = new ArrayList();
    private SystemMotion motion;

    public Planet() {
    }

    public Planet(org.w3c.dom.Element elem) {
        int i;
        String symbolStr;
        String motionString;
        String ascStr;
        String incStr;
        String yearStr;
        String distance;
        this.name = elem.getAttribute("name");
        String shapeStr = elem.getAttribute("shape");
        this.shape = shapeStr != null && shapeStr.length() > 0 ? PlanetShape.valueOf(shapeStr.toUpperCase()) : PlanetShape.SPHERE;
        String elemStr = elem.getAttribute("type");
        this.type = elemStr != null && elemStr.length() > 0 ? Element.valueOf(elemStr.toUpperCase()) : Element.EARTH;
        String sizeStr = elem.getAttribute("size");
        if (sizeStr != null && sizeStr.length() > 0) {
            try {
                this.size = Long.parseLong(sizeStr);
            }
            catch (NumberFormatException exc) {
                this.size = Planet.randomSize(sizeStr.toUpperCase().charAt(0));
            }
        } else {
            this.size = Planet.randomSize(this.type);
        }
        if ((distance = elem.getAttribute("distance")) != null && distance.length() > 0) {
            this.orbitDist = Long.parseLong(distance);
            if (this.orbitDist < 1000000L && elem.getTagName().equals("planet")) {
                this.orbitDist *= 1000000L;
            }
        }
        if ((yearStr = elem.getAttribute("year")) != null && yearStr.length() > 0) {
            this.orbitTime = Integer.parseInt(yearStr);
        }
        if ((incStr = elem.getAttribute("inclination")) != null && incStr.length() > 0) {
            this.inclination = Double.parseDouble(incStr);
            if (this.inclination == 90.0) {
                this.inclination -= 0.01;
            }
        }
        if ((ascStr = elem.getAttribute("ascension")) != null && ascStr.length() > 0) {
            this.rightAscen = Double.parseDouble(ascStr);
        }
        if ((motionString = elem.getAttribute("motion")) != null && motionString.length() > 0) {
            this.motion = SystemMotion.valueOf(motionString.toUpperCase());
            if (this.motion == SystemMotion.CLOCKWISE) {
                this.orbitTime = -this.orbitTime;
            }
        }
        this.symbol = (symbolStr = elem.getAttribute("symbol")) != null && symbolStr.length() > 0 ? symbolStr.charAt(0) : this.shape.getSymbol();
        if (!elem.getTagName().equals("moon")) {
            NodeList moonList = elem.getElementsByTagName("moon");
            i = 0;
            while (i < moonList.getLength()) {
                org.w3c.dom.Element moonElem = (org.w3c.dom.Element)moonList.item(i);
                Planet moon = new Planet(moonElem);
                Planet.addMoonOrbit(this, moon);
                this.moons.add(moon);
                ++i;
            }
        }
        NodeList descList = elem.getElementsByTagName("description");
        i = 0;
        while (i < descList.getLength()) {
            org.w3c.dom.Element descElem = (org.w3c.dom.Element)descList.item(i);
            if (descElem.getParentNode().equals(elem)) {
                this.descripts.add(descElem.getTextContent());
            }
            ++i;
        }
    }

    public Planet(String name) {
        this.name = name;
    }

    public void addMoon(Planet moon) {
        this.moons.add(moon);
    }

    public void addToDescription(String description) {
        this.descripts.add(description);
    }

    @Override
    public int compareTo(Planet planet2) {
        int comp = 0;
        long diff = planet2.getOrbitDist() - this.orbitDist;
        comp = diff == 0L ? this.name.compareTo(planet2.getName()) : (diff > 0L ? -1 : 1);
        return comp;
    }

    public List<String> getDescription() {
        return this.descripts;
    }

    public String getDetails() {
        StringBuffer buf = new StringBuffer(this.toString());
        if (this.orbitDist > 0L) {
            buf.append("\nOrbit Radius: " + this.orbitDist);
            if (this.orbitTime != 0) {
                buf.append("  Orbit Time: " + Math.abs(this.orbitTime));
                if (this.orbitTime > 0) {
                    buf.append(" days counterclockwise");
                } else {
                    buf.append(" days clockwise");
                }
            } else if (this.motion.equals((Object)SystemMotion.FIXED)) {
                buf.append("  Fixed");
            } else if (this.motion.equals((Object)SystemMotion.RANDOM)) {
                buf.append("  Random Motion");
            } else {
                buf.append("  " + this.motion.toString().toLowerCase() + " motion");
            }
        }
        for (String desc : this.descripts) {
            buf.append(String.valueOf('\n') + desc);
        }
        for (Planet moon : this.moons) {
            buf.append("\n  " + moon.toString());
            List<String> moonDesc = moon.getDescription();
            for (String desc : moonDesc) {
                buf.append("\n  " + desc);
            }
        }
        return buf.toString();
    }

    public double getInclination() {
        return this.inclination;
    }

    public Set<Planet> getMoons() {
        return this.moons;
    }

    public SystemMotion getMotion() {
        return this.motion;
    }

    public String getName() {
        return this.name;
    }

    public long getOrbitDist() {
        return this.orbitDist;
    }

    public int getOrbitTime() {
        return this.orbitTime;
    }

    public double getRightAscension() {
        return this.rightAscen;
    }

    public PlanetShape getShape() {
        return this.shape;
    }

    public long getSize() {
        return this.size;
    }

    public char getSizeChar() {
        int sizeChar = 74;
        sizeChar = this.size < 10L ? 65 : (this.size < 100L ? 66 : (this.size < 1000L ? 67 : (this.size < 4000L ? 68 : (this.size < 10000L ? 69 : (this.size < 40000L ? 70 : (int)((char)(Math.log10(this.size) + 67.0)))))));
        return (char)sizeChar;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public Element getType() {
        return this.type;
    }

    public void setInclination(double inclination) {
        this.inclination = inclination;
    }

    public void setMotion(SystemMotion motion) {
        this.motion = motion;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrbitDist(long orbitDist) {
        this.orbitDist = orbitDist;
    }

    public void setOrbitTime(int orbitTime) {
        this.orbitTime = orbitTime;
    }

    public void setRightAscension(double rightAscen) {
        this.rightAscen = rightAscen;
    }

    public void setShape(PlanetShape shape) {
        this.shape = shape;
        if (this.symbol == '\u0000') {
            this.symbol = shape.getSymbol();
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSymbol(char symbol) {
        this.symbol = symbol;
    }

    public void setType(Element type) {
        this.type = type;
    }

    public String toString() {
        String rep = null;
        rep = this.type.equals((Object)Element.VOID) ? "Empty Space" : String.valueOf(this.name) + ": Size " + this.getSizeChar() + " " + this.shape.toString().toLowerCase() + " " + this.type.toString().toLowerCase() + " world.";
        return rep;
    }

    private static void addMoonOrbit(Planet planet, Planet moon) {
        long radius;
        int mult;
        if (moon.getOrbitDist() == 0L && moon.getOrbitTime() == 0) {
            mult = Dice.roll(3, 10);
            radius = (long)mult * planet.getSize();
            radius = Math.round(radius / 1000L) * 1000;
            if ((mult += Dice.roll(2, 10) - Dice.roll(1, 10)) < 0) {
                mult = Dice.roll(1, 10);
            }
            moon.setOrbitDist(radius);
            moon.setOrbitTime(mult);
        } else if (moon.getOrbitDist() == 0L) {
            mult = moon.getOrbitTime() - Dice.roll(2, 10) + Dice.roll(1, 10);
            if (mult < 1) {
                mult = Dice.roll(1, 10);
            }
            radius = (long)mult * planet.getSize();
            radius = Math.round(radius / 1000L) * 1000;
            moon.setOrbitDist(radius);
        } else if (moon.getOrbitTime() == 0) {
            mult = (int)(moon.getOrbitDist() / moon.getSize()) + Dice.roll(2, 10) - Dice.roll(1, 10);
            if (mult < 0) {
                mult = Dice.roll(1, 10);
            }
            moon.setOrbitTime(mult);
        }
        if (moon.getMotion() == null) {
            SystemMotion moonMotion = SolarSystem.randomMotion();
            while (moonMotion.equals((Object)SystemMotion.MIXED)) {
                moonMotion = SolarSystem.randomMotion();
            }
            moon.setMotion(moonMotion);
        }
    }

    private static void generateGoodies(Planet planet, boolean isMoon) {
        Random rand = new Random();
        int d100 = rand.nextInt(100);
        if (d100 < 10) {
            if (!isMoon) {
                Planet.generateMoon(planet);
            }
            Planet.generateGoodies(planet, isMoon);
        } else if (d100 < 25) {
            if (!isMoon) {
                int numMoons = rand.nextInt(4) + 1;
                int i = 0;
                while (i < numMoons) {
                    Planet.generateMoon(planet);
                    ++i;
                }
            }
            if (d100 > 19) {
                Planet.generateGoodies(planet, isMoon);
            }
        } else if (d100 < 35) {
            Planet cluster = new Planet();
            cluster.setType(Planet.randomType());
            cluster.setShape(PlanetShape.CLUSTER);
            int size = Planet.randomSize(cluster.getType());
            while ((long)size > planet.getSize()) {
                size = Planet.randomSize(cluster.getType());
            }
            cluster.setSize(size);
            Planet.addMoonOrbit(planet, cluster);
            planet.addMoon(cluster);
        } else if (d100 < 45) {
            planet.addToDescription("Ring of Earth.");
        } else if (d100 < 55) {
            planet.addToDescription("Ring of Fire.");
        } else if (d100 < 65) {
            planet.addToDescription("Ring of Water/Ice.");
        } else if (d100 < 75) {
            planet.addToDescription("Hotter than Normal.");
        } else if (d100 < 85) {
            planet.addToDescription("Colder than Normal");
        } else if (d100 < 95) {
            planet.addToDescription("Voidworld");
        } else if (d100 < 99) {
            planet.addToDescription("Civilization: World Empire.");
        } else {
            Planet.generateGoodies(planet, isMoon);
            Planet.generateGoodies(planet, isMoon);
        }
    }

    public static void generateMoon(Planet planet) {
        Planet moon = Planet.generateRandom(new Planet(), true);
        while (moon.getSize() > planet.getSize()) {
            moon.setSize(Planet.randomSize(moon.getType()));
        }
        Planet.addMoonOrbit(planet, moon);
        moon.setName(String.valueOf(planet.getName()) + ":Moon_" + planet.getMoons().size());
        planet.addMoon(moon);
    }

    public static Planet generateRandom() {
        return Planet.generateRandom(new Planet(), false);
    }

    public static Planet generateRandom(Planet planet, boolean isMoon) {
        if (planet.getType() == null) {
            planet.setType(Planet.randomType());
        }
        if (planet.getShape() == null) {
            planet.setShape(Planet.randomShape());
        }
        if (planet.getSize() == 0L) {
            planet.setSize(Planet.randomSize(planet.getType()));
        }
        Planet.generateGoodies(planet, isMoon);
        return planet;
    }

    private static PlanetShape randomShape() {
        Random rand = new Random();
        PlanetShape shape = null;
        int d100 = rand.nextInt(100);
        shape = d100 < 5 ? PlanetShape.AMORPHOUS : (d100 < 15 ? PlanetShape.BELT : (d100 < 20 ? PlanetShape.CLUSTER : (d100 < 65 ? PlanetShape.SPHERE : (d100 < 70 ? PlanetShape.CUBE : (d100 < 90 ? PlanetShape.FLAT : (d100 < 95 ? PlanetShape.ELLIPTICAL : (d100 < 99 ? PlanetShape.REGULAR : PlanetShape.IRREGULAR)))))));
        return shape;
    }

    public static int randomSize(char sizeChar) {
        char sizeCh = Character.toUpperCase(sizeChar);
        Random rand = new Random();
        int size = 0;
        size = sizeCh == 'A' ? rand.nextInt(9) + 1 : (sizeCh == 'B' ? rand.nextInt(90) + 10 : (sizeCh == 'C' ? rand.nextInt(900) + 100 : (sizeCh == 'D' ? rand.nextInt(3000) + 1000 : (sizeCh == 'E' ? rand.nextInt(6000) + 4000 : (sizeCh == 'F' ? 100 * (rand.nextInt(300) + 100) : (sizeCh == 'G' ? 100 * (rand.nextInt(600) + 400) : (sizeCh == 'H' ? 1000 * (rand.nextInt(900) + 100) : (sizeCh == 'I' ? 10000 * (rand.nextInt(900) + 100) : 100000 * (rand.nextInt(900) + 100)))))))));
        return size;
    }

    private static int randomSize(Element type) {
        Random rand = new Random();
        int d100 = rand.nextInt(100);
        int size = 0;
        size = type.equals((Object)Element.AIR) || type.equals((Object)Element.FIRE) ? (d100 < 2 ? rand.nextInt(9) + 1 : (d100 < 5 ? rand.nextInt(90) + 10 : (d100 < 10 ? rand.nextInt(900) + 100 : (d100 < 20 ? rand.nextInt(300) + 1000 : (d100 < 35 ? rand.nextInt(6000) + 4000 : (d100 < 50 ? 100 * (rand.nextInt(300) + 100) : (d100 < 70 ? 100 * (rand.nextInt(600) + 400) : (d100 < 85 ? 1000 * (rand.nextInt(900) + 100) : (d100 < 95 ? 10000 * (rand.nextInt(900) + 100) : 100000 * (rand.nextInt(900) + 100)))))))))) : (d100 < 5 ? rand.nextInt(9) + 1 : (d100 < 10 ? rand.nextInt(90) + 10 : (d100 < 20 ? rand.nextInt(900) + 100 : (d100 < 40 ? rand.nextInt(300) + 1000 : (d100 < 60 ? rand.nextInt(6000) + 4000 : (d100 < 80 ? 100 * (rand.nextInt(300) + 100) : (d100 < 90 ? 100 * (rand.nextInt(600) + 400) : 1000 * (rand.nextInt(900) + 100))))))));
        return size;
    }

    private static Element randomType() {
        Random rand = new Random();
        Element type = null;
        int d100 = rand.nextInt(100);
        type = d100 < 40 ? Element.EARTH : (d100 < 60 ? Element.FIRE : (d100 < 80 ? Element.AIR : (d100 < 99 ? Element.WATER : Element.LIVE)));
        return type;
    }

    public void setTextDescription(String description) {
        String[] descs = description.split("\n");
        this.descripts.clear();
        String[] stringArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            String desc = stringArray[n2];
            this.descripts.add(desc);
            ++n2;
        }
    }

    public String getTextDescription() {
        StringBuffer descBuf = new StringBuffer();
        for (String desc : this.descripts) {
            if (descBuf.length() > 0) {
                descBuf.append('\n');
            }
            descBuf.append(desc);
        }
        return descBuf.toString();
    }
}

