/*
 * Decompiled with CFR 0.152.
 */
package rpg.spelljammer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import rpg.spelljammer.OrbitCalculator;
import rpg.spelljammer.Planet;
import rpg.spelljammer.PlanetShape;
import rpg.spelljammer.Point3D;
import rpg.spelljammer.SolarSystem;
import rpg.spelljammer.SystemMotion;

public class OrbitDisplay {
    private OrbitCalculator calc = new OrbitCalculator();
    private SolarSystem system;

    public OrbitDisplay(SolarSystem system) {
        this.setSystem(system);
    }

    public BufferedImage createInnerMap(int resolution) {
        TreeSet<Planet> inner = new TreeSet<Planet>();
        for (Planet planet : this.system.getPlanets()) {
            if (planet.getOrbitDist() >= 350000000L) continue;
            inner.add(planet);
        }
        return this.createSphereMap(resolution, inner, false);
    }

    public BufferedImage createOuterMap(int resolution) {
        TreeSet<Planet> outer = new TreeSet<Planet>();
        for (Planet planet : this.system.getPlanets()) {
            if (planet.getOrbitDist() <= 350000000L && planet.getOrbitDist() != 0L) continue;
            outer.add(planet);
        }
        return this.createSphereMap(resolution, outer, true);
    }

    public BufferedImage createPlanetMap(int resolution, Planet planet) {
        long tmpDist = planet.getOrbitDist();
        planet.setOrbitDist(0L);
        TreeSet<Planet> moonSys = new TreeSet<Planet>();
        moonSys.addAll(planet.getMoons());
        moonSys.add(planet);
        BufferedImage img = this.createSphereMap(resolution, moonSys, false);
        planet.setOrbitDist(tmpDist);
        return img;
    }

    public BufferedImage createSidebarImage() {
        return this.createSidebarImage(100, 600, 20);
    }

    public BufferedImage createSidebarImage(int width, int height, int margin) {
        BufferedImage bufImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufImage.createGraphics();
        Font font = g.getFont();
        font = font.deriveFont(1, 10.0f);
        g.setFont(font);
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, width, height);
        double scale = 2.0 * (double)(height - 2 * margin) / (double)this.system.getSphereRadius();
        int lastY = -1;
        AffineTransform ident = new AffineTransform();
        HashMap<Planet, Point> planetLocs = new HashMap<Planet, Point>();
        for (Planet planet : this.system.getPlanets()) {
            long dist = planet.getOrbitDist();
            int drawY = margin + (int)((double)dist * scale);
            if (lastY != -1 && drawY - lastY < 9) {
                drawY = lastY + 10;
            }
            g.setColor(planet.getType().getColor());
            if (planet.getInclination() != 0.0) {
                double inc = Math.cos(planet.getInclination() * Math.PI / 180.0);
                AffineTransform xform = AffineTransform.getTranslateInstance(margin, margin);
                xform.concatenate(AffineTransform.getScaleInstance(inc, 1.0));
                xform.concatenate(AffineTransform.getTranslateInstance(-margin, -margin));
                g.setTransform(xform);
            }
            if (planet.getShape().equals((Object)PlanetShape.BELT)) {
                int beltWidth = planet.getSizeChar() - 65 + 1;
                int scaledWidth = (int)((double)planet.getSize() * scale);
                if (scaledWidth > beltWidth) {
                    beltWidth = scaledWidth;
                }
                this.drawBelt(g, margin, margin, drawY - margin, beltWidth);
            } else {
                SystemMotion motion = planet.getMotion();
                if (motion.equals((Object)SystemMotion.CLOCKWISE) || motion.equals((Object)SystemMotion.COUNTERCLOCKWISE)) {
                    this.drawOrbit(g, margin, margin, drawY - margin);
                }
            }
            Point pt = new Point(margin, drawY);
            planetLocs.put(planet, pt);
            lastY = drawY;
            g.setTransform(ident);
        }
        g.setColor(Color.BLACK);
        for (Planet planet : planetLocs.keySet()) {
            Point pt = (Point)planetLocs.get(planet);
            this.drawPlanet(planet, g, pt.x, pt.y, true);
        }
        for (Planet planet : planetLocs.keySet()) {
            Point pt = (Point)planetLocs.get(planet);
            g.setColor(planet.getType().getColor());
            this.drawPlanet(planet, g, pt.x, pt.y, false);
        }
        return bufImage;
    }

    public BufferedImage createSphereMap(int resolution) {
        return this.createSphereMap(resolution, new TreeSet<Planet>(this.system.getPlanets()), true);
    }

    private BufferedImage createSphereMap(int resolution, TreeSet<Planet> planets, boolean drawSphere) {
        Point pt;
        BufferedImage bufImage = new BufferedImage(resolution, resolution, 2);
        Graphics2D g = bufImage.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, resolution, resolution);
        double scale = drawSphere ? 0.5 * (double)resolution / (double)this.system.getSphereRadius() : 0.45 * (double)resolution / (double)planets.last().getOrbitDist();
        int originX = resolution / 2;
        int originY = resolution / 2;
        HashMap<Planet, Point> planetLocs = new HashMap<Planet, Point>();
        AffineTransform ident = new AffineTransform();
        HashMap<Planet, Point3D> locs = this.calc.computeLocations();
        for (Planet planet : planets) {
            g.setColor(planet.getType().getColor());
            Point3D loc = locs.get(planet);
            int diffX = (int)(loc.getX() * scale);
            int diffY = (int)(loc.getY() * scale);
            int drawX = resolution / 2 + diffX;
            int drawY = resolution / 2 - diffY;
            double dist = (double)planet.getOrbitDist() * scale;
            if (planet.getInclination() != 0.0 || planet.getRightAscension() != 0.0) {
                double inc = Math.cos(planet.getInclination() * Math.PI / 180.0);
                double ras = -planet.getRightAscension() * Math.PI / 180.0;
                AffineTransform xform = AffineTransform.getTranslateInstance(resolution / 2, resolution / 2);
                xform.concatenate(AffineTransform.getRotateInstance(ras));
                xform.concatenate(AffineTransform.getScaleInstance(1.0, inc));
                xform.concatenate(AffineTransform.getTranslateInstance(-resolution / 2, -resolution / 2));
                g.setTransform(xform);
            }
            if (planet.getShape().equals((Object)PlanetShape.BELT)) {
                int beltWidth = planet.getSizeChar() - 65 + 1;
                int scaledWidth = (int)((double)planet.getSize() * scale);
                if (scaledWidth > beltWidth) {
                    beltWidth = scaledWidth;
                }
                this.drawBelt(g, originX, originY, dist, beltWidth);
            } else {
                SystemMotion motion = planet.getMotion();
                if (motion.equals((Object)SystemMotion.CLOCKWISE) || motion.equals((Object)SystemMotion.COUNTERCLOCKWISE)) {
                    this.drawOrbit(g, originX, originY, dist);
                }
            }
            Point pt2 = new Point(drawX, drawY);
            planetLocs.put(planet, pt2);
            g.setTransform(ident);
        }
        g.setColor(Color.BLACK);
        for (Planet planet : planetLocs.keySet()) {
            pt = (Point)planetLocs.get(planet);
            this.drawPlanet(planet, g, pt.x, pt.y, true);
        }
        for (Planet planet : planetLocs.keySet()) {
            pt = (Point)planetLocs.get(planet);
            g.setColor(planet.getType().getColor());
            this.drawPlanet(planet, g, pt.x, pt.y, false);
        }
        if (drawSphere) {
            g.setColor(Color.WHITE);
            g.drawOval(0, 0, resolution, resolution);
            g.drawOval(1, 1, resolution - 2, resolution - 2);
            g.drawOval(2, 2, resolution - 4, resolution - 4);
        }
        this.drawScaleLine(g, resolution, scale);
        return bufImage;
    }

    private void drawBelt(Graphics2D g, int centerX, int centerY, double dist, int width) {
        int intDist = (int)Math.round(dist) - width / 2;
        Stroke curStroke = g.getStroke();
        Random rand = new Random();
        int i = 0;
        while (i < width) {
            int rad = intDist + i;
            float[] dashArr = new float[8];
            int j = 0;
            while (j < 4) {
                dashArr[j * 2] = rand.nextFloat() * 2.0f;
                dashArr[j * 2 + 1] = rand.nextFloat() * 6.0f;
                ++j;
            }
            g.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, dashArr, 0.0f));
            g.drawOval(centerX - rad, centerY - rad, rad * 2, rad * 2);
            ++i;
        }
        g.setStroke(curStroke);
    }

    private void drawOrbit(Graphics2D g, int centerX, int centerY, double dist) {
        int intDist = (int)Math.round(dist);
        g.drawOval(centerX - intDist, centerY - intDist, intDist * 2, intDist * 2);
    }

    private void drawPlanet(Planet planet, Graphics2D g, int drawX, int drawY, boolean clear) {
        String planetChar = String.valueOf(Character.toString(planet.getSymbol())) + "  " + planet.getName();
        if (planet.getShape().equals((Object)PlanetShape.BELT)) {
            planetChar = planet.getName();
        }
        FontMetrics fm = g.getFontMetrics();
        int wid = fm.charsWidth(planetChar.toCharArray(), 0, 1);
        int black = fm.stringWidth(planetChar);
        LineMetrics met = fm.getLineMetrics(planetChar, g);
        int ascend = (int)met.getAscent();
        int baseX = drawX - wid / 2;
        int baseY = drawY + ascend / 2;
        if (clear) {
            g.fillRect(baseX - 1, baseY - ascend, black + 2, ascend + (int)met.getDescent());
        } else {
            g.drawString(planetChar, baseX, baseY);
        }
    }

    private void drawScaleLine(Graphics2D g, int resolution, double scale) {
        FontMetrics fm = g.getFontMetrics();
        int span = fm.stringWidth("1 SJD");
        double len = 1.0E8 * scale;
        g.drawLine(15 + span / 2, resolution - 15, (int)(15.0 + len + (double)(span / 2)), resolution - 15);
        g.drawString("1 SJD", 15, resolution - 3);
    }

    public void setDaysFromZero(long daysFromZero) {
        this.calc.setDaysFromZero(daysFromZero);
    }

    public long getDaysFromZero() {
        return this.calc.getDaysFromZero();
    }

    public void setSystem(SolarSystem system) {
        this.system = system;
        this.calc.setSystem(system);
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        Planet planet;
        SolarSystem system = null;
        int res = 600;
        int margin = 20;
        boolean doMap = false;
        boolean doInner = false;
        boolean doOuter = false;
        boolean doSide = false;
        boolean writeXml = false;
        int planetInx = -1;
        Point sideSize = new Point(100, 600);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equalsIgnoreCase("map")) {
                doMap = true;
            } else if (arg.equalsIgnoreCase("inner")) {
                doInner = true;
            } else if (arg.equalsIgnoreCase("inner")) {
                doInner = true;
            } else if (arg.equalsIgnoreCase("outer")) {
                doInner = true;
            } else if (arg.equalsIgnoreCase("side")) {
                doInner = true;
            } else if (arg.toLowerCase().startsWith("planet")) {
                planetInx = Integer.parseInt(arg.substring(6));
            } else if (arg.equalsIgnoreCase("xml")) {
                writeXml = true;
            } else if (Character.isDigit(arg.charAt(0))) {
                String[] sizes = arg.split("x");
                if (sizes.length > 1) {
                    sideSize = new Point(Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1]));
                    if (sizes.length > 2) {
                        margin = Integer.parseInt(sizes[2]);
                    }
                } else {
                    res = Integer.parseInt(arg);
                }
            } else {
                File file = new File(arg);
                DocumentBuilder docBuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuild.parse(new FileInputStream(file));
                Element root = doc.getDocumentElement();
                system = new SolarSystem(root);
            }
            ++n2;
        }
        if (system == null) {
            system = SolarSystem.generateRandom();
        }
        OrbitDisplay disp = new OrbitDisplay(system);
        if (doMap) {
            BufferedImage map = disp.createSphereMap(res);
            File imageFile = new File(String.valueOf(system.getName()) + ".png");
            ImageIO.write((RenderedImage)map, "PNG", imageFile);
        }
        if (doSide) {
            BufferedImage side = disp.createSidebarImage(sideSize.x, sideSize.y, margin);
            File sideImage = new File(String.valueOf(system.getName()) + "_side.png");
            ImageIO.write((RenderedImage)side, "PNG", sideImage);
        }
        if (doInner) {
            BufferedImage map = disp.createInnerMap(res);
            File imageFile = new File(String.valueOf(system.getName()) + "_inner.png");
            ImageIO.write((RenderedImage)map, "PNG", imageFile);
        }
        if (doOuter) {
            BufferedImage map = disp.createOuterMap(res);
            File imageFile = new File(String.valueOf(system.getName()) + "_outer.png");
            ImageIO.write((RenderedImage)map, "PNG", imageFile);
        }
        if (planetInx > 0 && !(planet = system.getPlanet(planetInx)).getMoons().isEmpty()) {
            BufferedImage map = disp.createPlanetMap(res, planet);
            File imageFile = new File(String.valueOf(planet.getName()) + ".png");
            ImageIO.write((RenderedImage)map, "PNG", imageFile);
        }
        if (writeXml) {
            system.writeXml(null);
        }
    }
}

