/*
 * Decompiled with CFR 0.152.
 */
package rpg.spelljammer;

import java.util.Date;
import java.util.HashMap;
import rpg.spelljammer.Planet;
import rpg.spelljammer.Point3D;
import rpg.spelljammer.SolarSystem;

public class OrbitCalculator {
    private long daysFromZero = new Date().getTime();
    private SolarSystem system;

    public long getDaysFromZero() {
        return this.daysFromZero;
    }

    public OrbitCalculator() {
    }

    public OrbitCalculator(SolarSystem system) {
        this.setSystem(system);
    }

    public int calcTravelTime(double theta, double rho, Planet dest) {
        long sphereRad = this.system.getSphereRadius();
        HashMap<Planet, Point3D> locs = this.computeLocations();
        double ang = theta * Math.PI / 180.0;
        Point3D srcPt = new Point3D((double)sphereRad * Math.cos(ang) * Math.cos(rho), (double)sphereRad * Math.sin(ang) * Math.cos(rho), (double)sphereRad * Math.sin(rho));
        Point3D dstPt = locs.get(dest);
        int days = (int)Math.ceil(srcPt.distance(dstPt) / 1.0E7);
        return days;
    }

    public int calcTravelTime(Planet start, Planet dest) {
        HashMap<Planet, Point3D> locs = this.computeLocations();
        Point3D srcPt = locs.get(start);
        Point3D dstPt = locs.get(dest);
        int days = (int)Math.ceil(srcPt.distance(dstPt) / 1.0E7);
        return days;
    }

    public HashMap<Planet, Point3D> computeLocations() {
        HashMap<Planet, Point3D> locs = new HashMap<Planet, Point3D>();
        for (Planet planet : this.system.getPlanets()) {
            long dist = planet.getOrbitDist();
            int time = planet.getOrbitTime();
            double frac = 0.0;
            if (time != 0) {
                long dayOfYear = this.daysFromZero % (long)time;
                frac = (double)dayOfYear / (double)time;
            }
            double inc = planet.getInclination() * Math.PI / 180.0;
            double ras = planet.getRightAscension() * Math.PI / 180.0;
            double xTmp = Math.cos(frac *= Math.PI * 2) * (double)dist;
            double yTmp = Math.sin(frac) * Math.cos(inc) * (double)dist;
            double zCoord = Math.sin(frac) * Math.sin(inc) * (double)dist;
            double xCoord = xTmp * Math.cos(ras) - yTmp * Math.sin(ras);
            double yCoord = yTmp * Math.cos(ras) + xTmp * Math.sin(ras);
            Point3D newPt = new Point3D(xCoord, yCoord, zCoord);
            locs.put(planet, newPt);
            for (Planet moon : planet.getMoons()) {
                dist = moon.getOrbitDist();
                time = moon.getOrbitTime();
                if (dist <= 0L || time <= 0) continue;
                long dayOfYear = this.daysFromZero % (long)time;
                double mfrac = (double)dayOfYear / (double)time;
                inc = moon.getInclination() * Math.PI / 180.0;
                ras = moon.getRightAscension() * Math.PI / 180.0 + frac;
                xTmp = Math.cos(mfrac *= Math.PI * 2) * (double)dist;
                yTmp = Math.sin(mfrac) * Math.cos(inc) * (double)dist;
                xCoord = newPt.getX() + xTmp * Math.cos(ras) - yTmp * Math.sin(ras);
                yCoord = newPt.getY() + yTmp * Math.cos(ras) + xTmp * Math.sin(ras);
                zCoord = newPt.getZ() + Math.sin(mfrac) * Math.sin(inc) * (double)dist;
                Point3D moonPt = new Point3D(xCoord, yCoord, zCoord);
                locs.put(moon, moonPt);
            }
        }
        return locs;
    }

    public void setDaysFromZero(long daysFromZero) {
        this.daysFromZero = daysFromZero;
    }

    public void setSystem(SolarSystem system) {
        this.system = system;
    }
}

