/*
 * Decompiled with CFR 0.152.
 */
package rpg.heroChar;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import rpg.heroChar.Power;

public class PowerPanel
extends Panel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -3476723990628089541L;
    Power power;
    Power savedPower;
    Label nameLabel;
    Label activeReal;
    Label stats;
    Vector mods = new Vector();
    Hashtable hash = new Hashtable();
    TextField otherAdLim = new TextField(16);
    TextField bonus = new TextField(6);
    List advList = new List(12, true);
    List limList = new List(12, true);

    public PowerPanel(Power editedPower, boolean isNew) {
        this.power = editedPower;
        if (isNew) {
            this.savedPower = (Power)this.power.clone();
        }
        this.setLayout(new BorderLayout());
        Panel titlePanel = new Panel(new GridLayout(0, 1));
        this.nameLabel = new Label(this.power.getName());
        this.activeReal = new Label("");
        titlePanel.add(this.nameLabel);
        titlePanel.add(this.activeReal);
        this.add((Component)titlePanel, "North");
        new Panel(new GridLayout(0, 1));
        new Panel(new GridLayout(0, 1));
        Panel ioPanel = new Panel(new BorderLayout());
        Panel descPanel = new Panel(new GridLayout(1, 2));
        this.add((Component)ioPanel, "Center");
        ioPanel.add((Component)descPanel, "Center");
        Panel varPanel = new Panel(new GridLayout(0, 4));
        ioPanel.add((Component)varPanel, "North");
        String[] theVars = this.power.getVariables();
        int i = 0;
        while (i < theVars.length) {
            TextField varText = new TextField(6);
            varPanel.add(varText);
            varPanel.add(new Label(theVars[i]));
            varText.setText(this.power.getVar(theVars[i]));
            varText.addActionListener(this);
            this.hash.put(varText, theVars[i]);
            if (i == 0) {
                varPanel.add(new Label("Special Effect:"));
                TextField specText = new TextField(10);
                varPanel.add(specText);
                specText.addActionListener(this);
                this.hash.put(specText, new String("Special Effect:"));
            } else {
                varPanel.add(new Label(""));
                varPanel.add(new Label(""));
            }
            ++i;
        }
        String[] theAds = this.power.getUsableAdvantages();
        Vector currentAds = this.power.getAdvantages();
        descPanel.add(this.advList);
        this.advList.addItemListener(this);
        int i2 = 0;
        while (i2 < theAds.length) {
            this.advList.add(theAds[i2]);
            if (currentAds.contains(theAds[i2])) {
                this.advList.select(i2);
            }
            ++i2;
        }
        String[] theLims = this.power.getUsableLimitations();
        Vector currentLims = this.power.getLimitations();
        descPanel.add(this.limList);
        this.limList.addItemListener(this);
        int i3 = 0;
        while (i3 < theLims.length) {
            this.limList.add(theLims[i3]);
            if (currentLims.contains(theLims[i3])) {
                this.limList.select(i3);
            }
            ++i3;
        }
        Panel added = new Panel(new GridLayout(2, 2));
        Panel smallPanel = new Panel();
        smallPanel.add(this.bonus);
        Button addButn = new Button("Add");
        addButn.addActionListener(this);
        smallPanel.add(addButn);
        added.add(new Label("Other Advantage/Limitation:"));
        added.add(this.otherAdLim);
        added.add(new Label("+/- Modifier:"));
        added.add(smallPanel);
        this.hash.put(this.otherAdLim, "Other");
        this.hash.put(this.bonus, "+/-");
        ioPanel.add((Component)added, "South");
        Button saveButn = new Button("Save");
        Button resetButn = new Button("Reset");
        Button closeButn = new Button("Close");
        Panel butnPanel = new Panel();
        butnPanel.add(saveButn);
        butnPanel.add(resetButn);
        butnPanel.add(closeButn);
        saveButn.addActionListener(this);
        resetButn.addActionListener(this);
        closeButn.addActionListener(this);
        this.add((Component)butnPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof TextField) {
            String varName = (String)this.hash.get(src);
            if (varName.equals("Special Effect:")) {
                this.power.setSpecialEffect(((TextField)src).getText());
            } else {
                this.power.setVar(varName, ((TextField)src).getText());
            }
        } else if (src instanceof Button) {
            String action = ((Button)src).getLabel();
            if (action.equals("Save")) {
                this.savedPower = (Power)this.power.clone();
            } else if (action.equals("Reset")) {
                this.revert();
            } else if (action.equals("Close")) {
                Container c;
                if (this.savedPower == null) {
                    this.power = null;
                }
                if ((c = this.getParent()) instanceof Dialog) {
                    ((Dialog)c).dispose();
                }
            } else if (action.equals("Add")) {
                String mod = this.otherAdLim.getText().trim();
                String val = this.bonus.getText().trim();
                if (val.startsWith("+") || val.startsWith("-")) {
                    int div = val.indexOf(47);
                    String newMod = String.valueOf(mod) + "  " + val;
                    if (val.startsWith("+")) {
                        this.power.setAdvantage(newMod, true);
                        this.advList.add(newMod);
                        this.advList.select(this.advList.getItemCount() - 1);
                    } else if (val.startsWith("-")) {
                        this.power.setLimitation(newMod, true);
                        this.limList.add(newMod);
                        this.limList.select(this.limList.getItemCount() - 1);
                    }
                }
            }
        }
        this.nameLabel.setText(this.power.getName());
        this.activeReal.setText("Active: " + this.power.getActive() + "   Real: " + this.power.getCost() + "   END: " + this.power.getEnd());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src instanceof Checkbox) {
            String mod = ((Checkbox)src).getLabel();
            if (mod.indexOf("  +") != -1) {
                this.power.setAdvantage(mod, ((Checkbox)src).getState());
            } else if (mod.indexOf("  -") != -1) {
                this.power.setLimitation(mod, ((Checkbox)src).getState());
            }
        } else if (src instanceof List) {
            boolean on;
            List list = (List)src;
            int item = (Integer)e.getItem();
            String mod = list.getItem(item);
            boolean bl = on = e.getStateChange() == 1;
            if (mod.indexOf("  +") != -1) {
                this.power.setAdvantage(mod, on);
            } else if (mod.indexOf("  -") != -1) {
                this.power.setLimitation(mod, on);
            }
        }
        this.nameLabel.setText(this.power.getName());
        this.activeReal.setText("Active: " + this.power.getActive() + "   Real: " + this.power.getCost() + "   END: " + this.power.getEnd());
    }

    public void revert() {
    }
}

