/*
 * Decompiled with CFR 0.152.
 */
package rpg.heroChar;

import java.util.Enumeration;
import java.util.Vector;
import rpg.heroChar.Framework;

public abstract class Power {
    String name;
    int cost;
    int active;
    int endUsed;
    Vector advant = new Vector();
    Vector limits = new Vector();
    String specEffect;
    boolean framework = false;
    Framework inFramework = null;

    public Power(String powerName) {
        this.name = powerName;
    }

    public int applyLims(int modActive) {
        this.cost = modActive;
        float mult = 1.0f;
        Enumeration e = this.limits.elements();
        while (e.hasMoreElements()) {
            int inx;
            String mod = (String)e.nextElement();
            int div = mod.indexOf(47, inx = mod.indexOf(45) + 1);
            if (div < 0) {
                mult += (float)Integer.parseInt(mod.substring(inx));
                continue;
            }
            mult += Float.parseFloat(mod.substring(inx, div)) / Float.parseFloat(mod.substring(div + 1));
        }
        float tmp = (float)this.cost / mult - 0.01f;
        this.cost = Math.round(tmp);
        return this.cost;
    }

    public abstract int calcBaseCost();

    public int calculateCost() {
        this.cost = this.getActivePoints();
        float mult = 1.0f;
        Enumeration e = this.limits.elements();
        while (e.hasMoreElements()) {
            int inx;
            String mod = (String)e.nextElement();
            int div = mod.indexOf(47, inx = mod.indexOf(45) + 1);
            if (div < 0) {
                mult += (float)Integer.parseInt(mod.substring(inx));
                continue;
            }
            mult += Float.parseFloat(mod.substring(inx, div)) / Float.parseFloat(mod.substring(div + 1));
        }
        float tmp = (float)this.cost / mult - 0.01f;
        this.cost = Math.round(tmp);
        return this.cost;
    }

    public int calculateEnd() {
        this.endUsed = Math.round(this.cost / 10);
        return this.endUsed;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Clone bad");
            return null;
        }
    }

    public int getActive() {
        return this.active;
    }

    public int getActivePoints() {
        this.active = this.calcBaseCost();
        float mult = 1.0f;
        Enumeration e = this.advant.elements();
        while (e.hasMoreElements()) {
            int inx;
            String mod = (String)e.nextElement();
            int div = mod.indexOf(47, inx = mod.indexOf(43) + 1);
            if (div < 0) {
                mult += (float)Integer.parseInt(mod.substring(inx));
                continue;
            }
            mult += Float.parseFloat(mod.substring(inx, div)) / Float.parseFloat(mod.substring(div + 1));
        }
        float tmp = (float)this.active * mult - 0.01f;
        this.active = Math.round(tmp);
        return this.active;
    }

    public Vector getAdvantages() {
        return this.advant;
    }

    public int getCost() {
        return this.cost;
    }

    public int getEnd() {
        return this.endUsed;
    }

    public Framework getFramework() {
        return this.inFramework;
    }

    abstract String getLabel();

    public Vector getLimitations() {
        return this.limits;
    }

    public String getModList() {
        int indx;
        StringBuffer sbuf = new StringBuffer();
        Enumeration e = this.advant.elements();
        while (e.hasMoreElements()) {
            String adv = (String)e.nextElement();
            indx = adv.indexOf("  ");
            sbuf.append(", " + adv.substring(0, indx));
        }
        e = this.limits.elements();
        while (e.hasMoreElements()) {
            String lim = (String)e.nextElement();
            indx = lim.indexOf("  ");
            sbuf.append(", " + lim.substring(0, indx));
        }
        return sbuf.toString();
    }

    public String getName() {
        return this.name;
    }

    public Power[] getPowers() {
        return null;
    }

    public abstract String[] getUsableAdvantages();

    public abstract String[] getUsableLimitations();

    public String getVar(String varName) {
        return "";
    }

    public String[] getVariables() {
        return null;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public boolean isInFramework() {
        return this.inFramework != null;
    }

    public boolean isValidAdvantage(String adv) {
        String[] advs;
        String[] stringArray = advs = this.getUsableAdvantages();
        int n = advs.length;
        int n2 = 0;
        while (n2 < n) {
            String adv2 = stringArray[n2];
            if (adv.equals(adv2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidLimitation(String lim) {
        String[] lims;
        String[] stringArray = lims = this.getUsableLimitations();
        int n = lims.length;
        int n2 = 0;
        while (n2 < n) {
            String lim2 = stringArray[n2];
            if (lim.equals(lim2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void modifyCost(int newCost) {
        this.cost = newCost;
    }

    public String rename() {
        this.name = String.valueOf(this.getLabel()) + (this.specEffect != null ? " (" + this.specEffect + ")" : " ") + this.getModList();
        return this.name;
    }

    public void setAdvantage(String adv, boolean add) {
        if (add && !this.advant.contains(adv)) {
            this.advant.addElement(adv);
        } else if (!add) {
            this.advant.removeElement(adv);
        }
        this.calculateCost();
        this.calculateEnd();
        if (this.inFramework != null && !this.inFramework.revalidatePower(this)) {
            this.inFramework = null;
        }
        this.rename();
    }

    public void setFramework(Framework in) {
        this.inFramework = in;
    }

    public void setLimitation(String lim, boolean add) {
        if (add && !this.limits.contains(lim)) {
            this.limits.addElement(lim);
        } else if (!add) {
            this.limits.removeElement(lim);
        }
        this.calculateCost();
        this.calculateEnd();
        if (this.inFramework != null && !this.inFramework.revalidatePower(this)) {
            this.inFramework = null;
        }
        this.rename();
    }

    public void setSpecialEffect(String effect) {
        this.specEffect = effect.length() > 0 ? effect : null;
        this.rename();
    }

    public abstract void setVar(String var1, String var2);

    public String toString() {
        return this.cost + "  " + this.name;
    }
}

