/*
 * Decompiled with CFR 0.152.
 */
package rpg.heroChar;

import java.util.Enumeration;
import java.util.Vector;
import rpg.heroChar.Framework;
import rpg.heroChar.Power;

public class MultiPower
extends Power
implements Framework {
    Vector multis = new Vector();
    Vector ultras = new Vector();
    int points;

    public MultiPower() {
        super("# point MultiPower");
        this.framework = true;
    }

    @Override
    public boolean addToFramework(Power power, boolean isUltra) {
        if (power.getActivePoints() <= this.active && !power.isFramework()) {
            Vector newVec = (Vector)this.limits.clone();
            Enumeration e = newVec.elements();
            while (e.hasMoreElements()) {
                String thisLim = (String)e.nextElement();
                if (power.isValidLimitation(thisLim)) {
                    power.setLimitation(thisLim, true);
                    continue;
                }
                this.limits.removeElement(thisLim);
            }
            int powerCost = power.calculateCost();
            if (isUltra) {
                this.ultras.addElement(power);
                power.modifyCost(Math.round(((float)powerCost - 0.01f) / 10.0f));
            } else {
                this.multis.addElement(power);
                power.modifyCost(Math.round((float)powerCost / 5.0f));
            }
            this.calculateCost();
            this.calculateEnd();
            this.rename();
            return true;
        }
        return false;
    }

    @Override
    public int calcBaseCost() {
        return this.points;
    }

    @Override
    public int calculateEnd() {
        return 0;
    }

    @Override
    String getLabel() {
        if (this.points > 0) {
            return this.points + " point MultiPower";
        }
        return "# point MultiPower";
    }

    @Override
    public Power[] getPowers() {
        Power[] powerList = new Power[this.multis.size() + this.ultras.size()];
        int index = 0;
        Enumeration e = this.multis.elements();
        while (e.hasMoreElements()) {
            powerList[index++] = (Power)e.nextElement();
        }
        e = this.ultras.elements();
        while (e.hasMoreElements()) {
            powerList[index++] = (Power)e.nextElement();
        }
        return powerList;
    }

    @Override
    public String[] getUsableAdvantages() {
        String[] adv = new String[]{};
        return adv;
    }

    @Override
    public String[] getUsableLimitations() {
        String[] adv = new String[]{"No Range  -1/2", "4 Charges  -1"};
        return adv;
    }

    @Override
    public String getVar(String varName) {
        return "" + this.points;
    }

    @Override
    public String[] getVariables() {
        String[] params = new String[]{"Points"};
        return params;
    }

    @Override
    public boolean revalidatePower(Power power) {
        if (this.multis.contains(power)) {
            this.multis.removeElement(power);
            return this.addToFramework(power, false);
        }
        if (this.ultras.contains(power)) {
            this.ultras.removeElement(power);
            return this.addToFramework(power, true);
        }
        return false;
    }

    @Override
    public void setVar(String varName, String value) {
        this.points = Integer.parseInt(value);
        this.calculateCost();
        this.calculateEnd();
        this.rename();
    }
}

