/*
 * Decompiled with CFR 0.152.
 */
package rpg.heroChar;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import rpg.heroChar.Armor;
import rpg.heroChar.ElemControl;
import rpg.heroChar.EnergyBlast;
import rpg.heroChar.Framework;
import rpg.heroChar.HeroChar;
import rpg.heroChar.HeroStats;
import rpg.heroChar.MultiPower;
import rpg.heroChar.Power;
import rpg.heroChar.PowerPanel;
import rpg.heroChar.RKA;
import rpg.heroChar.Skill;

public class HeroView
extends Frame
implements ActionListener {
    private static final long serialVersionUID = -4582615619799019018L;
    HeroChar character;
    TextField[] entries = new TextField[20];
    Label[] costs = new Label[30];
    Choice powerChoice = new Choice();
    Choice skillChoice = new Choice();
    Choice frameChoice = new Choice();
    int powerIndex = -1;
    Panel stats;
    List abilityList = new List(15);
    List disadList = new List(15);

    public HeroView() {
        this.setFont(new Font("TimesRoman", 0, 10));
        this.setLayout(new FlowLayout());
        this.character = new HeroChar();
        this.entries[0] = new TextField(20);
        this.entries[1] = new TextField(20);
        this.stats = this.makeStatPanel();
        Panel abilities = this.makeAbilityPanel();
        Panel disads = this.makeDisadPanel();
        this.add(this.stats);
        this.add(abilities);
        this.add(disads);
        this.updateStats(this.character.getStats());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof TextField) {
            if (src.equals(this.entries[2])) {
                this.character.getStats().setStr(Integer.parseInt(this.entries[2].getText()));
            } else if (src.equals(this.entries[3])) {
                this.character.getStats().setDex(Integer.parseInt(this.entries[3].getText()));
            } else if (src.equals(this.entries[4])) {
                this.character.getStats().setCon(Integer.parseInt(this.entries[4].getText()));
            } else if (src.equals(this.entries[5])) {
                this.character.getStats().setBdy(Integer.parseInt(this.entries[5].getText()));
            } else if (src.equals(this.entries[6])) {
                this.character.getStats().setInt(Integer.parseInt(this.entries[6].getText()));
            } else if (src.equals(this.entries[7])) {
                this.character.getStats().setEgo(Integer.parseInt(this.entries[7].getText()));
            } else if (src.equals(this.entries[8])) {
                this.character.getStats().setPre(Integer.parseInt(this.entries[8].getText()));
            } else if (src.equals(this.entries[9])) {
                this.character.getStats().setCom(Integer.parseInt(this.entries[9].getText()));
            } else if (src.equals(this.entries[10])) {
                this.character.getStats().setPD(Integer.parseInt(this.entries[10].getText()));
            } else if (src.equals(this.entries[11])) {
                this.character.getStats().setED(Integer.parseInt(this.entries[11].getText()));
            } else if (src.equals(this.entries[12])) {
                this.character.getStats().setSpd(Float.parseFloat(this.entries[12].getText()));
            } else if (src.equals(this.entries[13])) {
                this.character.getStats().setRec(Integer.parseInt(this.entries[13].getText()));
            } else if (src.equals(this.entries[14])) {
                this.character.getStats().setEnd(Integer.parseInt(this.entries[14].getText()));
            } else if (src.equals(this.entries[15])) {
                this.character.getStats().setStn(Integer.parseInt(this.entries[15].getText()));
            }
            this.updateStats(this.character.getStats());
        } else if (src instanceof Button) {
            int skillIndex;
            String label = ((Button)src).getLabel();
            if (label.equals("Add Power")) {
                String power = this.powerChoice.getSelectedItem();
                this.addPower(power);
            } else if (label.equals("Edit Power")) {
                int powerIndex = this.abilityList.getSelectedIndex();
                if (powerIndex > -1 && powerIndex < this.character.getPowerCount()) {
                    Power power = this.character.getPower(powerIndex);
                    PowerPanel pp = new PowerPanel(power, false);
                    Dialog holder = new Dialog((Frame)this, true);
                    holder.add(pp);
                    holder.pack();
                    holder.show();
                }
            } else if (label.equals("Remove")) {
                int powerIndex = this.abilityList.getSelectedIndex();
                if (powerIndex > -1 && powerIndex < this.character.getPowerCount()) {
                    this.character.removePowerAt(powerIndex);
                }
            } else if (label.equals("Add to Framework")) {
                String framework = this.frameChoice.getSelectedItem();
                int powerIndex = this.abilityList.getSelectedIndex();
                if (powerIndex > -1 && powerIndex < this.character.getPowerCount()) {
                    Power power = this.character.getPower(powerIndex);
                    int i = 0;
                    while (i < this.character.getPowerCount()) {
                        Power p = this.character.getPower(i);
                        if (framework.startsWith(p.getName())) {
                            Framework frm = (Framework)((Object)p);
                            if (frm.addToFramework(power, framework.indexOf("as Ultra") != -1)) {
                                this.character.removePowerAt(powerIndex);
                                power.setFramework(frm);
                                if (powerIndex < i) {
                                    this.character.insertPowerAt(power, i);
                                } else {
                                    this.character.insertPowerAt(power, i + 1);
                                }
                            }
                            i = this.character.getPowerCount();
                        }
                        ++i;
                    }
                }
            } else if (label.equals("Add Skill")) {
                String skill = this.skillChoice.getSelectedItem();
                this.addSkill(skill);
            } else if (label.equals("Increase Skill")) {
                int skillIndex2 = this.abilityList.getSelectedIndex() - this.character.getPowerCount();
                if (skillIndex2 >= 0) {
                    Skill skill = this.character.getSkill(skillIndex2);
                    skill.increase();
                }
            } else if (label.equals("Decrease Skill") && (skillIndex = this.abilityList.getSelectedIndex() - this.character.getPowerCount()) >= 0) {
                Skill skill = this.character.getSkill(skillIndex);
                skill.decrease();
            }
            this.updateAbilities();
        }
    }

    public void addPower(String power) {
        Power newPower = power.equals("Armor") ? new Armor() : (power.equals("Energy Blast") ? new EnergyBlast() : (power.equals("Ranged Killing Attack") ? new RKA() : (power.equals("Elemental Control") ? new ElemControl() : (power.equals("MultiPower") ? new MultiPower() : new Armor()))));
        PowerPanel pp = new PowerPanel(newPower, true);
        Dialog holder = new Dialog((Frame)this, true);
        holder.add(pp);
        holder.pack();
        holder.show();
        if (newPower != null) {
            this.character.addPower(newPower);
        }
    }

    public void addSkill(String skill) {
        Skill newSkill = new Skill(skill);
        this.character.addSkill(newSkill);
    }

    public void getPowerParams(Power power) {
        this.costs[20].setText("Parameters for " + power.getName());
        String[] vars = power.getVariables();
        if (vars != null) {
            int i = 0;
            while (i < vars.length) {
                this.costs[i + 16].setText(vars[i]);
                ++i;
            }
        }
    }

    public Panel makeAbilityPanel() {
        Panel p = new Panel(new BorderLayout());
        p.add((Component)this.abilityList, "Center");
        this.abilityList.add("");
        Panel control = new Panel(new GridLayout(0, 2));
        this.powerChoice.add("");
        this.powerChoice.add("Armor");
        this.powerChoice.add("Energy Blast");
        this.powerChoice.add("Entangle");
        this.powerChoice.add("Flash");
        this.powerChoice.add("Flight");
        this.powerChoice.add("Force Field");
        this.powerChoice.add("Growth");
        this.powerChoice.add("Invisibility");
        this.powerChoice.add("Ranged Killing Attack");
        this.powerChoice.add("Transfer");
        this.powerChoice.add("Tunnelling");
        this.powerChoice.add("Elemental Control");
        this.powerChoice.add("MultiPower");
        this.powerChoice.add("Power Pool");
        Button powerButn = new Button("Add Power");
        powerButn.addActionListener(this);
        this.skillChoice.add("");
        this.skillChoice.add("Breakfall  (Dex)");
        this.skillChoice.add("Science: Chemistry  (Int)");
        Button skillButn = new Button("Add Skill");
        skillButn.addActionListener(this);
        Button incrButn = new Button("Increase Skill");
        incrButn.addActionListener(this);
        Button decrButn = new Button("Decrease Skill");
        decrButn.addActionListener(this);
        Button frameButn = new Button("Add to Framework");
        frameButn.addActionListener(this);
        Button editButn = new Button("Edit Power");
        editButn.addActionListener(this);
        Button remButn = new Button("Remove");
        remButn.addActionListener(this);
        control.add(this.powerChoice);
        control.add(powerButn);
        control.add(this.skillChoice);
        control.add(skillButn);
        control.add(this.frameChoice);
        control.add(frameButn);
        control.add(incrButn);
        control.add(decrButn);
        control.add(editButn);
        control.add(remButn);
        p.add((Component)control, "South");
        return p;
    }

    public Panel makeDisadPanel() {
        Panel p = new Panel(new BorderLayout());
        p.add((Component)this.disadList, "Center");
        return p;
    }

    public Panel makeStatPanel() {
        Panel p = new Panel(new GridLayout(14, 3, 0, 1));
        int i = 2;
        while (i < 16) {
            this.entries[i] = new TextField(3);
            this.entries[i].addActionListener(this);
            this.costs[i] = new Label();
            ++i;
        }
        p.add(this.entries[2]);
        p.add(new Label("Str"));
        p.add(this.costs[2]);
        p.add(this.entries[3]);
        p.add(new Label("Dex"));
        p.add(this.costs[3]);
        p.add(this.entries[4]);
        p.add(new Label("Con"));
        p.add(this.costs[4]);
        p.add(this.entries[5]);
        p.add(new Label("Bdy"));
        p.add(this.costs[5]);
        p.add(this.entries[6]);
        p.add(new Label("Int"));
        p.add(this.costs[6]);
        p.add(this.entries[7]);
        p.add(new Label("Ego"));
        p.add(this.costs[7]);
        p.add(this.entries[8]);
        p.add(new Label("Pre"));
        p.add(this.costs[8]);
        p.add(this.entries[9]);
        p.add(new Label("Com"));
        p.add(this.costs[9]);
        p.add(this.entries[10]);
        p.add(new Label("PD"));
        p.add(this.costs[10]);
        p.add(this.entries[11]);
        p.add(new Label("ED"));
        p.add(this.costs[11]);
        p.add(this.entries[12]);
        p.add(new Label("Spd"));
        p.add(this.costs[12]);
        p.add(this.entries[13]);
        p.add(new Label("Rec"));
        p.add(this.costs[13]);
        p.add(this.entries[14]);
        p.add(new Label("End"));
        p.add(this.costs[14]);
        p.add(this.entries[15]);
        p.add(new Label("Stn"));
        p.add(this.costs[15]);
        return p;
    }

    public void updateAbilities() {
        Skill sk;
        Power p;
        this.abilityList.removeAll();
        this.frameChoice.removeAll();
        int index = 0;
        while ((p = this.character.getPower(index)) != null) {
            int cost = p.getCost();
            if (p.isInFramework()) {
                this.abilityList.add("  " + cost + "   " + p.getName());
            } else {
                this.abilityList.add(cost + "   " + p.getName());
            }
            ++index;
            if (!p.isFramework()) continue;
            if (p instanceof MultiPower) {
                this.frameChoice.add(String.valueOf(p.getName()) + "  as Multi");
                this.frameChoice.add(String.valueOf(p.getName()) + "  as Ultra");
                continue;
            }
            this.frameChoice.add(p.getName());
        }
        index = 0;
        while ((sk = this.character.getSkill(index)) != null) {
            int roll = sk.calcRoll(this.character.getStats());
            int cost = sk.getCost();
            this.abilityList.add(cost + "   " + sk.getName() + "   " + roll + "-");
            ++index;
        }
        this.pack();
        this.show();
    }

    public void updateDisads() {
    }

    public void updateStats(HeroStats stats) {
        this.entries[2].setText("" + stats.Str);
        this.costs[2].setText("" + stats.StrCost);
        this.entries[3].setText("" + stats.Dex);
        this.costs[3].setText("" + stats.DexCost);
        this.entries[4].setText("" + stats.Con);
        this.costs[4].setText("" + stats.ConCost);
        this.entries[5].setText("" + stats.Bdy);
        this.costs[5].setText("" + stats.BdyCost);
        this.entries[6].setText("" + stats.Int);
        this.costs[6].setText("" + stats.IntCost);
        this.entries[7].setText("" + stats.Ego);
        this.costs[7].setText("" + stats.EgoCost);
        this.entries[8].setText("" + stats.Pre);
        this.costs[8].setText("" + stats.PreCost);
        this.entries[9].setText("" + stats.Com);
        this.costs[9].setText("" + stats.ComCost);
        this.entries[10].setText("" + stats.PD);
        this.costs[10].setText("" + stats.PDCost);
        this.entries[11].setText("" + stats.ED);
        this.costs[11].setText("" + stats.EDCost);
        this.entries[12].setText("" + stats.Spd);
        this.costs[12].setText("" + stats.SpdCost);
        this.entries[13].setText("" + stats.Rec);
        this.costs[13].setText("" + stats.RecCost);
        this.entries[14].setText("" + stats.End);
        this.costs[14].setText("" + stats.EndCost);
        this.entries[15].setText("" + stats.Stn);
        this.costs[15].setText("" + stats.StnCost);
        this.updateAbilities();
    }

    public static void main(String[] args) {
        HeroView hc = new HeroView();
        hc.pack();
        hc.show();
    }
}

