/*
 * Decompiled with CFR 0.152.
 */
package rpg.heroChar;

import rpg.heroChar.Power;

public class EnergyBlast
extends Power {
    int dice;

    public EnergyBlast() {
        super("#D6 Energy Blast");
    }

    public EnergyBlast(int num) {
        super(num + "D6 Energy Blast");
        this.dice = num;
    }

    @Override
    public int calcBaseCost() {
        return this.dice * 5;
    }

    @Override
    String getLabel() {
        if (this.dice > 0) {
            return this.dice + " D6 Energy Blast";
        }
        return "#D6 Energy Blast";
    }

    @Override
    public String[] getUsableAdvantages() {
        String[] adv = new String[]{"Area Effect: Hex  +1", "Area Effect: Line  +1", "Continuous  +1", "Reduced Endurance: 1/2 END  +1/2", "Reduced Endurance: 0 END  +1"};
        return adv;
    }

    @Override
    public String[] getUsableLimitations() {
        String[] adv = new String[]{"No Range  -1/2", "4 Charges  -1"};
        return adv;
    }

    @Override
    public String getVar(String varName) {
        return "" + this.dice;
    }

    @Override
    public String[] getVariables() {
        String[] params = new String[]{"Dice"};
        return params;
    }

    @Override
    public void setVar(String varName, String value) {
        this.dice = Integer.parseInt(value);
        this.calculateCost();
        this.calculateEnd();
        this.rename();
    }
}

