/*
 * Decompiled with CFR 0.152.
 */
package rpg.heroChar;

import java.util.Enumeration;
import java.util.Vector;
import rpg.heroChar.Framework;
import rpg.heroChar.Power;

public class ElemControl
extends Power
implements Framework {
    Vector powers = new Vector();
    int points;

    public ElemControl() {
        super("Elemental Control");
        this.framework = true;
    }

    @Override
    public boolean addToFramework(Power power, boolean dummy) {
        if (power.getActivePoints() >= this.points * 2 && !power.isFramework()) {
            Vector newVec = (Vector)this.limits.clone();
            Enumeration e = newVec.elements();
            while (e.hasMoreElements()) {
                String thisLim = (String)e.nextElement();
                if (power.isValidLimitation(thisLim)) {
                    power.setLimitation(thisLim, true);
                    continue;
                }
                this.limits.removeElement(thisLim);
            }
            power.applyLims(power.getActivePoints() - this.active);
            this.powers.addElement(power);
            this.calculateCost();
            this.calculateEnd();
            this.rename();
            return true;
        }
        return false;
    }

    @Override
    public int calcBaseCost() {
        return this.points;
    }

    @Override
    public int calculateEnd() {
        return 0;
    }

    @Override
    String getLabel() {
        return "Elemental Control";
    }

    @Override
    public Power[] getPowers() {
        Power[] powerList = new Power[this.powers.size()];
        int index = 0;
        Enumeration e = this.powers.elements();
        while (e.hasMoreElements()) {
            powerList[index++] = (Power)e.nextElement();
        }
        return powerList;
    }

    @Override
    public String[] getUsableAdvantages() {
        String[] adv = new String[]{};
        return adv;
    }

    @Override
    public String[] getUsableLimitations() {
        String[] adv = new String[]{"No Range  -1/2", "4 Charges  -1"};
        return adv;
    }

    @Override
    public String getVar(String varName) {
        return "" + this.points;
    }

    @Override
    public String[] getVariables() {
        String[] params = new String[]{"Points"};
        return params;
    }

    @Override
    public boolean revalidatePower(Power power) {
        if (this.powers.contains(power)) {
            this.powers.removeElement(power);
            return this.addToFramework(power, false);
        }
        return false;
    }

    @Override
    public void setVar(String varName, String value) {
        this.points = Integer.parseInt(value);
        this.calculateCost();
        this.calculateEnd();
        this.rename();
    }
}

