/*
 * Decompiled with CFR 0.152.
 */
package rpg.d20char;

import java.util.Random;

public class DiceRoll {
    int numDice;
    int diceSides;
    int rollMod;
    int value;

    public DiceRoll() {
        this(1, 6, 0);
    }

    public DiceRoll(int sides) {
        this(1, sides, 0);
    }

    public DiceRoll(int num, int sides) {
        this(num, sides, 0);
    }

    public DiceRoll(int num, int sides, int mod) {
        this.numDice = num;
        this.diceSides = sides;
        this.rollMod = mod;
        this.roll();
    }

    public int getAverage() {
        int average = this.numDice * this.diceSides + this.numDice;
        if (this.numDice % 2 == 1) {
            ++average;
        }
        average /= 2;
        return average += this.rollMod;
    }

    public int getDieType() {
        return this.diceSides;
    }

    public int getNumDice() {
        return this.numDice;
    }

    public int getRollMod() {
        return this.rollMod;
    }

    public int getValue() {
        return this.value;
    }

    public int roll() {
        Random rand = new Random();
        this.value = this.rollMod;
        int i = 0;
        while (i < this.numDice) {
            this.value += Math.abs(rand.nextInt() % this.diceSides) + 1;
            ++i;
        }
        return this.value;
    }

    public void setDieType(int die) {
        this.diceSides = die;
    }

    public void setNumDice(int num) {
        this.numDice = num;
    }

    public void setRollMod(int mod) {
        this.rollMod = mod;
    }

    public String toString() {
        if (this.rollMod < 0) {
            return this.numDice + "d" + this.diceSides + this.rollMod;
        }
        if (this.rollMod == 0) {
            return this.numDice + "d" + this.diceSides;
        }
        return this.numDice + "d" + this.diceSides + "+" + this.rollMod;
    }

    public static void main(String[] args) {
        int Dindex = args[0].indexOf("d");
        if (Dindex == -1) {
            Dindex = args[0].indexOf("D");
        }
        int num = Integer.parseInt(args[0].substring(0, Dindex));
        int dice = Integer.parseInt(args[0].substring(Dindex + 1));
        DiceRoll dr = new DiceRoll(num, dice);
        System.out.println(dr.getValue());
    }
}

