/*
 * Decompiled with CFR 0.152.
 */
package rpg.d20char;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import rpg.d20char.D20Class;
import rpg.d20char.DiceRoll;
import rpg.d20char.Modifier;

public class D20Race
implements Serializable {
    private static final long serialVersionUID = -9097249857498983387L;
    private String raceName;
    private String preferredClass;
    private Map<Object, Integer> mods = new HashMap<Object, Integer>();
    private DiceRoll age;
    private DiceRoll height;
    private DiceRoll weight;

    public D20Race(String name) {
        this.raceName = new String(name);
    }

    public int checkClasses(Map<D20Class, Integer> classes, int exp) {
        int modExp = exp;
        if (classes.size() != 1 && (classes.size() != 2 || this.preferredClass != null && !classes.containsKey(this.preferredClass))) {
            int i;
            int[] levels = new int[6];
            int classCount = 0;
            for (D20Class charClass : classes.keySet()) {
                if (charClass.isPrestige() || this.preferredClass != null && this.preferredClass.equals(charClass.getName())) continue;
                levels[classCount++] = classes.get(charClass);
            }
            int max = 0;
            int min = 1000;
            if (this.preferredClass == null) {
                i = 0;
                while (i < classCount) {
                    if (levels[i] > max) {
                        int tmp = max;
                        max = levels[i];
                        levels[i] = tmp;
                    }
                    if (i > 0) {
                        levels[i - 1] = levels[i];
                    }
                    ++i;
                }
                --classCount;
            }
            max = 0;
            i = 0;
            while (i < classCount) {
                if (levels[i] > max) {
                    max = levels[i];
                }
                if (levels[i] < min) {
                    min = levels[i];
                }
                ++i;
            }
            if (max - min > 1) {
                modExp = (int)(0.8 * (double)exp);
            }
        }
        return modExp;
    }

    public int getAge() {
        return this.age.getValue();
    }

    public int getHeight() {
        return this.height.getValue();
    }

    public HashSet<Modifier> getModifiers() {
        return new HashSet<Modifier>();
    }

    public String getName() {
        return this.raceName;
    }

    public HashSet<String> getSpecials() {
        return new HashSet<String>();
    }

    public int getWeight() {
        return this.weight.getValue();
    }

    public void setAgeParam(int numdice, int dice, int base) {
        this.age = new DiceRoll(numdice, dice, base);
    }

    public void setHeightParam(int numdice, int dice, int base) {
        this.height = new DiceRoll(numdice, dice, base);
    }

    public void setPreferredClass(String pref) {
        this.preferredClass = pref;
    }

    public void setWeightParam(int numdice, int dice, int base) {
        this.weight = new DiceRoll(numdice, dice, base);
    }
}

