/*
 * Decompiled with CFR 0.152.
 */
package rpg.d20char;

import java.util.HashSet;
import rpg.d20char.Attack;
import rpg.d20char.BaseStat;
import rpg.d20char.D20Char;

public abstract class D20Monster
extends D20Char {
    HashSet<Attack> secondAttacks = new HashSet();
    private Attack primaryAtt;

    public void calcAttacks() {
        int baseAttack = this.getToHit();
        int strBonus = this.getStatMod(BaseStat.STR);
        int sizeMod = this.getSize().getBonus();
        int dmgBonus = this.secondAttacks.isEmpty() ? (int)((double)strBonus * 1.5) : strBonus;
        this.primaryAtt.setMods(baseAttack + strBonus + sizeMod, dmgBonus);
        dmgBonus = strBonus / 2;
        int secAttack = baseAttack + strBonus + sizeMod - 5;
        for (Attack attack : this.secondAttacks) {
            attack.setMods(secAttack, dmgBonus);
        }
    }

    public abstract void calcSaves();

    public abstract int getSkillPoints();

    public abstract int getToHit();

    public void setName(String creatureName) {
    }
}

