/*
 * Decompiled with CFR 0.152.
 */
package rpg.d20char;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import rpg.d20char.D20Skill;
import rpg.d20char.SavingThrow;

public abstract class D20Class {
    private String name;
    private int dieType;
    private int maxAttack;
    private int skillPoints;
    private HashSet<D20Skill> classSkills = new HashSet();
    private TreeMap<String, Integer> specials = new TreeMap();
    private HashSet<SavingThrow> goodSaves = new HashSet();

    public D20Class(String className, int hitDie, int skillPointsPerLevel, int attackProgress) {
        this.name = className;
        this.dieType = hitDie;
        this.skillPoints = skillPointsPerLevel;
        this.maxAttack = attackProgress;
    }

    public int calcAttack(int level) {
        return level * this.maxAttack / 20;
    }

    public Set<D20Skill> getClassSkills() {
        return this.classSkills;
    }

    public int getDieType() {
        return this.dieType;
    }

    public String getName() {
        return this.name;
    }

    public int getSave(SavingThrow save, int level) {
        return this.goodSaves.contains((Object)save) ? 2 + level / 2 : level / 3;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public Set<String> getSpecials(int level) {
        HashSet<String> specs = new HashSet<String>();
        for (String spec : this.specials.keySet()) {
            int neededLevel = this.specials.get(spec);
            if (level < neededLevel) continue;
            specs.add(spec);
        }
        return specs;
    }

    public boolean isPrestige() {
        return false;
    }

    protected void setGoodSaves(boolean fort, boolean reflex, boolean will) {
    }
}

