/*
 * Decompiled with CFR 0.152.
 */
package rpg.d20char;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeMap;
import rpg.d20char.BaseStat;
import rpg.d20char.D20Class;
import rpg.d20char.D20Feat;
import rpg.d20char.D20Race;
import rpg.d20char.D20Skill;
import rpg.d20char.Modifier;
import rpg.d20char.SavingThrow;
import rpg.d20char.Size;

public class D20Char {
    private D20Race charRace;
    private HashMap<D20Class, Integer> charClass = new HashMap();
    private int xp;
    private int hp;
    private int level;
    private TreeMap<BaseStat, Integer> stats;
    private int[] saves = new int[3];
    private HashSet<D20Feat> feats = new HashSet();
    private HashMap<D20Skill, Integer> skills = new HashMap();
    private Size size = Size.MEDIUM;
    private HashSet<Modifier> allMods = new HashSet();
    private HashSet<String> specials = new HashSet();

    public boolean addExperience(int experience) {
        this.xp += this.charRace.checkClasses(this.charClass, experience);
        int jump = 1000 * this.level * (this.level + 1);
        return this.xp > jump;
    }

    public void addLevel(D20Class newClass) {
        ++this.level;
        if (this.level % 4 == 0) {
            this.addToStat();
        }
        if (this.level % 3 == 0) {
            this.addFeat();
        }
        this.addSkills(newClass);
        this.hp += new Random().nextInt(newClass.getDieType()) + this.stats.get((Object)BaseStat.CON) / 2 - 4;
        Integer level = this.charClass.get(newClass);
        if (level == null) {
            this.charClass.put(newClass, 1);
        } else {
            this.charClass.put(newClass, level + 1);
        }
        this.addSkills(newClass);
    }

    private void addFeat() {
    }

    private void addSkills(D20Class newClass) {
        newClass.getClassSkills();
        int points = newClass.getSkillPoints() + this.stats.get((Object)BaseStat.INT) / 2 - 5;
        if (this.level == 1) {
            points *= 4;
        }
    }

    public void addToStat() {
    }

    public int calcAC() {
        int dexBonus = this.getStatMod(BaseStat.DEX);
        int sizeMod = this.size.getBonus();
        int otherMod = this.getModifierTotal("AC");
        return 10 + dexBonus + sizeMod + otherMod;
    }

    public HashMap<D20Skill, Integer> calcSkills() {
        HashMap<D20Skill, Integer> skillVals = new HashMap<D20Skill, Integer>();
        for (D20Skill skill : this.skills.keySet()) {
            int total = this.skills.get(skill);
            total += this.getStatMod(skill.getStat());
            for (Modifier mod : this.allMods) {
                if (!mod.getModified().equals(skill)) continue;
                total += mod.getValue();
            }
            skillVals.put(skill, total);
        }
        return skillVals;
    }

    public void firstLevel(D20Class newClass) {
        this.level = 1;
        this.addSkills(newClass);
        this.hp = newClass.getDieType() + this.getStatMod(BaseStat.CON);
        this.saves[0] = newClass.getSave(SavingThrow.FORT, 1) + this.getStatMod(BaseStat.CON);
        this.saves[1] = newClass.getSave(SavingThrow.REFL, 1) + this.getStatMod(BaseStat.DEX);
        this.saves[2] = newClass.getSave(SavingThrow.WILL, 1) + this.getStatMod(BaseStat.WIS);
    }

    protected int getClassLevel(D20Class cls) {
        Integer lvl = this.charClass.get(cls);
        return lvl == null ? 0 : lvl;
    }

    private int getModifierTotal(Object obj) {
        int total = 0;
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        for (Modifier mod : this.allMods) {
            if (!mod.getModified().equals(obj) || mod.getCondition() != null) continue;
            int modVal = mod.getValue();
            String type = mod.getType();
            Integer curVal = (Integer)types.get(type);
            if (curVal != null && modVal <= curVal) continue;
            types.put(type, modVal);
        }
        for (Integer val : types.values()) {
            total += val.intValue();
        }
        return total;
    }

    public Size getSize() {
        return this.size;
    }

    public int getStat(BaseStat stat) {
        return this.stats.get((Object)stat);
    }

    public int getStatMod(BaseStat stat) {
        return this.stats.get((Object)stat) / 2 - 5;
    }

    public void rollStats() {
        Random rand = new Random();
        BaseStat[] baseStatArray = BaseStat.values();
        int n = baseStatArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseStat stat = baseStatArray[n2];
            int total = 0;
            int minVal = 7;
            int j = 0;
            while (j < 4) {
                int roll = rand.nextInt(6) + 1;
                total += roll;
                if (minVal > roll) {
                    minVal = roll;
                }
                ++j;
            }
            this.stats.put(stat, total -= minVal);
            ++n2;
        }
    }

    public void setRace(D20Race race) {
        this.charRace = race;
        HashSet<Modifier> mods = race.getModifiers();
        this.allMods.addAll(mods);
        for (Modifier mod : mods) {
            Object modified = mod.getModified();
            if (modified instanceof BaseStat) {
                BaseStat stat = (BaseStat)((Object)modified);
                int curStat = this.stats.get((Object)stat);
                this.stats.put(stat, curStat + mod.getValue());
                continue;
            }
            if (!(modified instanceof D20Feat)) continue;
            this.feats.add((D20Feat)modified);
        }
        this.specials.addAll(race.getSpecials());
    }

    public void setSize(Size size) {
        this.size = size;
    }
}

