/*
 * Decompiled with CFR 0.152.
 */
package map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GridMap
extends JComponent {
    private static final long serialVersionUID = 5553075618417695954L;
    Dimension dimension = new Dimension(0, 0);
    Random random = new Random();
    static int dpi = 72;

    public GridMap() {
        this(new Dimension(40, 40));
    }

    public GridMap(Dimension dim) {
        this.setDimension(dim);
    }

    private void addNewComponent() {
        int val = this.random.nextInt(100);
        JLabel tile = new JLabel("" + val, 0);
        tile.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add(tile);
    }

    public void setComponent(String newComp, int x, int y) {
        Component comp = this.getComponentAt(x, y);
        if (comp instanceof JLabel) {
            ((JLabel)comp).setText(newComp);
        }
        this.invalidate();
        this.validate();
    }

    public void setDimension(Dimension dim) {
        int x;
        int xTilesPrev = (this.dimension.width + 4) / 5;
        int yTilesPrev = (this.dimension.height + 4) / 5;
        int xTiles = (dim.width + 4) / 5;
        int yTiles = (dim.height + 4) / 5;
        this.dimension = dim;
        this.setLayout(new GridLayout(yTiles, xTiles));
        Component[][] comps = new Component[xTilesPrev][yTilesPrev];
        int y = 0;
        while (y < yTilesPrev) {
            x = 0;
            while (x < xTilesPrev) {
                int inx = y * xTilesPrev + x;
                comps[x][y] = this.getComponent(inx);
                ++x;
            }
            ++y;
        }
        this.removeAll();
        y = 0;
        while (y < yTiles) {
            x = 0;
            while (x < xTiles) {
                if (x < xTilesPrev && y < yTilesPrev) {
                    this.add(comps[x][y]);
                } else {
                    this.addNewComponent();
                }
                ++x;
            }
            ++y;
        }
        this.invalidate();
        this.setMinimumSize(new Dimension(dpi * xTiles, dpi * yTiles));
        this.setPreferredSize(new Dimension(dpi * xTiles, dpi * yTiles));
        this.validate();
    }

    public static int getDpi() {
        return dpi;
    }

    public static void setDpi(int dpi) {
        GridMap.dpi = dpi;
    }
}

