/*
 * Decompiled with CFR 0.152.
 */
package cards.Rage;

import cards.CCGPlayer;
import cards.Card;
import cards.CardGame;
import cards.Deck;
import cards.Rage.Caern;
import cards.Rage.Character;
import cards.Rage.Creature;
import cards.Rage.EventTotem;
import cards.Rage.Moot;
import cards.Rage.RageCard;
import cards.Rage.Territory;
import java.util.HashSet;
import java.util.Set;

public class RagePlayer
extends CCGPlayer {
    Deck combatDeck = new Deck();
    Deck combatHand = new Deck();
    HashSet<Creature> packmates = new HashSet();
    HashSet<Territory> territories = new HashSet();
    Deck victoryPile = new Deck();
    int septHandSize = 5;
    int combatHandSize = 5;
    Caern caern = null;
    EventTotem totem = null;
    Creature alpha;

    public RagePlayer(String playerName, CardGame game, boolean isAuto) {
        super(playerName, game, isAuto);
    }

    public void addTerritory(Territory territory) {
        this.territories.add(territory);
    }

    public void addToPack(Creature creature) {
        this.packmates.add(creature);
    }

    public void addTotem(EventTotem totem) {
        this.totem = totem;
    }

    public void alphaAction(Set<RageCard> huntingGrounds, Set<Creature> alphas) {
    }

    public Set<Moot> callMoots() {
        HashSet<Moot> moots = new HashSet<Moot>();
        if (this.isAuto()) {
            for (Card card : this.getHand()) {
                if (!(card instanceof Moot)) continue;
                Moot moot = (Moot)card;
                for (Creature packmate : this.packmates) {
                    if (!(packmate instanceof Character) || packmate.isUmbral() || packmate.getValue() < moot.getValue()) continue;
                    ((Character)packmate).callMoot(moot);
                    moots.add(moot);
                }
            }
        }
        return moots;
    }

    public void equipAlly() {
        if (this.isAuto()) {
            int i = 0;
            while (i < this.getHand().size()) {
                ++i;
            }
        }
    }

    public Creature getAlpha() {
        return this.alpha;
    }

    public Caern getCaern() {
        return this.caern;
    }

    public Set<Territory> getTerritories() {
        return this.territories;
    }

    public void redraw() {
        while (this.getHand().size() < this.septHandSize) {
            this.drawCard();
        }
    }

    public void regenerate() {
        for (Creature being : this.packmates) {
            being.regenerate();
        }
    }

    public Creature selectAlpha() {
        Creature alpha = null;
        if (this.isAuto()) {
            int combat = -1;
            for (Creature being : this.packmates) {
                int dangerRating = being.getRage() + (being.getHealth() - being.getDamage()) * 2;
                if (dangerRating <= combat) continue;
                combat = dangerRating;
                alpha = being;
            }
            return alpha;
        }
        return alpha;
    }

    public Object selectTarget(String targetType) {
        return this;
    }

    public void setAlpha(Creature alpha) {
        this.alpha = alpha;
    }

    public void setCaern(Caern caern) {
        this.caern = caern;
    }

    public void umbraPhase() {
        this.isAuto();
    }

    public void voteMoot(Moot moot) {
    }
}

