/*
 * Decompiled with CFR 0.152.
 */
package cards.Rage;

import cards.Rage.Character;
import cards.Rage.Creature;
import cards.Rage.RageCard;
import java.util.HashSet;

public class Moot
extends RageCard {
    private static final long serialVersionUID = 7605303963668131921L;
    private String auspice = null;
    private Character caller = null;
    private transient int ayeVotes = 0;
    private transient int nayVotes = 0;
    private transient HashSet<Creature> hasVoted = new HashSet();
    private String allegiance = "Gaia";

    public Moot(String mootName, int renownNeeded) {
        this(mootName, renownNeeded, "*");
    }

    public Moot(String mootName, int renownNeeded, String whichAuspice) {
        super(mootName, "Moot", renownNeeded);
        if (whichAuspice.equals("Wyrm")) {
            this.allegiance = "Wyrm";
        } else {
            this.auspice = whichAuspice;
        }
    }

    public boolean call(Character mootCaller) {
        if (mootCaller.getValue() >= this.getValue() && mootCaller.getAllegiance().equals(this.allegiance) && (this.auspice.equals("*") || this.auspice.equals(mootCaller.getAuspice()))) {
            this.caller = mootCaller;
        }
        return this.caller != null;
    }

    public String getAllegiance() {
        return this.allegiance;
    }

    public String getAuspice() {
        return this.auspice;
    }

    public void setAllegiance(String allegiance) {
        this.allegiance = allegiance;
    }

    @Override
    public String toString() {
        if (this.allegiance.equals("Wyrm")) {
            return String.valueOf(this.getName()) + " (Board Meeting)";
        }
        return super.toString();
    }

    public void vote(Creature creature, boolean isAye) {
        if (creature.canVote(this) && !this.hasVoted.contains(creature)) {
            if (isAye) {
                this.ayeVotes += creature.getVote();
            } else {
                this.nayVotes += creature.getVote();
            }
            this.hasVoted.add(creature);
        }
    }
}

