/*
 * Decompiled with CFR 0.152.
 */
package cards.Rage;

import cards.Rage.Creature;
import cards.Rage.RageCard;
import cards.Rage.RageGame;
import cards.Rage.RagePlayer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Gift
extends RageCard {
    private static final long serialVersionUID = 3133988693294831494L;
    HashSet<String> canUse = new HashSet();
    String targetType = null;

    public Gift(String giftName, int gnosisNeeded, Set<String> user) {
        super(giftName, "Gift", gnosisNeeded);
        this.canUse.addAll(user);
    }

    public Gift(String giftName, int gnosisNeeded, String users) {
        super(giftName, "Gift", gnosisNeeded);
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.canUse.add(st.nextToken());
        }
    }

    public boolean cast(Creature caster) {
        if (caster.getGnosis() < this.getValue()) {
            return false;
        }
        if (this.targetType != null) {
            Object target = ((RagePlayer)this.getPlayer()).selectTarget(this.targetType);
            if (!((RageGame)this.getGame()).checkGiftCancel(this, target)) {
                this.playGift(caster, target);
            }
        } else if (!((RageGame)this.getGame()).checkGiftCancel(this, caster)) {
            this.playGift(caster, caster);
        }
        return true;
    }

    public abstract void playGift(Creature var1, Object var2);
}

