/*
 * Decompiled with CFR 0.152.
 */
package cards.Rage;

import cards.Rage.CombatAction;
import cards.Rage.Equipment;
import cards.Rage.Gift;
import cards.Rage.Moot;
import cards.Rage.RageCard;
import java.util.HashSet;

public class Creature
extends RageCard
implements Comparable {
    private static final long serialVersionUID = -5510082243630176408L;
    private int rage;
    private int gnosis;
    private int health;
    private int damage = 0;
    private boolean regen;
    private int curRage;
    private HashSet<String> casting = new HashSet();
    private String allegiance = "Gaia";
    private HashSet<RageCard> attached = new HashSet();
    private HashSet<CombatAction> damaged = new HashSet();
    private String creatureType = "Garou";
    private transient boolean umbral;

    public Creature(String name, String type, int itsRenown, int itsRage, int itsGnosis, int itsHealth) {
        super(name, type, itsRenown);
        this.rage = itsRage;
        this.gnosis = itsGnosis;
        this.health = itsHealth;
        this.curRage = this.rage;
        this.umbral = false;
    }

    public void addCasting(String requirement) {
        this.casting.add(requirement);
    }

    public boolean canVote(Moot moot) {
        return false;
    }

    public boolean castGift(Gift gift) {
        return gift.cast(this);
    }

    public int compareTo(Object o) {
        Creature creature = (Creature)o;
        return this.getValue() - creature.getValue();
    }

    public boolean equip(Equipment equipment) {
        boolean played = false;
        if (equipment.equip(this)) {
            this.attached.add(equipment);
            played = true;
        }
        return played;
    }

    public String getAllegiance() {
        return this.allegiance;
    }

    public String getCreatureType() {
        return this.creatureType;
    }

    public int getCurRage() {
        return this.curRage;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getGnosis() {
        return this.gnosis;
    }

    public int getHealth() {
        return this.health;
    }

    public int getRage() {
        return this.rage;
    }

    public int getRenown() {
        return this.getValue();
    }

    public int getVote() {
        return this.getValue();
    }

    public boolean isGaia() {
        return this.allegiance.equals("Gaia");
    }

    public boolean isUmbral() {
        return this.umbral;
    }

    public boolean isWyrm() {
        return this.allegiance.equals("Wyrm");
    }

    public void regenerate() {
        if (this.regen && this.damaged.size() > 0) {
            int lowDamage = 99;
            int lowRage = 99;
            CombatAction toRegen = null;
            for (CombatAction hurt : this.damaged) {
                if (hurt.getDamage() >= lowDamage && (hurt.getDamage() != lowDamage || hurt.getRage() >= lowRage)) continue;
                toRegen = hurt;
                lowDamage = hurt.getDamage();
                lowRage = hurt.getRage();
            }
            this.damaged.remove(toRegen);
            this.damage -= toRegen.getDamage();
        }
    }

    public void setAllegiance(String side) {
        this.allegiance = side;
    }

    public void setCreatureType(String type) {
        this.creatureType = type;
    }

    public void setGnosis(int gnosis) {
        this.gnosis = gnosis;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public void setRage(int rage) {
        this.rage = rage;
    }

    public void takeDamage(CombatAction hurt) {
        this.damaged.add(hurt);
        this.damage += hurt.getDamage();
        if (this.damage > this.health) {
            System.out.println(String.valueOf(this.getName()) + " is Dead");
        }
    }
}

