/*
 * Decompiled with CFR 0.152.
 */
package cards.Rage;

import cards.Rage.Ally;
import cards.Rage.Caern;
import cards.Rage.CombatAction;
import cards.Rage.Creature;
import cards.Rage.Moot;
import cards.Rage.RageGame;
import cards.Rage.RagePlayer;
import cards.Rage.Territory;
import java.util.HashSet;

public class Character
extends Creature {
    private static final long serialVersionUID = 1631459726647515511L;
    private int battleRage;
    private int battleGnosis;
    private int battleHealth;
    String breed;
    String auspice;
    String tribe;
    String aspect;
    boolean crinos = false;

    public Character(Creature creature) {
        this(creature.getName(), creature.getValue(), creature.getRage(), creature.getGnosis(), creature.getHealth());
        this.crinos = true;
    }

    public Character(String name, int itsRenown, int itsRage, int itsGnosis, int itsHealth) {
        super(name, "Character", itsRenown, itsRage, itsGnosis, itsHealth);
        this.battleRage = itsRage;
        this.battleGnosis = itsGnosis;
        this.battleHealth = itsHealth;
    }

    public boolean callMoot(Moot moot) {
        boolean played = false;
        if (moot.call(this)) {
            ((RageGame)this.getGame()).callMoot(moot);
            played = true;
        }
        return played;
    }

    public boolean canUse(HashSet<String> checks, String ctype, int value) {
        if (ctype.equals("Gift") || ctype.equals("Equipment") ? value > this.getGnosis() : (ctype.equals("Moot") || ctype.equals("Rite") || ctype.equals("Ally") || ctype.equals("Board Meeting")) && value > this.getValue()) {
            return false;
        }
        if (checks == null || checks.size() == 0) {
            return true;
        }
        for (String test : checks) {
            if (!test.equals(this.breed) && !test.equals(this.auspice) && !test.equals(this.tribe)) continue;
            return true;
        }
        return false;
    }

    public boolean canUse(String test, String ctype, int value) {
        if (ctype.equals("Gift") || ctype.equals("Equipment")) {
            if (value > this.getGnosis()) {
                return false;
            }
        } else if (ctype.equals("Moot") || ctype.equals("Rite") || ctype.equals("Ally") || ctype.equals("Board Meeting")) {
            if (value > this.getValue()) {
                return false;
            }
            if (!ctype.equals("Rite") && !ctype.equals("Moot")) {
                ctype.equals("Board Meeting");
            }
        }
        return test == null || test.length() == 0 || test.equals(this.breed) || test.equals(this.auspice) || test.equals(this.tribe);
    }

    @Override
    public boolean canVote(Moot moot) {
        boolean votable = false;
        if (moot.getAllegiance().equals(this.getAllegiance())) {
            String mootAuspice = moot.getAuspice();
            votable = mootAuspice == null || mootAuspice.equals(this.auspice);
        }
        return votable;
    }

    public boolean canVote(String auspice) {
        return auspice == null || auspice.equals(this.auspice);
    }

    public String getAuspice() {
        return this.auspice;
    }

    public String getBreed() {
        return this.breed;
    }

    public String getTribe() {
        return this.tribe;
    }

    public boolean playCaern(Caern caern) {
        if (caern.play(this)) {
            ((RagePlayer)this.getPlayer()).setCaern(caern);
            return true;
        }
        return false;
    }

    public boolean playTerritory(Territory territory) {
        if (territory.play(this)) {
            ((RagePlayer)this.getPlayer()).addTerritory(territory);
            return true;
        }
        return false;
    }

    public boolean recruitAlly(Ally ally) {
        if (ally.recruit(this)) {
            ((RagePlayer)this.getPlayer()).addToPack(ally);
            return true;
        }
        return false;
    }

    public void setBreedStats(int rage, int gnosis, int health) {
    }

    public void setInfo(String itsBreed, String itsAuspice, String itsTribe, String side) {
        this.breed = itsBreed;
        this.auspice = itsAuspice;
        this.tribe = itsTribe;
        this.setAllegiance(side);
        if (side.equals("Gaia")) {
            this.addCasting(this.breed);
            this.addCasting(this.auspice);
        } else {
            this.addCasting(this.aspect);
        }
        this.addCasting(this.tribe);
    }

    @Override
    public void takeDamage(CombatAction hurt) {
        if (!this.crinos && hurt.getDamage() + this.getDamage() > this.getHealth()) {
            this.setHealth(this.battleHealth);
            this.setGnosis(this.battleGnosis);
            this.setRage(this.battleRage);
            System.out.println(String.valueOf(this.getName()) + " flips into Crinos form!");
        }
        super.takeDamage(hurt);
    }
}

