/*
 * Decompiled with CFR 0.152.
 */
package cards;

import cards.Card;
import cards.CardGame;
import cards.Deck;
import cards.SetupPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Random;

public class Player {
    private String name;
    private Deck hand = new Deck();
    private CardGame thisGame;
    private Panel playView = new Panel(new BorderLayout(5, 5));
    private CardLayout cards = new CardLayout();
    private Panel cardPanel = new Panel(this.cards);
    private Container playCtrls;
    private HashMap<Player, Panel> hands = new HashMap();
    private HashMap<Player, Panel> playAreas = new HashMap();
    private Label infoLabel = new Label();
    boolean myTurn = false;
    boolean auto = true;
    boolean isActive = true;
    private MouseAdapter ma;
    private Panel butns = new Panel(new GridLayout(1, 0));
    private TextArea helpArea = new TextArea("", 10, 60, 1);
    private SetupPanel setupView;
    private Frame topFrame;
    private String cmdString;
    public TextArea gameRecord = new TextArea(15, 25);
    private String lastCard = "";
    int choice = -1;
    private ActionListener al;

    public Player() {
        this("nobody", null, true);
    }

    public Player(String playerName, CardGame game) {
        this(playerName, game, true);
    }

    public Player(String playerName, CardGame game, boolean isAuto) {
        this.name = new String(playerName);
        this.thisGame = game;
        this.auto = isAuto;
    }

    public void addCtrlButn(Button butn) {
        this.butns.add((Component)butn, this.butns.getComponentCount() - 1);
    }

    public void addToHand(Card c) {
        this.hand.add(c);
    }

    public void appendRecord(String text) {
        this.gameRecord.append(String.valueOf(text) + "\n");
    }

    public void createAppletDisplay(Applet applet) {
        this.playCtrls = applet;
        this.topFrame = (Frame)applet.getParent();
        this.createDisplay();
    }

    public void createDisplay() {
        this.ma = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Card thisCard = (Card)e.getSource();
                Player.this.showInfo(thisCard.getName());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Player.this.showInfo("");
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Card thisCard = (Card)e.getSource();
                thisCard.removeMouseListener(this);
                Player.this.playMyCard(thisCard);
            }
        };
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Player.this.cmdString = e.getActionCommand();
                Container cont = ((Button)e.getSource()).getParent();
                while (!(cont instanceof Window)) {
                    cont = cont.getParent();
                }
                if (cont instanceof Dialog) {
                    ((Dialog)cont).dispose();
                }
            }
        };
        this.playCtrls.setLayout(new BorderLayout());
        this.playCtrls.add((Component)this.cardPanel, "Center");
        this.playCtrls.add((Component)this.infoLabel, "South");
        this.cardPanel.add("Play", this.playView);
        this.setupView = this.createSetupPanel();
        this.cardPanel.add("Setup", this.setupView);
        Panel helpView = this.createHelpPanel();
        this.cardPanel.add("Help", helpView);
        for (Player player : this.thisGame.getPlayers()) {
            this.hands.put(player, new Panel());
            this.playAreas.put(player, new Panel());
        }
        this.setupPlayAreas();
        this.playCtrls.add((Component)this.butns, "North");
        Button newButn = new Button("New Game");
        Button setupButn = new Button("Setup");
        Button helpButn = new Button("Help");
        this.butns.add(newButn);
        this.butns.add(setupButn);
        this.butns.add(helpButn);
        newButn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Player.this.thisGame.restart();
            }
        });
        setupButn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Player.this.lastCard = "Setup";
                Player.this.setupView.reset();
                Player.this.cards.show(Player.this.cardPanel, "Setup");
            }
        });
    }

    public Frame createFrameDisplay() {
        this.topFrame = new Frame();
        this.playCtrls = this.topFrame;
        this.createDisplay();
        ((Frame)this.playCtrls).setTitle(this.name);
        ((Frame)this.playCtrls).setSize(500, 550);
        ((Frame)this.playCtrls).setVisible(true);
        ((Frame)this.playCtrls).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        return this.topFrame;
    }

    public Panel createHelpPanel() {
        Panel info = new Panel(new BorderLayout());
        this.helpArea.setEditable(false);
        info.add((Component)this.helpArea, "Center");
        Button done = new Button("Done");
        info.add((Component)done, "South");
        done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Player.this.cards.show(Player.this.cardPanel, Player.this.lastCard);
            }
        });
        return info;
    }

    public SetupPanel createSetupPanel() {
        return new SetupPanel(this);
    }

    public void discard() {
        int loVal = 1000000;
        Card discarded = null;
        for (Card card : this.hand) {
            if (card.value >= loVal) continue;
            loVal = card.value;
            discarded = card;
        }
        this.gameRecord.append(String.valueOf(this.name) + " discarded a " + discarded + "\n");
        this.hand.remove(discarded);
    }

    public void display() {
        this.cards.show(this.cardPanel, "Play");
        this.lastCard = "Play";
        for (Player player : this.thisGame.getPlayers()) {
            Panel playHand = this.hands.get(player);
            Panel playArea = this.playAreas.get(player);
            playHand.invalidate();
            if (player.equals(this)) {
                this.showHand(playHand);
            } else {
                player.showMyHand(playHand);
            }
            playHand.invalidate();
            playArea.invalidate();
            this.showPlayArea(player, this.playAreas.get(player));
            playArea.invalidate();
            playArea.validate();
            playHand.validate();
        }
        this.playCtrls.invalidate();
        this.playCtrls.validate();
        this.playCtrls.setVisible(true);
    }

    public CardGame getGame() {
        return this.thisGame;
    }

    public Deck getHand() {
        return this.hand;
    }

    public String getName() {
        return this.name;
    }

    public Panel getPlayerArea(Player player) {
        return this.playAreas.get(player);
    }

    public Frame getTopFrame() {
        return this.topFrame;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isMyTurn() {
        return this.myTurn;
    }

    public int numQuery(String title, String query, int min, int max) {
        this.choice = -1;
        if (!this.isAuto()) {
            final Dialog dialog = new Dialog(this.getTopFrame(), title, true);
            final Label numLabel = new Label("" + min);
            dialog.add((Component)new Label(query), "North");
            final Scrollbar sbar = new Scrollbar(0, min, 1, min, max + 1);
            sbar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    numLabel.setText("" + e.getValue());
                }
            });
            dialog.add((Component)sbar, "Center");
            dialog.add((Component)numLabel, "West");
            Button ok = new Button("OK");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Player.this.choice = sbar.getValue();
                    dialog.dispose();
                }
            });
            dialog.add((Component)ok, "South");
            dialog.pack();
            dialog.show();
        } else {
            this.choice = Math.abs(new Random().nextInt() % (max - min + 1)) + min;
        }
        return this.choice;
    }

    public void playMyCard(Card myCard) {
    }

    public void removeCardFromHand(Card card) {
        this.hand.remove(card);
    }

    public void reset() {
        this.gameRecord.setText("");
        this.hand = new Deck();
    }

    public void resetPlayerCount(int num) {
        this.thisGame.setPlayerCount(num);
        this.thisGame.restart();
        this.setupPlayAreas();
    }

    private void setupPlayAreas() {
        this.playView.removeAll();
        this.playView.add((Component)this.gameRecord, "Center");
        int playerNum = this.thisGame.getPlayerNum(this);
        int numPlayers = this.thisGame.getPlayerCount();
        GridLayout verti = new GridLayout(0, 1, 1, 1);
        GridLayout horiz = new GridLayout(1, 0, 1, 1);
        int i = 0;
        while (i < numPlayers) {
            Player player = this.thisGame.getPlayer(i);
            int inx = i + playerNum;
            if (inx >= numPlayers) {
                inx -= numPlayers;
            }
            if (i == 0) {
                Panel p1 = new Panel();
                p1.setLayout(verti);
                this.hands.get(player).setLayout(horiz);
                this.playAreas.get(player).setLayout(horiz);
                p1.add(this.playAreas.get(player));
                p1.add(this.hands.get(player));
                this.playView.add((Component)p1, "South");
            } else if ((double)i == (double)numPlayers / 2.0) {
                Panel p2 = new Panel();
                p2.setLayout(verti);
                this.hands.get(player).setLayout(horiz);
                this.playAreas.get(player).setLayout(horiz);
                p2.add(this.hands.get(player));
                p2.add(this.playAreas.get(player));
                this.playView.add((Component)p2, "North");
            } else if ((double)i < (double)numPlayers / 2.0) {
                Panel p3 = new Panel();
                p3.setLayout(horiz);
                this.hands.get(player).setLayout(verti);
                this.playAreas.get(player).setLayout(verti);
                p3.add(this.hands.get(player));
                p3.add(this.playAreas.get(player));
                this.playView.add((Component)p3, "West");
            } else if ((double)i > (double)numPlayers / 2.0) {
                Panel p4 = new Panel();
                p4.setLayout(horiz);
                this.hands.get(player).setLayout(verti);
                this.playAreas.get(player).setLayout(verti);
                p4.add(this.playAreas.get(player));
                p4.add(this.hands.get(player));
                this.playView.add((Component)p4, "East");
            }
            ++i;
        }
    }

    public void showHand(Container c) {
        c.removeAll();
        for (Card card : this.hand) {
            card.removeMouseListener(this.ma);
            card.addMouseListener(this.ma);
            c.add(card);
        }
        c.add(new Label(this.name));
    }

    public void showHelp(String helpText) {
        this.helpArea.setText(helpText);
        this.cards.show(this.cardPanel, "Help");
    }

    public void showInfo(String info) {
        this.infoLabel.setText(info);
    }

    public void showMyHand(Container c) {
        c.removeAll();
        int i = 0;
        while (i < this.getHand().size()) {
            c.add(new Card(this.thisGame.getCardBack()));
            ++i;
        }
        c.add(new Label(this.name));
    }

    public void showPlayArea(Player p, Container c) {
    }

    public void takeTurn() {
        this.myTurn = true;
    }

    public boolean textQuery(String title, String query) {
        if (!this.isAuto()) {
            Dialog dialog = new Dialog(this.getTopFrame(), title, true);
            dialog.add((Component)new Label(query), "North");
            Panel butnPanel = new Panel(new GridLayout(1, 0));
            Button yes = new Button("Yes");
            yes.addActionListener(this.al);
            butnPanel.add(yes);
            Button no = new Button("No");
            no.addActionListener(this.al);
            butnPanel.add(no);
            dialog.add((Component)butnPanel, "South");
            dialog.pack();
            dialog.show();
            return this.cmdString.equals("Yes");
        }
        return true;
    }

    public String textQuery(String title, String query, String[] options) {
        if (!this.isAuto()) {
            Dialog dialog = new Dialog(this.getTopFrame(), title, true);
            dialog.add((Component)new Label(query), "North");
            Panel butnPanel = new Panel(new GridLayout(1, 0));
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                if (option != null) {
                    Button butn = new Button(option);
                    butn.addActionListener(this.al);
                    butnPanel.add(butn);
                }
                ++n2;
            }
            if (butnPanel.getComponentCount() == 0) {
                return null;
            }
            dialog.add((Component)butnPanel, "South");
            dialog.pack();
            dialog.show();
            return this.cmdString;
        }
        return options[0];
    }
}

