/*
 * Decompiled with CFR 0.152.
 */
package cards.MilleBornes;

import cards.Card;
import cards.Deck;
import cards.MilleBornes.MBGame;
import cards.Player;
import java.awt.Container;
import java.awt.Label;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MBPlayer
extends Player {
    private Card battlePile = new Card();
    private Card speedPile = new Card();
    private int limit;
    private int mileage;
    private Deck Safeties = new Deck();
    private Card hazard = new Card();

    public MBPlayer(String PlayerName, MBGame game) {
        super(PlayerName, game);
    }

    public MBPlayer(String PlayerName, MBGame game, boolean isAuto) {
        super(PlayerName, game, isAuto);
    }

    @Override
    public void createDisplay() {
        super.createDisplay();
        for (Player player : this.getGame().getPlayers()) {
            final MBPlayer mbp = (MBPlayer)player;
            this.getPlayerArea(player).addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MBPlayer.this.playMyCard(MBPlayer.this.hazard, mbp);
                }
            });
        }
    }

    public boolean findSafety(String safety) {
        boolean found = false;
        for (Card card : this.Safeties) {
            if (!safety.equals(card.getName())) continue;
            found = true;
        }
        return found;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean playCard(Card pickCard) {
        MBGame game;
        String ctype;
        Card card;
        block24: {
            String battleName;
            String cname;
            block25: {
                block27: {
                    block26: {
                        block23: {
                            card = this.getHand().findCard(pickCard.getName());
                            ctype = card.getCardType();
                            cname = card.getName();
                            battleName = this.battlePile.getName();
                            game = (MBGame)this.getGame();
                            if (card == null) {
                                if (!this.isAuto()) {
                                    this.appendRecord("You don't have a " + card);
                                }
                                return false;
                            }
                            if (!ctype.equals("Mileage")) break block23;
                            if (battleName == null || !battleName.equals("Roll")) {
                                if (!this.isAuto()) {
                                    this.appendRecord("You cannot go yet!\n");
                                }
                                return false;
                            }
                            int miles = Integer.parseInt(card.getName());
                            if (this.limit > 0 && miles > this.limit) {
                                if (!this.isAuto()) {
                                    this.appendRecord("You cannot break the limit of " + this.limit + "\n");
                                }
                                return false;
                            }
                            if (this.mileage + miles > game.getMileLimit()) {
                                if (!this.isAuto()) {
                                    this.appendRecord("Cannot go beyond " + game.getMileLimit() + " miles\n");
                                }
                                return false;
                            }
                            this.mileage += miles;
                            break block24;
                        }
                        if (!ctype.equals("Remedy")) break block25;
                        if (battleName != null || !cname.equals("Roll")) break block26;
                        this.battlePile = card;
                        break block24;
                    }
                    if (!cname.equals("End of Limit") || this.limit <= 0) break block27;
                    this.speedPile = card;
                    this.limit = 0;
                    break block24;
                }
                if (battleName == null) {
                    if (!this.isAuto()) {
                        this.appendRecord("Cannot Remedy - no problems yet!\n");
                    }
                    return false;
                }
                if (battleName.equals("Accident") && cname.equals("Repairs") || battleName.equals("Flat Tire") && cname.equals("Spare Tire") || battleName.equals("Out of Gas") && cname.equals("Gas Station") || battleName.equals("Stop") && cname.equals("Roll") || this.battlePile.getCardType().equals("Remedy") && !battleName.equals("Roll") && cname.equals("Roll")) {
                    this.battlePile = card;
                    if (this.findSafety("Emergency Vehicle")) {
                        this.battlePile = new Card("Roll", "Remedy");
                    }
                    break block24;
                } else {
                    if (!this.isAuto()) {
                        this.appendRecord("You don't need a " + card + " yet!\n");
                    }
                    return false;
                }
            }
            if (ctype.equals("Safety")) {
                if (battleName == null && cname.equals("Emergency Vehicle")) {
                    this.battlePile = new Card("Roll", "Remedy");
                } else if (battleName != null && (battleName.equals("Accident") && cname.equals("Driving Ace") || battleName.equals("Flat Tire") && cname.equals("Puncture Proof") || battleName.equals("Out of Gas") && cname.equals("Gas Truck") || battleName.equals("Stop") && cname.equals("Emergency Vehicle") || this.battlePile.getCardType().equals("Remedy") && cname.equals("Emergency Vehicle"))) {
                    this.battlePile = new Card("Roll", "Remedy");
                    game.setCardImage(this.battlePile, "Roll.gif");
                }
                if (cname.equals("Emergency Vehicle")) {
                    this.limit = 0;
                    this.speedPile = new Card();
                }
                this.Safeties.addCards(card, 1);
            } else if (ctype.equals("Hazard")) {
                if (!this.isAuto()) {
                    this.appendRecord("Cannot play Hazard on yourself!\n");
                }
                return false;
            }
        }
        this.getGame().broadcast(String.valueOf(this.getName()) + " played a " + card);
        this.getHand().remove(card);
        if (ctype.equals("Safety")) {
            game.extraTurn();
        }
        return true;
    }

    public boolean playCard(Card pickCard, MBPlayer opponent) {
        Card card = this.getHand().findCard(pickCard.getName());
        String ctype = card.getCardType();
        String cname = card.getName();
        String battleName = opponent.battlePile.getName();
        if (card == null) {
            if (!this.isAuto()) {
                this.appendRecord("You don't have a " + card);
            }
            return false;
        }
        if (ctype.equals("Hazard")) {
            if (cname.equals("Speed Limit") && opponent.findSafety("Emergency Vehicle") || cname.equals("Stop") && opponent.findSafety("Emergency Vehicle") || cname.equals("Out of Gas") && opponent.findSafety("Gas Truck") || cname.equals("Accident") && opponent.findSafety("Driving Ace") || cname.equals("Flat Tire") && opponent.findSafety("Puncture Proof")) {
                if (!this.isAuto()) {
                    this.appendRecord(String.valueOf(opponent.getName()) + " is protected against " + cname + "\n");
                }
                return false;
            }
            if (cname.equals("Speed Limit")) {
                if (opponent.limit == 0) {
                    opponent.limit = 50;
                    opponent.speedPile = card;
                    this.removeCardFromHand(card);
                    this.getGame().broadcast(String.valueOf(this.getName()) + " played a " + card + " on " + opponent.getName() + "\n");
                    return true;
                }
                return false;
            }
            if (battleName == null) {
                if (!this.isAuto()) {
                    this.appendRecord("Cannot Play on " + opponent.getName() + " yet\n");
                }
                return false;
            }
            if (battleName.equals("Roll")) {
                opponent.battlePile = card;
                this.removeCardFromHand(card);
                this.getGame().broadcast(String.valueOf(this.getName()) + " played a " + card + " on " + opponent.getName() + "\n");
                return true;
            }
        }
        if (!this.isAuto()) {
            this.appendRecord("Cannot play " + card + " on " + opponent.getName() + "\n");
        }
        return false;
    }

    @Override
    public void playMyCard(Card myCard) {
        if (!this.isMyTurn()) {
            return;
        }
        if (myCard.getCardType().equals("Hazard")) {
            this.hazard = myCard;
        } else {
            this.hazard = null;
            if (!this.playCard(myCard)) {
                Card card = this.getHand().findCard(myCard.getName());
                this.removeCardFromHand(card);
            }
            ((MBGame)this.getGame()).nextTurn(this.mileage);
        }
    }

    public void playMyCard(Card myCard, MBPlayer opponent) {
        if (this.isMyTurn() && this.hazard != null) {
            Card card = this.getHand().findCard(myCard.getName());
            if (opponent == this) {
                this.removeCardFromHand(card);
            } else if (this.playCard(myCard, opponent)) {
                this.hazard = null;
            } else {
                this.removeCardFromHand(card);
            }
            ((MBGame)this.getGame()).nextTurn(this.mileage);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mileage = 0;
        this.hazard = new Card();
        this.Safeties = new Deck();
        this.battlePile = new Card();
        this.speedPile = new Card();
    }

    @Override
    public void showPlayArea(Player p, Container c) {
        MBPlayer mbPlayer = (MBPlayer)p;
        c.removeAll();
        c.add(new Card(mbPlayer.speedPile));
        c.add(new Card(mbPlayer.battlePile));
        c.add(new Label(String.valueOf(mbPlayer.mileage)));
        for (Card safety : mbPlayer.Safeties) {
            c.add(safety);
        }
    }

    private void TakeAutoTurn() {
        int playerID = 0;
        MBGame game = (MBGame)this.getGame();
        Card card = game.drawCard();
        if (card != null) {
            this.addToHand(card);
        }
        int i = 0;
        while (i < this.getHand().size()) {
            card = (Card)this.getHand().get(i);
            if (this.playCard(card)) {
                i = 99;
            } else if (card.getCardType().equals("Hazard")) {
                int j = 0;
                while (j < game.getPlayerCount()) {
                    Player pl = game.getPlayers().get(j);
                    if (pl == this) {
                        playerID = j;
                    }
                    ++j;
                }
                j = 1;
                while (j < game.getPlayerCount()) {
                    int inx = (j + playerID) % game.getPlayerCount();
                    MBPlayer target = (MBPlayer)game.getPlayers().get(inx);
                    if (target != this && this.playCard(card, target)) {
                        i = 99;
                        j = 99;
                    }
                    ++j;
                }
            }
            if (i == 99) continue;
            ++i;
        }
        if (i != 99) {
            this.discard();
        }
        game.nextTurn(this.mileage);
    }

    private void TakeMyTurn() {
        Card card = this.getGame().drawCard();
        if (card != null) {
            this.addToHand(card);
        }
        this.display();
    }

    public void TakeTurn() {
        super.takeTurn();
        if (this.isAuto()) {
            this.TakeAutoTurn();
        } else {
            this.TakeMyTurn();
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + "  BP: " + this.battlePile.getName() + "  Miles" + this.mileage;
    }
}

