/*
 * Decompiled with CFR 0.152.
 */
package cards.MilleBornes;

import cards.Card;
import cards.CardGame;
import cards.Deck;
import cards.MilleBornes.MBPlayer;
import cards.Player;

public class MBGame
extends CardGame {
    private static final long serialVersionUID = 4231306668222797917L;
    Deck discard = new Deck();
    int mileLimit = 700;

    public int getMileLimit() {
        return this.mileLimit;
    }

    @Override
    public void init() {
        MBPlayer player = new MBPlayer("You", this, false);
        this.addPlayer(player);
        this.addPlayer(new MBPlayer("Ann", this));
        this.addPlayer(new MBPlayer("Bob", this));
        this.addPlayer(new MBPlayer("Cathy", this));
        player.createAppletDisplay(this);
    }

    public void nextTurn(int miles) {
        MBPlayer player = (MBPlayer)this.getCurrPlayer();
        if (player != null && miles == this.mileLimit) {
            this.broadcast(String.valueOf(player.getName()) + " WINS!");
            return;
        }
        boolean stillPlaying = false;
        int i = 0;
        while (i < this.getPlayerCount() && !stillPlaying) {
            player = (MBPlayer)this.getPlayers().get(i);
            if (player.getHand().size() > 0) {
                stillPlaying = true;
            }
            ++i;
        }
        if (!stillPlaying) {
            this.broadcast("Deadlocked - no winner");
            return;
        }
        player = (MBPlayer)this.getNextPlayer();
        player.TakeTurn();
    }

    @Override
    public void restart() {
        for (Player player : this.getPlayers()) {
            player.reset();
        }
        this.start();
    }

    @Override
    public void setupDeck() {
        Card card = new Card("Roll", "Remedy", 100);
        this.setCardImage(card, "Roll.gif");
        this.addToDeck(card, 14);
        card = new Card("End of Limit", "Remedy", 50);
        this.setCardImage(card, "EoL.gif");
        this.addToDeck(card, 4);
        card = new Card("Spare Tire", "Remedy", 100);
        this.setCardImage(card, "Spare.gif");
        this.addToDeck(card, 6);
        card = new Card("Gas Station", "Remedy", 100);
        this.setCardImage(card, "Gas.gif");
        this.addToDeck(card, 6);
        card = new Card("Repairs", "Remedy", 100);
        this.setCardImage(card, "Rep.gif");
        this.addToDeck(card, 6);
        card = new Card("Stop", "Hazard", 75);
        this.setCardImage(card, "Stop.gif");
        this.addToDeck(card, 4);
        card = new Card("Speed Limit", "Hazard", 50);
        this.setCardImage(card, "Limit.gif");
        this.addToDeck(card, 3);
        card = new Card("Flat Tire", "Hazard", 100);
        this.setCardImage(card, "Flat.gif");
        this.addToDeck(card, 2);
        card = new Card("Out of Gas", "Hazard", 100);
        this.setCardImage(card, "OoGas.gif");
        this.addToDeck(card, 2);
        card = new Card("Accident", "Hazard", 100);
        this.setCardImage(card, "Acc.gif");
        this.addToDeck(card, 2);
        card = new Card("200", "Mileage", 200);
        this.setCardImage(card, "200.gif");
        this.addToDeck(card, 4);
        card = new Card("100", "Mileage", 100);
        this.setCardImage(card, "100.gif");
        this.addToDeck(card, 12);
        card = new Card("75", "Mileage", 75);
        this.setCardImage(card, "75.gif");
        this.addToDeck(card, 10);
        card = new Card("50", "Mileage", 50);
        this.setCardImage(card, "50.gif");
        this.addToDeck(card, 10);
        card = new Card("25", "Mileage", 25);
        this.setCardImage(card, "25.gif");
        this.addToDeck(card, 10);
        card = new Card("Emergency Vehicle", "Safety", 300);
        this.setCardImage(card, "Emer.gif");
        this.addToDeck(card, 1);
        card = new Card("Gas Truck", "Safety", 300);
        this.setCardImage(card, "GasTr.gif");
        this.addToDeck(card, 1);
        card = new Card("Driving Ace", "Safety", 300);
        this.setCardImage(card, "Ace.gif");
        this.addToDeck(card, 1);
        card = new Card("Puncture Proof", "Safety", 300);
        this.setCardImage(card, "PP.gif");
        this.addToDeck(card, 1);
        this.setCardBack("cardBack.gif");
    }

    @Override
    public void start() {
        this.setupDeck();
        this.shuffleDeck();
        this.Deal(6);
        this.nextTurn(0);
    }

    public static void main(String[] argv) {
        MBGame game = new MBGame();
        MBPlayer player = new MBPlayer(System.getProperty("user.name"), game, false);
        game.addPlayer(player);
        game.addPlayer(new MBPlayer("Ann", game));
        game.addPlayer(new MBPlayer("Bob", game));
        game.addPlayer(new MBPlayer("Cathy", game));
        player.createFrameDisplay();
        game.start();
    }
}

