/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation.spell;

import cards.MagiNation.Creature;
import cards.MagiNation.MNCard;
import cards.MagiNation.MNGame;
import cards.MagiNation.Magi;
import cards.MagiNation.Spell;
import cards.MagiNation.SpellInfo;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public final class BottomlessPit
extends Spell {
    private static final long serialVersionUID = 1420591367291025653L;

    public BottomlessPit() {
        super("Bottomless Pit", "Underneath", 3);
    }

    @Override
    public boolean autoCast(Magi magus, boolean isFirst) {
        Vector<Creature> choices = new Vector<Creature>();
        int killEnergy = 0;
        Set<Creature> creatures = ((MNGame)this.getGame()).getAllCreatures();
        for (Creature creature : creatures) {
            int energy = creature.getCurrEnergy();
            if (creature.getController().equals(magus) || energy >= 5 || energy < killEnergy) continue;
            if (energy > killEnergy) {
                killEnergy = energy;
                choices.removeAllElements();
            }
            choices.addElement(creature);
        }
        if (!choices.isEmpty()) {
            int index = Math.abs(new Random().nextInt() % choices.size());
            Creature creature = (Creature)choices.elementAt(index);
            return this.cast(magus, creature);
        }
        return false;
    }

    @Override
    public void doSpellEffect(SpellInfo info) {
        MNCard target = info.getTarget();
        if (target instanceof Creature && target.isInPlay() && ((Creature)target).getCurrEnergy() < 5) {
            target.discard();
        }
    }

    @Override
    public String getPrompt() {
        return "Select creature to drop in Bottomless Pit";
    }
}

