/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation;

import cards.MagiNation.MNCard;
import cards.MagiNation.MNGame;
import cards.MagiNation.Magi;
import cards.MagiNation.PendingEffect;
import cards.MagiNation.SpellInfo;

public abstract class Spell
extends MNCard {
    private static final long serialVersionUID = 5138022467959461443L;
    transient int duration = 0;
    transient Magi caster;

    public Spell(String name, String region, int cost) {
        super(name, region, "Spell", cost);
    }

    public boolean autoCast(Magi magi, boolean isFirst) {
        if (!this.needsTarget()) {
            return this.cast(magi);
        }
        System.out.println("AUTO: Not sure how to cast " + this.getName());
        return false;
    }

    public boolean canCast(Magi magi) {
        if (this.getRegion().equals("Core") && !magi.getRegion().equals("Core")) {
            return false;
        }
        return this.getRegion().equals("Core") || this.getRegion().equals("Universal") || !magi.getRegion().equals("Core");
    }

    public boolean cast(Magi magi) {
        if (!this.canCast(magi)) {
            return false;
        }
        this.caster = magi;
        int cost = this.getValue();
        if (!magi.getRegion().equals(this.getRegion())) {
            ++cost;
        }
        if ((cost += magi.getSpellCostMod()) < 1) {
            cost = 1;
        }
        if (magi.getCurrEnergy() < cost) {
            return false;
        }
        SpellInfo info = ((MNGame)this.getGame()).checkCasting(this, magi, null);
        if (info.canCast) {
            magi.loseEnergy(cost);
            this.showMessage(String.valueOf(magi.getName()) + " casts " + this.getName());
            this.doSpellEffect(info);
            if (!(this instanceof PendingEffect)) {
                this.getPlayer().addToDiscard(this);
            }
        }
        return info.canCast;
    }

    public boolean cast(Magi magi, MNCard target) {
        if (!this.canCast(magi)) {
            return false;
        }
        this.caster = magi;
        this.setPlayer(magi.getPlayer());
        int cost = this.getValue();
        if (!magi.getRegion().equals(this.getRegion())) {
            ++cost;
        }
        if ((cost += magi.getSpellCostMod()) < 1) {
            cost = 1;
        }
        if (magi.getCurrEnergy() < cost) {
            return false;
        }
        SpellInfo info = ((MNGame)this.getGame()).checkCasting(this, magi, target);
        if (info.canCast) {
            magi.loseEnergy(cost);
            this.showMessage(String.valueOf(magi.getName()) + " casts " + this.getName() + " at " + target.getName());
            this.doSpellEffect(info);
            if (!(this instanceof PendingEffect)) {
                this.getPlayer().addToDiscard(this);
            }
        }
        return info.canCast;
    }

    public abstract void doSpellEffect(SpellInfo var1);

    @Override
    public boolean needsTarget() {
        return true;
    }

    @Override
    public boolean newTurn() {
        --this.duration;
        return this.duration > 0;
    }
}

