/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation;

import cards.CCGCard;
import cards.MagiNation.Creature;
import cards.MagiNation.MNCard;
import cards.MagiNation.MNPlayer;
import cards.MagiNation.Relic;
import cards.MagiNation.Spell;
import java.util.HashSet;

public abstract class Magi
extends MNCard {
    private static final long serialVersionUID = 2329853601984785651L;
    private HashSet<MNCard> initialCards = new HashSet();
    private int currEnergy;
    private transient HashSet<Creature> creatures = new HashSet();
    private transient HashSet<Relic> relics = new HashSet();
    private transient boolean defeated = false;
    private transient int spellCostMod = 0;
    private transient int creaturePowerMod = 0;
    private int energizeRate = 5;
    private String title = "";

    public Magi(String name, String region, int startE, int energize) {
        super(name, region, "Magi", startE);
        this.energizeRate = energize;
        this.currEnergy = startE;
    }

    public void activate() {
        this.enterPlay();
        for (MNCard initial : this.initialCards) {
            String cardName = initial.getName();
            CCGCard card = this.getPlayer().searchDiscard(cardName);
            if (card == null) {
                card = this.getPlayer().searchDeck(cardName);
            }
            if (card == null) continue;
            this.getPlayer().addToHand(card);
        }
    }

    protected void addInitialCard(MNCard card) {
        this.initialCards.add(card);
    }

    public boolean castSpell(Spell spell) {
        return spell.cast(this);
    }

    public boolean castSpellAt(Spell spell, MNCard target) {
        return spell.cast(this, target);
    }

    public void checkDeath() {
        if (this.creatures.size() == 0 && this.currEnergy == 0) {
            this.discard();
        }
    }

    @Override
    public void discard() {
        this.showMessage(String.valueOf(this.getName()) + " is Defeated!");
        for (Creature creature : this.creatures) {
            creature.discard();
        }
        for (Relic relic : this.relics) {
            relic.discard();
        }
        this.leavePlay();
        this.currEnergy = 0;
        this.defeated = true;
    }

    @Override
    public void doAuto(boolean isFirst) {
        for (Creature creature : this.creatures) {
            creature.doAuto(isFirst);
        }
        for (Relic relic : this.relics) {
            relic.doAuto(isFirst);
        }
        if (isFirst) {
            for (Creature creature : this.creatures) {
                creature.doAutoAttack();
            }
        }
    }

    public void drawPhase() {
        this.getPlayer().drawCard();
        this.getPlayer().drawCard();
    }

    @Override
    public void energize() {
        this.currEnergy += this.energizeRate;
    }

    public void gainEnergy(int energy) {
        this.currEnergy += energy;
    }

    public HashSet<Creature> getCreatures() {
        return this.creatures;
    }

    @Override
    public int getCurrEnergy() {
        return this.currEnergy;
    }

    public int getPowerCostMod(MNCard card) {
        return card instanceof Creature ? this.creaturePowerMod : 0;
    }

    public HashSet<Relic> getRelics() {
        return this.relics;
    }

    public int getSpellCostMod() {
        return this.spellCostMod;
    }

    public String getStatus() {
        String stat = String.valueOf(this.toString()) + "\n";
        for (Creature creature : this.creatures) {
            stat = String.valueOf(stat) + creature.toString() + "\n";
        }
        for (Relic relic : this.relics) {
            stat = String.valueOf(stat) + relic.toString() + "\n";
        }
        return stat;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDefeated() {
        return this.defeated;
    }

    public void loseEnergy(int energy) {
        if (this.currEnergy >= energy) {
            this.currEnergy -= energy;
            this.checkDeath();
        } else {
            this.currEnergy = 0;
            this.checkDeath();
        }
    }

    public void loseEnergy(int energy, MNCard source) {
        this.loseEnergy(energy);
    }

    @Override
    public boolean newTurn() {
        super.newTurn();
        for (Creature creature : this.creatures) {
            creature.newTurn();
        }
        for (Relic relic : this.relics) {
            relic.newTurn();
        }
        return true;
    }

    public boolean playRelic(Relic relic) {
        for (Relic mine : this.relics) {
            if (!relic.getName().equals(mine)) continue;
            return false;
        }
        boolean played = relic.play(this);
        if (played) {
            this.relics.add(relic);
        }
        return played;
    }

    public void reset() {
        this.currEnergy = this.getValue();
        this.creatures.clear();
        this.relics.clear();
        this.defeated = false;
        this.leavePlay();
    }

    public void setCurrEnergy(int energy) {
        this.currEnergy = energy;
    }

    protected void setInitialEnergy(int energy) {
        this.currEnergy = energy;
    }

    public void setPlayer(MNPlayer p) {
        super.setPlayer(p);
        this.setGame(p.getGame());
        this.setupImage();
    }

    protected void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public boolean summon(Creature creature) {
        int cost = creature.summon(this);
        if (cost > -1) {
            this.loseEnergy(cost);
            this.showMessage(String.valueOf(this.getName()) + " summoned a " + creature.getName());
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.isInPlay()) {
            return String.valueOf(this.getName()) + " (" + this.getRegion() + " Magi) at " + this.currEnergy + " energy";
        }
        return String.valueOf(this.getName()) + " (" + this.getRegion() + " Magi)";
    }

    public void undream(Creature creature) {
        int energy = creature.getCurrEnergy();
        creature.setCurrEnergy(0);
        this.currEnergy += energy;
        this.getPlayer().addToHand(creature);
    }
}

