/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation;

import cards.CCGPlayer;
import cards.Card;
import cards.Deck;
import cards.MagiNation.Creature;
import cards.MagiNation.DeckSetup;
import cards.MagiNation.MNCard;
import cards.MagiNation.MNGame;
import cards.MagiNation.MNSetupPanel;
import cards.MagiNation.Magi;
import cards.MagiNation.Relic;
import cards.MagiNation.Spell;
import cards.Player;
import cards.SetupPanel;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EmptyStackException;
import java.util.Random;
import java.util.Stack;

public class MNPlayer
extends CCGPlayer
implements ActionListener {
    Magi[] magi = new Magi[3];
    int curMagi = 0;
    int phase = 0;
    MNCard acting = null;
    Stack stackedCards = new Stack();
    MouseAdapter mouse;

    public MNPlayer(String playerName, MNGame game) {
        this(playerName, game, true);
    }

    public MNPlayer(String playerName, MNGame game, boolean isAuto) {
        super(playerName, game, isAuto);
        this.setRecycle(true);
        DeckSetup setup = new DeckSetup(this);
        this.magi = setup.getMagi();
        this.setDrawDeck(setup.getDeck());
        int i = 0;
        while (i < 3) {
            this.magi[i].setPlayer(this);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (!command.equals("Query") && command.equals("Next Phase")) {
            ++this.phase;
            if (this.phase == 2 && this.magi[this.curMagi].getCreatures().isEmpty()) {
                ++this.phase;
            }
            this.showPhase();
            if (this.phase == 5) {
                this.magi[this.curMagi].drawPhase();
                this.phase = 0;
                ((MNGame)this.getGame()).nextTurn();
            }
        }
    }

    @Override
    public void createDisplay() {
        super.createDisplay();
        this.mouse = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Card thisCard = (Card)e.getSource();
                MNPlayer.this.showInfo(thisCard.toString());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MNPlayer.this.showPhase();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MNCard thisCard = (MNCard)e.getSource();
                MNPlayer.this.playMyCard(thisCard);
            }
        };
        Button query = new Button("Query");
        query.addActionListener(this);
        this.addCtrlButn(query);
        Button next = new Button("Next Phase");
        next.addActionListener(this);
        this.addCtrlButn(next);
    }

    @Override
    public SetupPanel createSetupPanel() {
        return new MNSetupPanel(this);
    }

    public void discardCards(int count, boolean isRandom) {
        Random rand = new Random();
        Deck hand = this.getHand();
        if (isRandom || this.isAuto()) {
            int i = 0;
            while (i < count && hand.size() > 0) {
                int cardNum = Math.abs(rand.nextInt() % hand.size());
                MNCard card = (MNCard)hand.get(cardNum);
                hand.remove(cardNum);
                this.addToDiscard(card);
                ++i;
            }
        }
    }

    public Magi getMagi() {
        return this.magi[this.curMagi];
    }

    @Override
    public void playMyCard(Card myCard) {
        MNCard card = (MNCard)myCard;
        Magi magus = this.magi[this.curMagi];
        Deck hand = this.getHand();
        if (this.acting != null) {
            if (this.phase == 1 || this.phase == 4) {
                if (this.acting instanceof Spell) {
                    if (magus.castSpellAt((Spell)this.acting, card)) {
                        hand.remove(this.acting);
                    }
                } else {
                    this.acting.usePower(card);
                }
            } else if (this.phase == 2 && this.acting instanceof Creature && (card instanceof Creature || card instanceof Magi)) {
                ((Creature)this.acting).attack(card);
            }
            try {
                this.acting = (MNCard)this.stackedCards.pop();
                this.showInfo(this.acting.getPrompt());
            }
            catch (EmptyStackException empty) {
                this.acting = null;
                this.showPhase();
            }
        } else if (this.phase == 2) {
            if (card instanceof Creature && card.isInPlay() && card.getPlayer().equals(this)) {
                this.acting = card;
                this.showInfo(String.valueOf(card.getName()) + " is Attacking.  Target?");
            }
        } else if (this.phase == 3) {
            if (card instanceof Creature && hand.indexOf(card) > -1 && magus.summon((Creature)card)) {
                hand.remove(card);
            }
        } else if (card.needsTarget() && (card instanceof Spell || card.isInPlay() && card.getPlayer().equals(this))) {
            this.acting = card;
            this.showInfo(this.acting.getPrompt());
        } else {
            if (this.phase == 1 || this.phase == 4) {
                if (card instanceof Spell && !card.isInPlay()) {
                    if (magus.castSpell((Spell)card)) {
                        hand.remove(card);
                    }
                } else if (card instanceof Relic && !card.isInPlay()) {
                    if (magus.playRelic((Relic)card)) {
                        hand.remove(card);
                    }
                } else {
                    card.usePower();
                }
            }
            try {
                this.acting = (MNCard)this.stackedCards.pop();
                this.showInfo(this.acting.getPrompt());
            }
            catch (EmptyStackException empty) {
                this.acting = null;
                this.showPhase();
            }
        }
        this.display();
    }

    @Override
    public void reset() {
        super.reset();
        for (Creature creature : this.magi[this.curMagi].getCreatures()) {
            creature.getPlayer().getDrawDeck().add(creature);
        }
        for (Relic relic : this.magi[this.curMagi].getRelics()) {
            relic.getPlayer().getDrawDeck().add(relic);
        }
        this.shuffleDeck();
        if (this.getDrawDeck().size() < 40) {
            System.out.println("Lost Cards somewhere: " + this.getDrawDeck().size());
        }
        int i = 0;
        while (i < 3) {
            this.magi[i].reset();
            ++i;
        }
        this.curMagi = 0;
    }

    public void setMagi(Magi[] mages) {
        int i = 0;
        while (i < 3) {
            this.magi[i] = mages[i];
            this.magi[i].setPlayer(this);
            ++i;
        }
    }

    public void showPhase() {
        if (this.phase == 1) {
            this.showInfo("PHASE: Powers/Relics/Spells 1");
        } else if (this.phase == 2) {
            this.showInfo("PHASE: Attack");
        } else if (this.phase == 3) {
            this.showInfo("PHASE: Summon");
        } else if (this.phase == 4) {
            this.showInfo("PHASE: Powers/Relics/Spells 2");
        } else if (this.phase == 5) {
            this.showInfo("PHASE: Draw");
        } else {
            this.showInfo("");
        }
    }

    @Override
    public void showPlayArea(Player p, Container c) {
        MNPlayer mnPlayer = (MNPlayer)p;
        c.removeAll();
        Magi magus = mnPlayer.getMagi();
        if (magus.isInPlay()) {
            for (Creature creature : magus.getCreatures()) {
                creature.removeMouseListener(this.mouse);
                creature.addMouseListener(this.mouse);
                c.add(creature);
            }
            c.add(magus);
            magus.removeMouseListener(this.mouse);
            magus.addMouseListener(this.mouse);
            for (Relic relic : this.magi[this.curMagi].getRelics()) {
                relic.removeMouseListener(this.mouse);
                relic.addMouseListener(this.mouse);
                c.add(relic);
            }
        }
    }

    public void stackEffect(MNCard card) {
        this.stackedCards.push(card);
    }

    private void TakeAutoTurn() {
        MNCard card;
        Magi magus = this.magi[this.curMagi];
        Deck hand = this.getHand();
        int index = 0;
        while (index < hand.size()) {
            card = (MNCard)hand.get(index);
            if (card instanceof Relic) {
                if (magus.playRelic((Relic)card)) {
                    hand.remove(card);
                    continue;
                }
                ++index;
                continue;
            }
            if (card instanceof Spell) {
                if (magus.getCurrEnergy() > card.getValue() && ((Spell)card).autoCast(magus, true)) {
                    hand.remove(card);
                    continue;
                }
                ++index;
                continue;
            }
            ++index;
        }
        magus.doAuto(true);
        index = 0;
        while (index < hand.size()) {
            card = (MNCard)hand.get(index);
            if (card instanceof Creature) {
                if (magus.summon((Creature)card)) {
                    hand.remove(card);
                    continue;
                }
                ++index;
                continue;
            }
            ++index;
        }
        magus.doAuto(false);
        for (Card card2 : hand) {
            MNCard mnCard = (MNCard)card2;
            if (!(card2 instanceof Spell) || magus.getCurrEnergy() >= card2.getValue() || !((Spell)card2).autoCast(magus, true)) continue;
            hand.remove(card2);
        }
        magus.drawPhase();
        ((MNGame)this.getGame()).nextTurn();
    }

    private void TakeMyTurn() {
        this.display();
        this.phase = 1;
        this.showPhase();
    }

    public void TakeTurn() {
        this.getGame().broadcast("---- Starting " + this.getName() + "'s Turn ----");
        if (!this.magi[this.curMagi].isInPlay() && !this.magi[this.curMagi].isDefeated()) {
            this.magi[this.curMagi].activate();
            if (this.curMagi == 0) {
                while (this.getHand().size() < 5) {
                    this.drawCard();
                }
            }
            if (this.curMagi != 0 || this.getGame().getPlayerNum(this) > 0) {
                this.magi[this.curMagi].newTurn();
            }
        } else if (this.magi[this.curMagi].isDefeated()) {
            if (this.curMagi < 2) {
                ++this.curMagi;
                this.magi[this.curMagi].activate();
                this.magi[this.curMagi].newTurn();
            }
        } else {
            this.magi[this.curMagi].newTurn();
        }
        if (!this.magi[this.curMagi].isDefeated()) {
            if (this.isAuto()) {
                this.TakeAutoTurn();
            } else {
                this.TakeMyTurn();
            }
            ((MNGame)this.getGame()).checkEndTurn(this.magi[this.curMagi]);
        }
    }
}

