/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation;

import cards.CCGPlayer;
import cards.CardGame;
import cards.MagiNation.AttackInfo;
import cards.MagiNation.Creature;
import cards.MagiNation.MNCard;
import cards.MagiNation.MNPlayer;
import cards.MagiNation.Magi;
import cards.MagiNation.PendingEffect;
import cards.MagiNation.PowerInfo;
import cards.MagiNation.Relic;
import cards.MagiNation.Spell;
import cards.MagiNation.SpellInfo;
import cards.Player;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class MNGame
extends CardGame {
    private static final long serialVersionUID = 8997492585211490312L;
    Vector attacks = new Vector();
    Vector summons = new Vector();
    Vector castings = new Vector();
    Vector discards = new Vector();
    Vector relics = new Vector();
    Vector endturn = new Vector();
    Vector powers = new Vector();
    Vector pending = new Vector();
    Vector attackable = new Vector();
    Vector castable = new Vector();
    Vector relicable = new Vector();
    Vector powerable = new Vector();
    Vector summonable = new Vector();

    public void affectAttack(MNCard card) {
        this.attacks.add(card);
    }

    public void affectAttackable(MNCard card) {
        this.attackable.add(card);
    }

    public void affectCastable(MNCard card) {
        this.castable.add(card);
    }

    public void affectCasting(MNCard card) {
        this.castings.add(card);
    }

    public void affectDiscard(MNCard card) {
        this.discards.add(card);
    }

    public void affectEndTurn(MNCard card) {
        this.endturn.add(card);
    }

    public void affectPower(MNCard card) {
        this.powers.add(card);
    }

    public void affectPowerUsable(MNCard card) {
        this.powerable.add(card);
    }

    public void affectRelic(MNCard card) {
        this.relics.add(card);
    }

    public void affectRelicPlayable(MNCard card) {
        this.relicable.add(card);
    }

    public void affectSummon(MNCard card) {
        this.summons.add(card);
    }

    public void affectSummonable(MNCard card) {
        this.summonable.add(card);
    }

    public boolean canAttack(Creature attacker, MNCard defender) {
        boolean can = true;
        if (defender instanceof Magi && !((Magi)defender).getCreatures().isEmpty()) {
            can = false;
        }
        Enumeration e = this.attackable.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            can = card.checkAttackable(can, attacker, defender);
        }
        return can;
    }

    public boolean canCastSpell(Spell spell) {
        boolean can = true;
        Enumeration e = this.castable.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            can = card.checkCastable(can, spell);
        }
        return can;
    }

    public boolean canSummon(Creature creature, Magi summoner) {
        boolean can = true;
        Enumeration e = this.castable.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            can = card.checkSummonable(can, creature, summoner);
        }
        return can;
    }

    public boolean canUsePower(MNCard powerUser) {
        boolean can = true;
        Enumeration e = this.powerable.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            can = card.checkPowerUsable(can, powerUser);
        }
        return can;
    }

    public AttackInfo checkAttack(Creature attacker, MNCard defender) {
        AttackInfo attackInfo = new AttackInfo(attacker, defender);
        Enumeration e = this.attacks.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            attackInfo = card.checkAttack(attackInfo);
        }
        return attackInfo;
    }

    public SpellInfo checkCasting(Spell spell, Magi magus, MNCard target) {
        SpellInfo info = new SpellInfo(magus, spell, target);
        Enumeration e = this.castings.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            info = card.checkCasting(info);
        }
        return info;
    }

    public void checkDiscard(MNCard discarded) {
        Enumeration e = this.attacks.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            card.checkDiscard(discarded);
        }
    }

    public void checkEndTurn(Magi magus) {
        Enumeration e = this.endturn.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            card.checkEndTurn(magus);
        }
    }

    public void checkPower(MNCard powerUser, MNCard target) {
        PowerInfo info = new PowerInfo(powerUser, target);
        Enumeration e = this.attacks.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            info = card.checkPower(info);
        }
    }

    public void checkRelic(Relic relic) {
        Enumeration e = this.attacks.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            card.checkRelic(relic);
        }
    }

    public void checkSummon(Creature creature, Magi magus) {
        Enumeration e = this.summons.elements();
        while (e.hasMoreElements()) {
            MNCard card = (MNCard)e.nextElement();
            card.checkSummon(creature, magus);
        }
    }

    public Set<Creature> getAllCreatures() {
        HashSet<Creature> creatures = new HashSet<Creature>();
        for (Player player : this.getPlayers()) {
            MNPlayer mnPlayer = (MNPlayer)player;
            creatures.addAll(mnPlayer.getMagi().getCreatures());
        }
        return creatures;
    }

    public Set<Magi> getAllMagi() {
        HashSet<Magi> magi = new HashSet<Magi>();
        for (Player player : this.getPlayers()) {
            MNPlayer mnPlayer = (MNPlayer)player;
            Magi mage = mnPlayer.getMagi();
            if (mage == null || !mage.isInPlay()) continue;
            magi.add(mage);
        }
        return magi;
    }

    public Creature getBiggestOpposing(CCGPlayer player) {
        int bigSize = 0;
        Vector<Creature> creatures = new Vector<Creature>();
        int i = 0;
        while (i < this.getPlayerCount()) {
            MNPlayer opponent = (MNPlayer)this.getPlayers().get(i);
            if (!opponent.equals(player)) {
                for (Creature creature : opponent.getMagi().getCreatures()) {
                    if (creature.getCurrEnergy() > bigSize) {
                        creatures.removeAllElements();
                        bigSize = creature.getCurrEnergy();
                    }
                    if (creature.getCurrEnergy() != bigSize) continue;
                    creatures.add(creature);
                }
            }
            ++i;
        }
        if (creatures.size() > 0) {
            int index = Math.abs(new Random().nextInt() % creatures.size());
            return (Creature)creatures.elementAt(index);
        }
        return null;
    }

    public Vector getOpposingCreatures(CCGPlayer player, int minEnergy) {
        Vector<Creature> creatures = new Vector<Creature>();
        int i = 0;
        while (i < this.getPlayerCount()) {
            MNPlayer opponent = (MNPlayer)this.getPlayers().get(i);
            if (!opponent.equals(player)) {
                for (Creature creature : opponent.getMagi().getCreatures()) {
                    if (creature.getCurrEnergy() < minEnergy) continue;
                    creatures.add(creature);
                }
            }
            ++i;
        }
        return creatures;
    }

    @Override
    public void init() {
        MNPlayer player = new MNPlayer("You", this, false);
        this.addPlayer(player);
        this.addPlayer(new MNPlayer("Ann", this));
        this.addPlayer(new MNPlayer("Bob", this));
        this.addPlayer(new MNPlayer("Cathy", this));
        player.createAppletDisplay(this);
    }

    public void nextTurn() {
        MNPlayer player = (MNPlayer)this.getNextPlayer();
        int i = 0;
        while (i < this.pending.size()) {
            PendingEffect effect = (PendingEffect)this.pending.elementAt(i);
            if (effect.startTurn(player)) {
                ++i;
                continue;
            }
            this.pending.removeElementAt(i);
        }
        player.TakeTurn();
    }

    public void pendEffect(PendingEffect card) {
        this.pending.add(card);
    }

    public void removeCard(MNCard card) {
        this.attacks.removeElement(card);
        this.castings.removeElement(card);
        this.summons.removeElement(card);
        this.discards.removeElement(card);
        this.relics.removeElement(card);
        this.powers.removeElement(card);
        this.endturn.removeElement(card);
    }

    @Override
    public void setupDeck() {
    }

    @Override
    public void start() {
        this.nextTurn();
    }

    public static void main(String[] argv) {
        MNGame game = new MNGame();
        MNPlayer player = new MNPlayer(System.getProperty("user.name"), game, false);
        game.addPlayer(player);
        game.addPlayer(new MNPlayer("Ann", game));
        game.addPlayer(new MNPlayer("Bob", game));
        game.addPlayer(new MNPlayer("Cathy", game));
        player.createFrameDisplay();
        game.start();
    }
}

