/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation;

import cards.CCGCard;
import cards.MagiNation.AttackInfo;
import cards.MagiNation.Creature;
import cards.MagiNation.MNGame;
import cards.MagiNation.Magi;
import cards.MagiNation.PowerInfo;
import cards.MagiNation.Relic;
import cards.MagiNation.Spell;
import cards.MagiNation.SpellInfo;
import cards.MagiNation.relic.RayjesBand;
import java.util.Set;
import java.util.Vector;

public abstract class MNCard
extends CCGCard {
    private static final long serialVersionUID = 165786142175403184L;
    private String region;
    private transient boolean powerUsed = false;

    public MNCard(String name, String region, String ctype, int value) {
        super(name, ctype, value);
        this.region = region;
    }

    public AttackInfo checkAttack(AttackInfo info) {
        return info;
    }

    public boolean checkAttackable(boolean canAttack, Creature attacker, MNCard defender) {
        return canAttack;
    }

    public boolean checkCastable(boolean canCast, Spell spell) {
        return canCast;
    }

    public SpellInfo checkCasting(SpellInfo info) {
        return info;
    }

    public void checkDiscard(MNCard card) {
    }

    public void checkEndTurn(Magi magus) {
    }

    public PowerInfo checkPower(PowerInfo info) {
        return info;
    }

    public boolean checkPowerUsable(boolean canUse, MNCard powerUser) {
        return canUse;
    }

    public boolean checkRelic(Relic relic) {
        return true;
    }

    public boolean checkRelicPlayable(boolean canPlay, Relic relic) {
        return canPlay;
    }

    public boolean checkSummon(Creature creature, Magi magi) {
        return true;
    }

    public boolean checkSummonable(boolean canSummon, Creature creature, Magi summoner) {
        return canSummon;
    }

    public void discard() {
        this.getPlayer().addToDiscard(this);
        this.leavePlay();
        this.checkDiscard(this);
        if (!this.isInPlay()) {
            ((MNGame)this.getGame()).removeCard(this);
            for (CCGCard card : this.getAttachments()) {
                MNCard mnCard = (MNCard)card;
                mnCard.discard();
            }
        }
    }

    public void doAuto(boolean isFirst) {
    }

    public void energize() {
    }

    public String getAbilityName() {
        return null;
    }

    public int getCurrEnergy() {
        return 0;
    }

    public String getPrompt() {
        return "";
    }

    public String getRegion() {
        return this.region;
    }

    public Vector getRegionChoice() {
        return null;
    }

    public boolean isLockedDown(String ability) {
        Set<Magi> mages = ((MNGame)this.getGame()).getAllMagi();
        boolean locked = false;
        for (Magi magi : mages) {
            for (Relic relic : magi.getRelics()) {
                if (!(relic instanceof RayjesBand) || !((RayjesBand)relic).isLockedDown(ability)) continue;
                locked = true;
            }
        }
        return locked;
    }

    public boolean isPowerUsed() {
        return this.powerUsed;
    }

    public boolean needsTarget() {
        return false;
    }

    public boolean newTurn() {
        this.energize();
        this.powerUsed = false;
        return true;
    }

    public void setPowerUsed(boolean powerUsed) {
        this.powerUsed = powerUsed;
    }

    public void setRegionChoice(String newRegion, int index) {
    }

    @Override
    public void setupImage() {
        StringBuffer sb = new StringBuffer();
        if (this.region.equals("Naroom")) {
            sb.append("Nrm");
        } else {
            sb.append(this.region.substring(0, 3));
        }
        if (this instanceof Creature) {
            sb.append("C.gif");
        } else if (this instanceof Magi) {
            sb.append("M.gif");
        } else if (this instanceof Relic) {
            sb.append("R.gif");
        } else if (this instanceof Spell) {
            sb.append("S.gif");
        }
        this.getGame().setCardImage(this, sb.toString());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.region + " " + this.getCardType() + ")";
    }

    public void usePower() {
    }

    public void usePower(MNCard target) {
    }
}

