/*
 * Decompiled with CFR 0.152.
 */
package cards.MagiNation;

import cards.MagiNation.AttackInfo;
import cards.MagiNation.MNCard;
import cards.MagiNation.MNGame;
import cards.MagiNation.MNPlayer;
import cards.MagiNation.Magi;
import cards.MagiNation.Relic;
import cards.MagiNation.Spell;
import cards.MagiNation.creature.OrathanFlyer;
import cards.Player;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public abstract class Creature
extends MNCard {
    private static final long serialVersionUID = 4910435283760398533L;
    private transient int currEnergy;
    private transient Magi controller;
    private transient Vector status;
    private transient boolean hasAttacked = false;
    private transient boolean mustAttack = false;
    private transient int accumDamage;

    public Magi getController() {
        return this.controller;
    }

    public Creature(String name, String region, int startE) {
        super(name, region, "Creature", startE);
    }

    public void addState(String newState) {
        this.status.add(newState);
    }

    public AttackInfo attack(MNCard target) {
        if (this.checkStatus("Burrow") && !this.checkStatus("Tunneling Attack") && !this.checkStatus("Glow")) {
            return null;
        }
        if (target instanceof Relic || target instanceof Spell) {
            return null;
        }
        if (target instanceof Magi && this.controller.equals(target)) {
            return null;
        }
        if (target instanceof Creature && this.controller.equals(((Creature)target).controller)) {
            return null;
        }
        if (!this.hasAttacked) {
            this.hasAttacked = true;
            AttackInfo info = ((MNGame)this.getGame()).checkAttack(this, target);
            if (info.canAttack && info.validTarget) {
                this.showMessage(String.valueOf(this.getName()) + " attacks " + target.getName());
                this.heal(info.attHealth);
                if (target instanceof Creature) {
                    info = ((Creature)target).defend(this, info);
                } else if (target instanceof Magi) {
                    ((Magi)target).gainEnergy(info.defHealth);
                    ((Magi)target).loseEnergy(this.currEnergy);
                }
                if (info.attLoss > info.maxDamageToAtt) {
                    info.attLoss = info.maxDamageToAtt;
                }
                if (info.attLoss > this.currEnergy) {
                    info.attLoss = this.currEnergy;
                }
                this.damage(info.attLoss);
                this.mustAttack = false;
            } else {
                this.hasAttacked = false;
            }
            return info;
        }
        return null;
    }

    public boolean canSummon(Magi magi) {
        String region = this.getRegion();
        if (region.equals("Core") && !magi.getRegion().equals("Core")) {
            return false;
        }
        return region.equals("Core") || region.equals("Universal") || !magi.getRegion().equals("Core");
    }

    public boolean checkStatus(String query) {
        return this.status.contains(query);
    }

    protected void damage(int energy) {
        if (this.checkStatus("Burrow")) {
            int loss = 2 - this.accumDamage;
            if (energy < loss) {
                loss = energy;
            }
            this.currEnergy -= loss;
            this.accumDamage += loss;
        } else {
            this.currEnergy -= energy;
        }
        if (this.currEnergy <= 0) {
            this.discard();
        }
    }

    public void damage(int energy, MNCard source) {
        this.damage(energy);
    }

    public AttackInfo defend(Creature attacker, AttackInfo info) {
        this.heal(info.defHealth);
        info.attLoss = this.currEnergy + info.defPlus;
        info.defLoss = attacker.getCurrEnergy() + info.attPlus;
        if (info.defLoss > info.maxDamageToDef) {
            info.defLoss = info.maxDamageToDef;
        }
        if (info.defLoss > this.currEnergy) {
            info.defLoss = this.currEnergy;
        }
        this.damage(info.defLoss);
        return info;
    }

    @Override
    public void discard() {
        this.controller.getCreatures().remove(this);
        super.discard();
        this.controller.checkDeath();
    }

    public void doAutoAttack() {
        int attChance = this.getAutoAttackChance();
        int chance = Math.abs(new Random().nextInt() % 10);
        if (chance < attChance) {
            MNCard target = this.getAutoAttackTarget();
            this.attack(target);
        }
    }

    protected int getAutoAttackChance() {
        int prob = 0;
        List<Player> players = this.getGame().getPlayers();
        for (Player player : players) {
            MNPlayer mnPlayer = (MNPlayer)player;
            Magi magi = mnPlayer.getMagi();
            if (magi.getCreatures().size() != 0) continue;
            prob = 10;
        }
        if (prob == 0) {
            prob = this.checkStatus("Burrow") && this.currEnergy > 2 && (this.checkStatus("Tunneling Attack") || this.checkStatus("Glow")) ? 8 : 9 - this.getGame().getPlayerCount();
        }
        if (this.mustAttack) {
            prob = 10;
        }
        return prob;
    }

    protected MNCard getAutoAttackTarget() {
        Random rand;
        int index;
        Vector creatures = ((MNGame)this.getGame()).getOpposingCreatures(this.getPlayer(), 0);
        MNCard target = (MNCard)creatures.elementAt(index = Math.abs((rand = new Random()).nextInt() % creatures.size()));
        if (target.getCurrEnergy() > this.getCurrEnergy()) {
            index = Math.abs(rand.nextInt() % creatures.size());
            target = (MNCard)creatures.elementAt(index);
        }
        List<Player> players = this.getGame().getPlayers();
        for (Player player : players) {
            MNPlayer mnPlayer = (MNPlayer)player;
            Magi magi = mnPlayer.getMagi();
            if (magi.getCreatures().size() != 0 || !magi.isInPlay()) continue;
            target = magi;
        }
        return target;
    }

    @Override
    public int getCurrEnergy() {
        return this.currEnergy;
    }

    public void heal(int energy) {
        this.currEnergy += energy;
        if (this.currEnergy <= 0) {
            this.discard();
        }
    }

    @Override
    public boolean newTurn() {
        this.hasAttacked = false;
        this.accumDamage = 0;
        return super.newTurn();
    }

    public void removeState(String state) {
        this.status.removeElement(state);
    }

    public void setCurrEnergy(int energy) {
        this.currEnergy = energy;
    }

    public int summon(Magi magi) {
        if (!this.canSummon(magi)) {
            return -1;
        }
        for (Creature creature : magi.getCreatures()) {
            if (!(creature instanceof OrathanFlyer) || !((OrathanFlyer)creature).summonCreature(this, magi)) continue;
            magi.getCreatures().add(this);
            ((MNGame)this.getGame()).checkSummon(this, magi);
            this.enterPlay();
            return 0;
        }
        this.status = new Vector();
        int energy = this.getValue();
        if (!magi.getRegion().equals(this.getRegion()) && !this.getRegion().equals("Universal")) {
            ++energy;
        }
        if (magi.getCurrEnergy() < energy) {
            return -1;
        }
        this.currEnergy = this.getValue();
        this.controller = magi;
        magi.getCreatures().add(this);
        this.enterPlay();
        ((MNGame)this.getGame()).checkSummon(this, magi);
        return energy;
    }

    @Override
    public String toString() {
        if (this.isInPlay()) {
            return String.valueOf(this.getName()) + " (" + this.getRegion() + " Creature) at " + this.currEnergy + " energy";
        }
        return String.valueOf(this.getName()) + " (" + this.getRegion() + " Creature)";
    }

    public void undream() {
        this.controller.undream(this);
        this.leavePlay();
    }
}

