/*
 * Decompiled with CFR 0.152.
 */
package cards;

import cards.Card;
import cards.Deck;
import cards.Player;
import java.applet.Applet;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class CardGame
extends Applet {
    private static final long serialVersionUID = 7460454808418683653L;
    private Deck drawDeck = new Deck();
    private ArrayList<Player> players = new ArrayList();
    private Card cardBack = new Card();
    private int whosTurn = -1;
    private String imgDir;
    private ArrayList<Player> savedPlayers = new ArrayList();

    public void addPlayer(Player newPlayer) {
        this.players.add(newPlayer);
    }

    public void addToDeck(Card card, int count) {
        this.drawDeck.addCards(card, count);
    }

    public void broadcast(String message) {
        int j = 0;
        while (j < this.players.size()) {
            Player player = this.players.get(j);
            if (!player.isAuto()) {
                player.appendRecord(message);
            }
            ++j;
        }
    }

    public void Deal(int num) {
        int i = 0;
        while (i < num) {
            int j = 0;
            while (j < this.players.size()) {
                Card dealt = this.drawDeck.drawACard();
                Player player = this.players.get(j);
                player.getHand().addCards(dealt, 1);
                ++j;
            }
            ++i;
        }
    }

    public Card drawCard() {
        return this.drawDeck.drawACard();
    }

    public void extraTurn() {
        --this.whosTurn;
        if (this.whosTurn < 0) {
            this.whosTurn = this.players.size() - 1;
        }
    }

    public Card getCardBack() {
        return this.cardBack;
    }

    public Player getCurrPlayer() {
        if (this.whosTurn >= 0) {
            Player player = this.players.get(this.whosTurn);
            return player;
        }
        return null;
    }

    public Player getNextPlayer() {
        Player player;
        if (this.whosTurn > -1) {
            player = this.players.get(this.whosTurn);
            player.myTurn = false;
        }
        ++this.whosTurn;
        if (this.whosTurn >= this.players.size()) {
            this.whosTurn = 0;
        }
        player = this.players.get(this.whosTurn);
        return player;
    }

    public Player getPlayer(int playerNum) {
        return this.players.get(playerNum);
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getPlayerNum(Player player) {
        return this.players.indexOf(player);
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public void restart() {
        this.whosTurn = -1;
        int i = 0;
        while (i < this.players.size()) {
            Player player = this.players.get(i);
            player.reset();
            ++i;
        }
        this.start();
    }

    public void setCardBack(String filename) {
        this.setCardImage(this.cardBack, filename);
    }

    public boolean setCardImage(Card card, String filename) {
        if (this.imgDir == null) {
            String str = this.getClass().getName();
            this.imgDir = "cardData/" + str.substring(str.indexOf(46) + 1, str.lastIndexOf(46)) + "/cardIcons/";
            this.setCardImage(this.cardBack, "cardBack.gif");
        }
        try {
            URL docBase = this.getDocumentBase();
            if (docBase == null) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                card.setImage(tk.getImage(String.valueOf(this.imgDir) + filename));
            } else {
                try {
                    card.setImage(this.getImage(new URL(docBase, String.valueOf(this.imgDir) + filename)));
                }
                catch (MalformedURLException e) {
                    System.out.println(e);
                }
            }
        }
        catch (NullPointerException e) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            card.setImage(tk.getImage(String.valueOf(this.imgDir) + filename));
        }
        return card.getImage() != null;
    }

    public void setImageDir(String dir) {
        this.imgDir = new String(dir);
        this.setCardImage(this.cardBack, "cardBack.gif");
    }

    public void setPlayerCount(int num) {
        Player player;
        while (num < this.players.size()) {
            player = this.players.get(num);
            this.players.remove(num);
            this.savedPlayers.add(player);
        }
        while (num > this.players.size()) {
            player = this.savedPlayers.get(0);
            this.savedPlayers.remove(player);
            this.players.add(player);
        }
    }

    public void setupDeck() {
        char[] vals = new char[]{'2', '3', '4', '5', '6', '7', '8', '9', 'X', 'J', 'Q', 'K', 'A'};
        char[] suits = new char[]{'C', 'D', 'H', 'S'};
        char[] compose = new char[2];
        String label = new String();
        int i = 0;
        while (i < 13) {
            int j = 0;
            while (j < 4) {
                compose[0] = vals[i];
                compose[1] = suits[j];
                label = String.copyValueOf(compose);
                Card card = new Card(label, label, i + 2);
                this.setCardImage(card, String.valueOf(label) + ".gif");
                this.drawDeck.addCards(card, 1);
                ++j;
            }
            ++i;
        }
    }

    public void shuffleDeck() {
        this.drawDeck.shuffle();
    }
}

