/*
 * Decompiled with CFR 0.152.
 */
package cards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Random;

public class Card
extends Component
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3661021057414715980L;
    String name;
    String ctype;
    int value;
    transient Image cardImage;
    private int randID;

    public Card() {
        this.name = null;
        this.ctype = null;
    }

    public Card(Card old) {
        this.name = old.name;
        this.ctype = old.ctype;
        this.value = old.value;
        this.cardImage = old.cardImage;
        this.randID = new Random().nextInt();
    }

    public Card(String name) {
        this.name = name;
        this.randID = new Random().nextInt();
    }

    public Card(String name, String cardtype) {
        this.name = name;
        this.ctype = cardtype;
        this.randID = new Random().nextInt();
    }

    public Card(String name, String cardtype, int val) {
        this.name = name;
        this.ctype = cardtype;
        this.value = val;
        this.randID = new Random().nextInt();
    }

    public Object clone() {
        try {
            Object obj = super.clone();
            ((Card)obj).randID = new Random().nextInt();
            ((Card)obj).cardImage = this.cardImage;
            return obj;
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            return null;
        }
    }

    public String getCardType() {
        return this.ctype;
    }

    public Image getImage() {
        return this.cardImage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cardImage != null) {
            return new Dimension(this.cardImage.getWidth(this), this.cardImage.getHeight(this));
        }
        return new Dimension(0, 0);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void paint(Graphics g) {
        if (this.cardImage != null) {
            g.drawImage(this.cardImage, 0, 0, this);
        }
    }

    public void setImage(Image image) {
        this.cardImage = image;
    }

    public void setImage(String imgName) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.cardImage = tk.getImage(imgName);
    }

    @Override
    public String toString() {
        String cardlabel = new String(String.valueOf(this.name) + " (" + this.ctype + ")");
        return cardlabel;
    }
}

