/*
 * Decompiled with CFR 0.152.
 */
package cards;

import cards.CCGCard;
import cards.Card;
import cards.CardGame;
import cards.Deck;
import cards.Player;

public class CCGPlayer
extends Player {
    Deck drawDeck = new Deck();
    Deck discardPile = new Deck();
    boolean recycles = false;

    public CCGPlayer(String playerName, CardGame game) {
        super(playerName, game);
    }

    public CCGPlayer(String playerName, CardGame game, boolean isAuto) {
        super(playerName, game, isAuto);
    }

    public void addToDiscard(CCGCard card) {
        this.discardPile.addCards(card, 1);
    }

    public CCGCard drawCard() {
        CCGCard card = (CCGCard)this.drawDeck.drawACard();
        if (card == null && this.recycles) {
            this.drawDeck = this.discardPile;
            this.drawDeck.shuffle();
            card = (CCGCard)this.drawDeck.drawACard();
            this.discardPile = new Deck();
        }
        this.addToHand(card);
        return card;
    }

    public void dumpCard(CCGCard card) {
        this.getHand().remove(card);
        this.discardPile.addCards(card, 1);
    }

    public Deck getDiscardPile() {
        return this.discardPile;
    }

    public Deck getDrawDeck() {
        return this.drawDeck;
    }

    @Override
    public void reset() {
        this.drawDeck.addAll(this.discardPile);
        this.drawDeck.addAll(this.getHand());
        super.reset();
        this.discardPile = new Deck();
    }

    public CCGCard searchDeck(String cardName) {
        CCGCard card = (CCGCard)this.drawDeck.findCard(cardName);
        if (card != null) {
            this.drawDeck.remove(card);
        }
        return card;
    }

    public CCGCard searchDiscard(String cardName) {
        CCGCard card = (CCGCard)this.discardPile.findCard(cardName);
        if (card != null) {
            this.discardPile.remove(card);
        }
        return card;
    }

    public void setDrawDeck(Deck deck) {
        this.drawDeck = deck;
        this.drawDeck.shuffle();
        for (Card card : this.drawDeck) {
            if (!(card instanceof CCGCard)) continue;
            CCGCard ccgCard = (CCGCard)card;
            ccgCard.setGame(this.getGame());
            ccgCard.setupImage();
            ccgCard.setPlayer(this);
        }
        this.discardPile = new Deck();
    }

    public void setRecycle(boolean recycle) {
        this.recycles = recycle;
    }

    public void shuffleDeck() {
        this.drawDeck.shuffle();
    }
}

