/*
 * Decompiled with CFR 0.152.
 */
package cards;

import cards.CCGPlayer;
import cards.Card;
import cards.CardGame;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public abstract class CCGCard
extends Card {
    private static final long serialVersionUID = -3019290257877007503L;
    private transient CCGPlayer player = null;
    private transient CardGame game;
    private transient boolean inPlay = false;
    private transient HashSet<CCGCard> attachments = new HashSet();

    public CCGCard(String name, String ctype, int value) {
        super(name, ctype, value);
    }

    public void attach(CCGCard card) {
        this.attachments.add(card);
    }

    public void detach(CCGCard card) {
        this.attachments.remove(card);
    }

    public void enterPlay() {
        this.inPlay = true;
    }

    public Set<CCGCard> getAttachments() {
        return this.attachments;
    }

    public CardGame getGame() {
        return this.game;
    }

    public CCGPlayer getPlayer() {
        return this.player;
    }

    public String getSpoiler(CCGPlayer player) {
        String str = this.getClass().getName();
        String spoiler = "cardData/" + str.substring(str.indexOf(46) + 1, str.lastIndexOf(46)) + "/spoiler.txt";
        StringBuffer sbuf = new StringBuffer();
        BufferedReader buf = null;
        try {
            URL docBase = player.getGame().getDocumentBase();
            if (docBase == null) {
                try {
                    buf = new BufferedReader(new FileReader(spoiler));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else {
                try {
                    URL spoilerURL = new URL(docBase, spoiler);
                    buf = new BufferedReader(new InputStreamReader(spoilerURL.openStream()));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        catch (NullPointerException npe) {
            try {
                buf = new BufferedReader(new FileReader(spoiler));
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (buf == null) {
            return null;
        }
        try {
            String line;
            boolean gotCard = false;
            boolean done = false;
            while ((line = buf.readLine()) != null && !done) {
                if (line.trim().equals(this.getName())) {
                    gotCard = true;
                }
                if (gotCard && line.trim().length() > 0) {
                    sbuf.append(String.valueOf(line) + "\n");
                    continue;
                }
                if (!gotCard || line.trim().length() != 0) continue;
                done = true;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return sbuf.toString();
    }

    public boolean isInPlay() {
        return this.inPlay;
    }

    public void leavePlay() {
        this.inPlay = false;
    }

    public void setGame(CardGame game) {
        this.game = game;
    }

    public void setPlayer(CCGPlayer player) {
        this.player = player;
    }

    public abstract void setupImage();

    public void showMessage(String message) {
        this.game.broadcast(message);
    }
}

